/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.data;

import com.banknet.core.CorePlugin;
import com.banknet.core.data.Messages;
import com.banknet.core.internal.Constants;
import com.banknet.core.models.ScheduleItem;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class ScheduleList {
    Constants constants = new Constants();
    ScheduleItem scheduleItem;
    private List schedresults;
    private int schedcounter;
    private String schdDate;
    private int repeatTimes;
    private int repeatInterval;
    private String intervalType;
    long min = 60000L;
    long day = 86400000L;
    String STATUS_PENDINGADD = Messages.getString("ScheduleList.PendingAdd");
    boolean dupsfound = false;

    public ScheduleList() {
        this.schedresults = new ArrayList();
    }

    public void addScheduleItems() {
        this.dupsfound = false;
        TimeZone tz = Calendar.getInstance().getTimeZone();
        try {
            Date dschedDate = this.constants.yyyymmddhhmm2.parse(this.schdDate);
            this.addItem(dschedDate, this.STATUS_PENDINGADD);
            boolean saveTZone = tz.inDaylightTime(dschedDate);
            int dstOffset = 0;
            int dstMultiplier = 1;
            int i = 1;
            while (i < this.repeatTimes) {
                long litemdate = 0L;
                litemdate = this.intervalType.equals("minutes") ? dschedDate.getTime() + (long)this.repeatInterval * this.min : dschedDate.getTime() + (long)this.repeatInterval * this.day;
                Date tempdate = new Date(litemdate);
                if (saveTZone == tz.inDaylightTime(tempdate)) {
                    dstOffset = 0;
                } else {
                    dstMultiplier = saveTZone ? 1 : -1;
                    dstOffset = tz.getDSTSavings() * dstMultiplier;
                }
                dschedDate = this.constants.yyyymmddhhmm2.parse(this.constants.yyyymmddhhmm2.format(litemdate += (long)dstOffset));
                this.addItem(dschedDate, this.STATUS_PENDINGADD);
                saveTZone = tz.inDaylightTime(dschedDate);
                ++i;
            }
        }
        catch (ParseException ex) {
            String logstr = "addScheduleItems: schdDate: " + this.schdDate + " : Error Parsing Date " + ex;
            System.out.println("ScheduleList - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
    }

    public void addItem(Date dschedDate, String schedStatus) {
        String itemaction = "";
        itemaction = this.chkDupItems(dschedDate);
        if (itemaction.equals("add")) {
            this.scheduleItem = new ScheduleItem();
            this.scheduleItem.setCheckitem("");
            this.scheduleItem.setAddtosched(true);
            this.scheduleItem.setDatetime(dschedDate);
            this.scheduleItem.setStatus(schedStatus);
            this.schedresults.add(this.scheduleItem);
        }
    }

    public String chkDupItems(Date currdatetime) {
        String itemaction = "add";
        int i = 0;
        while (i < this.schedresults.size()) {
            if (((ScheduleItem)this.schedresults.get(i)).getDatetime().equals(currdatetime)) {
                if (!((ScheduleItem)this.schedresults.get(i)).getAddtosched()) {
                    ((ScheduleItem)this.schedresults.get(i)).setAddtosched(true);
                    itemaction = "changed";
                } else {
                    itemaction = "dup";
                    this.dupsfound = true;
                    return itemaction;
                }
            }
            ++i;
        }
        return itemaction;
    }

    public int getSchedCounter() {
        return this.schedcounter;
    }

    public List getSchedResults() {
        return this.schedresults;
    }

    public boolean getDupsFound() {
        return this.dupsfound;
    }

    public void setSchdDate(String schdDate) {
        this.schdDate = schdDate;
    }

    public void setRepeatTimes(String repeatTimes) {
        this.repeatTimes = repeatTimes.length() <= 0 ? 1 : new Integer(repeatTimes);
    }

    public void setRepeatInterval(String repeatInterval) {
        this.repeatInterval = repeatInterval.length() <= 0 ? 0 : new Integer(repeatInterval);
    }

    public void setIntervalType(String intervalType) {
        this.intervalType = intervalType;
    }
}

