/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.data;

import com.banknet.core.CorePlugin;
import com.banknet.core.internal.Constants;
import com.banknet.core.internal.ZosSession;
import com.banknet.core.models.ActiveJobsItem;
import java.nio.ByteBuffer;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class PidInfo {
    byte[] bRespBuffer;
    ActiveJobsItem activeJobsItem;
    private List jobresults;
    private int jobcounter;
    public List selectedjobs;
    String pid;
    String system;
    Constants constants = new Constants();
    public String SLAJPE_Jobname = "";
    public String SLAJPE_JobType = "";
    public String SLAJPE_ASID = "";
    public String SLAJPE_ASIDX = "";
    public String SLAJPE_PID = "";
    public String SLAJPE_PIDX = "";
    public String SLAJPE_SysName = "";

    public void getPidInfo(String pid, String spxSystem, IProgressMonitor monitor) throws Exception {
        this.pid = pid;
        this.system = spxSystem.equals("*") ? "" : spxSystem;
        this.getRemotePidInfo(monitor);
    }

    public void getRemotePidInfo(IProgressMonitor monitor) throws Exception {
        String[] commandarr = new String[]{String.valueOf(this.constants.ZOSMESSAGE_GETPIDINFO) + " " + this.pid + "," + this.system};
        String logstr = "PidInfo: Running " + commandarr[0];
        System.out.println(logstr);
        CorePlugin.getDefault().log.debug("PidInfo:  getRemotePidInfo,  " + logstr);
        this.bRespBuffer = CorePlugin.getDefault().session.doCmdResp(commandarr[0], CorePlugin.getDefault().getPreferenceStore().getString("dataSource"));
        ByteBuffer bbRespBuffer = ByteBuffer.wrap(this.bRespBuffer);
        ZosSession cfr_ignored_0 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_1 = CorePlugin.getDefault().session;
        bbRespBuffer.getInt(ZosSession.bnetHeaderOffset + ZosSession.tcpipHeaderOffset + 2);
        ZosSession cfr_ignored_2 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_3 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_4 = CorePlugin.getDefault().session;
        int iLen = bbRespBuffer.getInt(ZosSession.bnetHeaderOffset + ZosSession.tcpipHeaderOffset + ZosSession.lseHeaderOffset_len);
        CorePlugin.getDefault().session.checkResponse();
        if (CorePlugin.getDefault().session.getReturnCode() >= 1000) {
            logstr = "getRemotePidInfo:  Connect error " + CorePlugin.getDefault().session.getReturnCode() + ", set connect local";
            System.out.println("PidInfo - " + logstr);
            CorePlugin.getDefault().log.debug(logstr);
            return;
        }
        if (CorePlugin.getDefault().session.getReturnCode() != 0) {
            logstr = "getPidInfo: error RC - " + CorePlugin.getDefault().session.getReturnCode();
            System.out.println("PidInfo - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            return;
        }
        if (bbRespBuffer.limit() <= 0) {
            return;
        }
        bbRespBuffer.clear();
        ZosSession cfr_ignored_5 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_6 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_7 = CorePlugin.getDefault().session;
        int offset = ZosSession.bnetHeaderOffset + ZosSession.lseHeaderOffset + ZosSession.tcpipHeaderOffset;
        try {
            this.SLAJPE_Jobname = this.byteBufToString(offset + Integer.parseInt("0", 16), 8);
            this.SLAJPE_JobType = this.byteBufToString(offset + Integer.parseInt("8", 16), 1);
            if (this.SLAJPE_JobType.equalsIgnoreCase("J")) {
                this.SLAJPE_JobType = "JOB";
            } else if (this.SLAJPE_JobType.equalsIgnoreCase("S")) {
                this.SLAJPE_JobType = "STC";
            } else if (this.SLAJPE_JobType.equalsIgnoreCase("T")) {
                this.SLAJPE_JobType = "TSU";
            }
            this.SLAJPE_ASID = this.byteBufToString(offset + Integer.parseInt("9", 16), 5);
            this.SLAJPE_ASIDX = this.byteBufToString(offset + Integer.parseInt("E", 16), 8);
            this.SLAJPE_PID = this.byteBufToString(offset + Integer.parseInt("16", 16), 8);
            this.SLAJPE_PIDX = this.byteBufToString(offset + Integer.parseInt("1E", 16), 8);
            this.SLAJPE_SysName = this.byteBufToString(offset + Integer.parseInt("26", 16), 8);
            System.out.println(String.valueOf(this.SLAJPE_Jobname) + " " + this.SLAJPE_JobType + " " + this.SLAJPE_ASID + " " + this.SLAJPE_ASIDX + " " + this.SLAJPE_PID + " " + this.SLAJPE_PIDX + " " + this.SLAJPE_SysName);
            offset += iLen;
        }
        catch (NumberFormatException ex) {
            System.out.println("PidInfo format exception " + ex);
        }
    }

    private String byteBufToString(int offset, int length) {
        ByteBuffer bbRespBuffer = ByteBuffer.wrap(this.bRespBuffer);
        byte[] ba = new byte[length];
        int j = 0;
        while (j < length) {
            ba[j] = bbRespBuffer.get(offset + j);
            ++j;
        }
        String sValue = new String(ba).trim();
        return sValue;
    }
}

