/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.data;

import com.banknet.core.CorePlugin;
import com.banknet.core.data.Messages;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ParseUtilities {
    private ByteBuffer bbRespBuffer;
    public boolean cicsExtractor;
    public boolean cicsiExtractor;
    public boolean imsExtractor;
    public boolean imsiExtractor;
    public boolean db2Extractor;
    public boolean db2iExtractor;
    public boolean db2vExtractor;
    public boolean db2xExtractor;
    public boolean cdb2Extractor;
    public boolean mqsExtractor;
    public boolean javaExtractor;
    public boolean naturalExtractor;
    public boolean adabasExtractor;
    public boolean wasExtractor;
    public boolean ussFeature;
    public boolean srbExtractor;
    public boolean mqiExtractor;
    public boolean sysExtractor;
    public boolean wlpExtractor;
    public boolean wasServantSampling;
    public boolean ltbe64;

    public String byteBufToString(int offset, int length) {
        byte[] ba = new byte[length];
        int j = 0;
        while (j < length) {
            ba[j] = this.bbRespBuffer.get(offset + j);
            ++j;
        }
        String sValue = new String(ba).trim();
        return sValue;
    }

    public String byteBufToString(int offset, int length, char codepage) {
        byte[] ba = new byte[length];
        String sValue = null;
        int j = 0;
        while (j < length) {
            ba[j] = this.bbRespBuffer.get(offset + j);
            ++j;
        }
        try {
            sValue = new String(ba, CorePlugin.getDefault().getPreferenceStore().getString("codePage"));
        }
        catch (Exception e) {
            String logstr = "byteBufToString: offset: " + offset + ", length: " + length + ", codepage: " + codepage + " : Exception " + e;
            System.out.println("ParseUtiities - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
        return sValue;
    }

    public void setBbRespBuffer(ByteBuffer bbRespBuffer) {
        this.bbRespBuffer = bbRespBuffer;
    }

    public Date parseSTCK(long lSTCK) {
        Date dSTCK = new Date();
        String sSTCK = Long.toHexString(lSTCK).trim();
        try {
            dSTCK = new SimpleDateFormat("yyyyMMddHHmmssSS").parse(sSTCK);
        }
        catch (Exception e) {
            String logstr = "parseSTCK: STCK: " + lSTCK + " : Error Parsing Date " + e;
            System.out.println("ParseUtiities - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
        return dSTCK;
    }

    public boolean checkSelect(byte[] selectFlags, String fieldName) {
        int result;
        if (fieldName.equals("pme_stepnbr") && (result = 0x40 & selectFlags[0]) == 64) {
            return true;
        }
        if (fieldName.equals("pme_stepname") && (result = 0x20 & selectFlags[0]) == 32) {
            return true;
        }
        if (fieldName.equals("pme_procstep") && (result = 0x10 & selectFlags[0]) == 16) {
            return true;
        }
        if (fieldName.equals("pme_progname") && (result = 8 & selectFlags[0]) == 8) {
            return true;
        }
        if (fieldName.equals("pme_select_act") && (result = 4 & selectFlags[0]) == 4) {
            return true;
        }
        if (fieldName.equals("pme_select_cicsy") && (result = 2 & selectFlags[0]) == 2) {
            return true;
        }
        return fieldName.equals("pme_select_mstep") && (result = 1 & selectFlags[0]) == 1;
    }

    public int checkStepType(byte[] stepType) {
        int returnVal = 0;
        int result = 0x20 & stepType[0];
        if (result == 32) {
            returnVal = 32;
        }
        if ((result = 0x40 & stepType[0]) == 64) {
            returnVal = 64;
        }
        if ((result = 0x80 & stepType[0]) == 128) {
            returnVal = 128;
        }
        return returnVal;
    }

    public String checkScheduleFlags(byte[] schedflag) {
        String retString = " ";
        int result = 0xC0 & schedflag[0];
        if (result == 192) {
            retString = Messages.getString("ParseUtilities.Schedflag.ScheduledOrExpired");
        }
        if ((result = 0x80 & schedflag[0]) == 128) {
            retString = Messages.getString("ParseUtilities.Schedflag.Scheduled");
        }
        if ((result = 0x40 & schedflag[0]) == 64) {
            retString = Messages.getString("ParseUtilities.Schedflag.Expired");
        }
        return retString;
    }

    public void parsePME_flags4(byte[] pme_flags4) {
        int result = 0;
        this.wasServantSampling = false;
        result = 0x20 & pme_flags4[0];
        if (result == 32) {
            this.wasServantSampling = true;
        }
    }

    public boolean parsePME_flags5(byte[] pme_flags5) {
        int result = 0;
        this.ltbe64 = false;
        result = 0x10 & pme_flags5[0];
        if (result == 16) {
            this.ltbe64 = true;
        }
        return this.ltbe64;
    }

    public boolean parsePME_flagse(byte[] pme_flagse, String flage_test) {
        int result;
        if (flage_test == "flage_Err" && (result = 0x10 & pme_flagse[0]) == 16) {
            return true;
        }
        return flage_test == "flage_UDSN" && (result = 8 & pme_flagse[0]) == 8;
    }

    public void buildExtractors(int iFeatures) {
        this.cicsExtractor = false;
        this.cicsiExtractor = false;
        this.imsExtractor = false;
        this.db2Extractor = false;
        this.mqsExtractor = false;
        this.ussFeature = false;
        this.db2iExtractor = false;
        this.imsiExtractor = false;
        this.javaExtractor = false;
        this.db2vExtractor = false;
        this.db2xExtractor = false;
        this.cdb2Extractor = false;
        this.adabasExtractor = false;
        this.naturalExtractor = false;
        this.wasExtractor = false;
        this.srbExtractor = false;
        this.mqiExtractor = false;
        this.sysExtractor = false;
        this.wlpExtractor = false;
        int result = 2 & iFeatures;
        if (result == 2) {
            this.cicsExtractor = true;
        }
        if ((result = 4 & iFeatures) == 4) {
            this.imsExtractor = true;
        }
        if ((result = 8 & iFeatures) == 8) {
            this.db2Extractor = true;
        }
        if ((result = 0x10 & iFeatures) == 16) {
            this.mqsExtractor = true;
        }
        if ((result = 0x40 & iFeatures) == 64) {
            this.naturalExtractor = true;
        }
        if ((result = 0x200 & iFeatures) == 512) {
            this.db2iExtractor = true;
        }
        if ((result = 0x400 & iFeatures) == 1024) {
            this.imsiExtractor = true;
        }
        if ((result = 0x800 & iFeatures) == 2048) {
            this.javaExtractor = true;
        }
        if ((result = 0x2000 & iFeatures) == 8192) {
            this.db2vExtractor = true;
        }
        if ((result = 0x4000 & iFeatures) == 16384) {
            this.adabasExtractor = true;
        }
        if ((result = 0x8000 & iFeatures) == 32768) {
            this.cdb2Extractor = true;
        }
        if ((result = 0x20000 & iFeatures) == 131072) {
            this.cicsiExtractor = true;
        }
        if ((result = 0x40000 & iFeatures) == 262144) {
            this.wasExtractor = true;
        }
        if ((result = 0x80000 & iFeatures) == 524288) {
            this.db2xExtractor = true;
        }
        if ((result = 0x100000 & iFeatures) == 0x100000) {
            this.srbExtractor = true;
        }
        if ((result = 0x200000 & iFeatures) == 0x200000) {
            this.mqiExtractor = true;
        }
        if ((result = 0x400000 & iFeatures) == 0x400000) {
            this.sysExtractor = true;
        }
        if ((result = 0x800000 & iFeatures) == 0x800000) {
            this.wlpExtractor = true;
        }
    }
}

