/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.data;

import com.banknet.core.CorePlugin;
import com.banknet.core.data.Messages;
import com.banknet.core.data.ParseUtilities;
import com.banknet.core.internal.Constants;
import com.banknet.core.internal.ZosSession;
import com.banknet.core.models.ObservationsModel;
import com.banknet.core.models.PmexType2Item;
import com.banknet.core.models.PmexType3Item;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.eclipse.core.runtime.IProgressMonitor;

public class ObservationsList {
    Constants constants = new Constants();
    ParseUtilities parseutils = new ParseUtilities();
    public final String STATUS_FORMAT_LONG = "long";
    public final String STATUS_FORMAT_SHORT = "short";
    boolean displayField;
    byte[] bRespBuffer;
    int lrecl = 2048;
    SimpleDateFormat dtfmt = new SimpleDateFormat("yyyyMMddHHmmssSS");
    SimpleDateFormat dtfmtlist = new SimpleDateFormat("EEEE MMM dd yyyy HH:mm:00.00");
    public Integer iReqnum;
    public Integer iReqlink;
    ObservationsModel parent;
    ObservationsModel obsmodel;
    ObservationsModel obsmodels;
    ObservationsModel root = new ObservationsModel(null);
    List<String> listOrphanReq = new ArrayList<String>();
    Date tmpdate;
    Date requestDate;
    int pme_m_steparrctr;
    int pme_m_schdarrctr;
    byte[] pmex_h_type = new byte[1];
    int reqnum;
    byte[] pme_flagse = new byte[1];
    boolean errMsgStatus = false;

    public ObservationsModel getObservationsList(IProgressMonitor monitor) throws Exception {
        if (CorePlugin.getDefault().activeStc.length() <= 0) {
            return this.obsmodels;
        }
        this.getRemoteObservationsList(monitor);
        if (this.listOrphanReq.size() > 0) {
            this.setOrphanReq();
        }
        this.obsmodels = this.root;
        return this.obsmodels;
    }

    public void getRemoteObservationsList(IProgressMonitor monitor) throws Exception {
        String logstr;
        String[] commandarr = new String[2];
        CorePlugin.getDefault().observations.add(this.root);
        CorePlugin.getDefault().observationId.add(0);
        commandarr[0] = String.valueOf(this.constants.ZOSMESSAGE_CONNSTC) + " " + CorePlugin.getDefault().activeStc;
        commandarr[1] = String.valueOf(this.constants.ZOSMESSAGE_GETOBSLIST) + " " + CorePlugin.getDefault().getPreferenceStore().getString("filterOwnedby") + "," + CorePlugin.getDefault().getPreferenceStore().getString("filterJobname") + "," + "SORTBYNUM";
        if (CorePlugin.getDefault().getPreferenceStore().getString("dataSource").compareToIgnoreCase("remote") >= 0) {
            logstr = "getRemoteObservationsList:  Running " + commandarr[0];
            System.out.println("ObservationList - " + logstr);
            CorePlugin.getDefault().log.debug(logstr);
            CorePlugin.getDefault().session.doCmdResp(commandarr[0], CorePlugin.getDefault().getPreferenceStore().getString("dataSource"));
            CorePlugin.getDefault().session.checkResponse();
            if (CorePlugin.getDefault().session.getReturnCode() >= 1000) {
                return;
            }
            if (CorePlugin.getDefault().session.getReturnCode() != 0) {
                logstr = "getRemoteObservationList:  error RC - " + CorePlugin.getDefault().session.getReturnCode();
                System.out.println("ObservationList - " + logstr);
                CorePlugin.getDefault().log.error(logstr);
                return;
            }
        }
        logstr = "getRemoteObservationsList:  Running " + commandarr[1];
        System.out.println("ObservationList - " + logstr);
        CorePlugin.getDefault().log.debug(logstr);
        this.bRespBuffer = CorePlugin.getDefault().session.doCmdResp(commandarr[1], CorePlugin.getDefault().getPreferenceStore().getString("dataSource"));
        ByteBuffer bbRespBuffer = ByteBuffer.wrap(this.bRespBuffer);
        CorePlugin.getDefault().session.checkResponse();
        if (CorePlugin.getDefault().session.getReturnCode() >= 1000) {
            return;
        }
        if (CorePlugin.getDefault().session.getReturnCode() != 0) {
            logstr = "getRemoteObservationList:  error RC - " + CorePlugin.getDefault().session.getReturnCode();
            System.out.println("ObservationList - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            return;
        }
        this.parseutils.setBbRespBuffer(bbRespBuffer);
        this.parseObservationsList(bbRespBuffer);
    }

    public void parseObservationsList(ByteBuffer bbRespBuffer) throws Exception {
        short newLen = 0;
        bbRespBuffer.clear();
        ZosSession cfr_ignored_0 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_1 = CorePlugin.getDefault().session;
        int iNumber = bbRespBuffer.getInt(ZosSession.bnetHeaderOffset + ZosSession.tcpipHeaderOffset + 2);
        ZosSession cfr_ignored_2 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_3 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_4 = CorePlugin.getDefault().session;
        int iLen = bbRespBuffer.getInt(ZosSession.bnetHeaderOffset + ZosSession.tcpipHeaderOffset + ZosSession.lseHeaderOffset_len);
        int cfr_ignored_5 = iNumber / 4;
        ZosSession cfr_ignored_6 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_7 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_8 = CorePlugin.getDefault().session;
        int offset = ZosSession.bnetHeaderOffset + ZosSession.lseHeaderOffset + ZosSession.tcpipHeaderOffset;
        Byte[] bSSLOE_version = new Byte[]{bbRespBuffer.get(offset + Integer.parseInt("2", 16))};
        int ssloe_version = bSSLOE_version[0].intValue();
        System.out.println("**THE PME VERSION IS " + ssloe_version);
        int i = 0;
        while (i < iNumber) {
            this.obsmodel = null;
            try {
                if (iLen == 0) {
                    newLen = bbRespBuffer.getShort(offset + 0);
                    ZosSession cfr_ignored_9 = CorePlugin.getDefault().session;
                    offset += ZosSession.ssloeOffset;
                }
                String sVariant = this.byteBufToString(offset + Integer.parseInt("18", 16), 1);
                char cVariant = sVariant.charAt(0);
                switch (cVariant) {
                    case 'P': {
                        this.parsePME(offset, ssloe_version);
                        break;
                    }
                    case 'X': {
                        this.parsePMEX(offset);
                        break;
                    }
                    default: {
                        this.parsePME(offset, ssloe_version);
                        break;
                    }
                }
            }
            catch (Exception e) {
                try {
                    int pme_reqnbr;
                    this.reqnum = pme_reqnbr = bbRespBuffer.getInt(offset + Integer.parseInt("0", 16));
                    String logstr = "getRemoteObservationList:  skipped observation reqnum " + this.reqnum + ", error exception: " + e;
                    System.out.println("ObservationList - " + logstr);
                    CorePlugin.getDefault().log.error(logstr);
                }
                catch (Exception exception) {}
                this.obsmodel = null;
            }
            if (this.obsmodel != null) {
                this.obsmodel.setDeleteDays();
                if (this.iReqlink > 0) {
                    this.obsmodel.walkUpTree();
                }
                this.obsmodel.setReportsAvail();
                this.obsmodel.setStickyNotes();
                this.obsmodel.setTreeLevel();
                if (this.iReqlink > 0) {
                    this.obsmodel.setWasServantObsDsname();
                    this.obsmodels = CorePlugin.getDefault().observations.get(CorePlugin.getDefault().observationId.indexOf(this.iReqlink));
                    this.obsmodels.child.add(this.obsmodel);
                } else {
                    this.obsmodels = this.root;
                    this.obsmodels.child.add(this.obsmodel);
                }
                CorePlugin.getDefault().observations.add(this.obsmodel);
                CorePlugin.getDefault().observationId.add(this.iReqnum);
            }
            if (iLen == 0) {
                ZosSession cfr_ignored_10 = CorePlugin.getDefault().session;
                offset = offset + newLen - ZosSession.ssloeOffset;
            } else {
                offset += iLen;
            }
            ++i;
        }
    }

    private void parsePME(int offset, int ssloe_version) {
        String pme_status_short;
        String pme_status_long;
        String pme_IMS_IMSId;
        String pme_IMS_IMSTranCode;
        boolean JVFnd;
        short run_again_mins;
        String pme_desc;
        String pme_systems;
        String pme_progname;
        String pme_procstep;
        String pme_stepname;
        String pme_userid;
        String pme_variant;
        String sStatus;
        int pme_reqnbr;
        ByteBuffer bbRespBuffer = ByteBuffer.wrap(this.bRespBuffer);
        int overlay_offset = 0;
        if (ssloe_version == 2) {
            overlay_offset = 4;
        }
        if (ssloe_version == 3 || ssloe_version == 4) {
            overlay_offset = 28;
            overlay_offset += 128;
        }
        if (ssloe_version >= 5) {
            overlay_offset = 207;
            overlay_offset += 256;
        }
        this.reqnum = pme_reqnbr = bbRespBuffer.getInt(offset + Integer.parseInt("0", 16));
        this.iReqnum = 0;
        this.iReqnum = pme_reqnbr;
        int pme_reqlink = bbRespBuffer.getInt(offset + Integer.parseInt("4", 16));
        if (pme_reqlink == this.reqnum) {
            pme_reqlink = 0;
        }
        this.iReqlink = 0;
        this.iReqlink = pme_reqlink;
        this.parent = this.root;
        if (this.iReqlink > 0) {
            try {
                this.parent = CorePlugin.getDefault().observations.get(CorePlugin.getDefault().observationId.indexOf(this.iReqlink));
            }
            catch (Exception exception) {
                String logstr = "parsePME:  observation reqnum " + this.reqnum + ", linked reqnum " + this.iReqlink + " not found, added to orphans list.";
                System.out.println("ObservationList - " + logstr);
                this.listOrphanReq.add(this.iReqnum + "," + this.iReqlink);
                this.iReqlink = 0;
                this.parent = this.root;
            }
        }
        this.obsmodel = new ObservationsModel(this.parent);
        this.obsmodel.reqnum = this.iReqnum;
        this.obsmodel.reqlink = this.iReqlink;
        Date pme_stck_req = null;
        long lSTCK = bbRespBuffer.getLong(offset + Integer.parseInt("8", 16));
        this.obsmodel.reqdate = pme_stck_req = this.parseutils.parseSTCK(lSTCK);
        this.tmpdate = pme_stck_req;
        this.requestDate = pme_stck_req;
        int pme_samples_done = bbRespBuffer.getInt(offset + Integer.parseInt("10", 16));
        this.obsmodel.samplesDone = new Integer(pme_samples_done);
        byte[] pme_version = new byte[]{bbRespBuffer.get(offset + Integer.parseInt("14", 16))};
        byte[] pme_pmex_type = new byte[]{bbRespBuffer.get(offset + Integer.parseInt("15", 16))};
        byte[] bpme_reason = new byte[]{bbRespBuffer.get(offset + Integer.parseInt("16", 16))};
        byte pme_reason = bpme_reason[0];
        this.obsmodel.reasonCode = pme_reason;
        String pme_status = new String();
        this.obsmodel.statusCode = pme_status = (sStatus = this.byteBufToString(offset + Integer.parseInt("17", 16), 1));
        this.obsmodel.variant = pme_variant = this.byteBufToString(offset + Integer.parseInt("18", 16), 1);
        byte[] pme_select = new byte[]{bbRespBuffer.get(offset + Integer.parseInt("19", 16))};
        this.obsmodel.ownedby = pme_userid = this.byteBufToString(offset + Integer.parseInt("1A", 16), 8);
        String pme_jobname = this.byteBufToString(offset + Integer.parseInt("22", 16), 8);
        if (pme_jobname.length() == 8 && pme_variant.equals("J") && !pme_jobname.contains("%")) {
            pme_jobname = pme_jobname.concat("%");
        }
        this.obsmodel.jobname = pme_jobname;
        int pme_stepnbr = bbRespBuffer.getInt(offset + Integer.parseInt("2A", 16));
        this.displayField = this.parseutils.checkSelect(pme_select, "pme_stepnbr");
        if (!this.displayField) {
            pme_stepnbr = 0;
        }
        this.obsmodel.stepNum = new Integer(pme_stepnbr);
        String wrk_stepname = pme_stepname = this.byteBufToString(offset + Integer.parseInt("2E", 16), 8);
        this.displayField = this.parseutils.checkSelect(pme_select, "pme_stepname");
        if (!this.displayField) {
            pme_stepname = "";
        }
        this.obsmodel.stepName = new String(pme_stepname);
        String wrk_procstep = pme_procstep = this.byteBufToString(offset + Integer.parseInt("36", 16), 8);
        this.displayField = this.parseutils.checkSelect(pme_select, "pme_procstep");
        if (!this.displayField) {
            pme_procstep = "";
        }
        this.obsmodel.procStep = new String(pme_procstep);
        String wrk_progname = pme_progname = this.byteBufToString(offset + Integer.parseInt("3E", 16), 8);
        this.displayField = this.parseutils.checkSelect(pme_select, "pme_progname");
        if (!this.displayField) {
            pme_progname = "";
        }
        this.obsmodel.progName = new String(pme_progname);
        String pme_select_mstep = "";
        this.displayField = false;
        if (pme_variant.equals("T")) {
            try {
                int pme_lrecl = 337;
                int offset_to_PME_TM_Flags = 722;
                int offset_to_flags = pme_lrecl + overlay_offset + offset_to_PME_TM_Flags;
                byte pme_tm_flags = bbRespBuffer.get(offset + offset_to_flags);
                int result = 0x40 & pme_tm_flags;
                this.displayField = result == 64 ? true : this.parseutils.checkSelect(pme_select, "pme_select_mstep");
            }
            catch (Exception exception) {}
        }
        if (this.displayField) {
            pme_select_mstep = Messages.getString("ObservationsList.Step.AllSteps");
        }
        this.obsmodel.selectMstep = pme_select_mstep;
        this.obsmodel.system = pme_systems = this.byteBufToString(offset + Integer.parseInt("46", 16), 8);
        int pme_interval = bbRespBuffer.getInt(offset + Integer.parseInt("4E", 16));
        this.obsmodel.interval = pme_interval;
        int pme_samples = bbRespBuffer.getInt(offset + Integer.parseInt("52", 16));
        this.obsmodel.samples = pme_samples;
        int pme_duration = bbRespBuffer.getInt(offset + Integer.parseInt("56", 16));
        this.obsmodel.duration = pme_duration;
        int pme_features = bbRespBuffer.getInt(offset + Integer.parseInt("5A", 16));
        this.parseutils.buildExtractors(pme_features);
        this.obsmodel.cicsExtractor = new Boolean(this.parseutils.cicsExtractor);
        this.obsmodel.cicsiExtractor = new Boolean(this.parseutils.cicsiExtractor);
        this.obsmodel.imsExtractor = new Boolean(this.parseutils.imsExtractor);
        this.obsmodel.imsiExtractor = new Boolean(this.parseutils.imsiExtractor);
        this.obsmodel.db2Extractor = new Boolean(this.parseutils.db2Extractor);
        this.obsmodel.db2iExtractor = new Boolean(this.parseutils.db2iExtractor);
        this.obsmodel.db2vExtractor = new Boolean(this.parseutils.db2vExtractor);
        this.obsmodel.db2xExtractor = new Boolean(this.parseutils.db2xExtractor);
        this.obsmodel.cdb2Extractor = new Boolean(this.parseutils.cdb2Extractor);
        this.obsmodel.mqseriesExtractor = new Boolean(this.parseutils.mqsExtractor);
        this.obsmodel.javaExtractor = new Boolean(this.parseutils.javaExtractor);
        this.obsmodel.naturalExtractor = new Boolean(this.parseutils.naturalExtractor);
        this.obsmodel.adabasExtractor = new Boolean(this.parseutils.adabasExtractor);
        this.obsmodel.srbExtractor = new Boolean(this.parseutils.srbExtractor);
        this.obsmodel.mqiExtractor = new Boolean(this.parseutils.mqiExtractor);
        this.obsmodel.sysExtractor = new Boolean(this.parseutils.sysExtractor);
        this.obsmodel.wlpExtractor = new Boolean(this.parseutils.wlpExtractor);
        Date pme_exp_date = null;
        lSTCK = bbRespBuffer.getLong(offset + Integer.parseInt("5E", 16));
        if (lSTCK > 0L) {
            pme_exp_date = this.parseutils.parseSTCK(lSTCK);
        }
        this.obsmodel.sessionDeleteDate = pme_exp_date;
        this.obsmodel.description = pme_desc = this.byteBufToString(offset + Integer.parseInt("66", 16), 48);
        int pme_te_samp = bbRespBuffer.getInt(offset + Integer.parseInt("96", 16));
        if (pme_jobname.equals("-")) {
            String pme_sspr_type = this.byteBufToString(offset + Integer.parseInt("9A", 16), 1);
            String pme_sspr_subsys = this.byteBufToString(offset + Integer.parseInt("9B", 16), 4);
            String[] work_sspr_schema = this.byteBufToString(offset + Integer.parseInt("9F", 16), 70).split(" ");
            String pme_sspr_schema = work_sspr_schema[0];
            String[] temp_sspr_name = this.byteBufToString(offset + Integer.parseInt("E5", 16), 70).split(" ");
            String pme_sspr_name = temp_sspr_name[0];
            boolean pme_ssrp_isGroupName = false;
            int sspr_FgrpNm = 128;
            byte[] pme_sspr_flags = new byte[]{bbRespBuffer.get(offset + Integer.parseInt("17B", 16))};
            int result = sspr_FgrpNm & pme_sspr_flags[0];
            if (result == 128) {
                pme_ssrp_isGroupName = true;
            }
            this.obsmodel.db2Type = pme_sspr_type;
            this.obsmodel.db2Subsystem = pme_sspr_subsys;
            this.obsmodel.db2Schema = pme_sspr_schema;
            this.obsmodel.db2Name = pme_sspr_name;
            this.obsmodel.db2IsGroup = pme_ssrp_isGroupName;
        } else {
            this.obsmodel.db2Type = "";
            this.obsmodel.db2Subsystem = "";
            this.obsmodel.db2Schema = "";
            this.obsmodel.db2Name = "";
            this.obsmodel.db2IsGroup = false;
        }
        bbRespBuffer.getShort(offset + Integer.parseInt("12B", 16));
        byte[] pme_select1 = new byte[]{bbRespBuffer.get(offset + Integer.parseInt("12D", 16))};
        String pme_spxservsys = this.byteBufToString(offset + Integer.parseInt("12E", 16), 8);
        byte[] pme_delete_flag = new byte[]{bbRespBuffer.get(offset + Integer.parseInt("136", 16))};
        if (pme_delete_flag[0] == 1) {
            // empty if block
        }
        this.obsmodel.deleteFlag = pme_delete_flag;
        short pme_run_again_mins = 0;
        pme_run_again_mins = run_again_mins = bbRespBuffer.getShort(offset + Integer.parseInt("137", 16));
        this.obsmodel.runAgainMins = pme_run_again_mins;
        byte pme_run_again_for = 0;
        byte[] run_again_for = new byte[]{bbRespBuffer.get(offset + Integer.parseInt("139", 16))};
        pme_run_again_for = run_again_for[0];
        this.obsmodel.runAgainFor = pme_run_again_for;
        byte pme_run_again_ctr = 0;
        byte[] run_again_ctr = new byte[]{bbRespBuffer.get(offset + Integer.parseInt("13A", 16))};
        byte pme_repeat_times = run_again_ctr[0];
        pme_run_again_ctr = run_again_ctr[0];
        this.obsmodel.runAgainCtr = pme_run_again_ctr;
        String pme_origsysname = this.byteBufToString(offset + Integer.parseInt("13B", 16), 8);
        byte[] pme_flags2 = new byte[]{bbRespBuffer.get(offset + Integer.parseInt("143", 16))};
        boolean USSStp = this.checkFlags2(pme_flags2, "USSStp");
        byte[] pme_flags3 = new byte[]{bbRespBuffer.get(offset + Integer.parseInt("144", 16))};
        boolean bRAG = this.checkFlags3(pme_flags3, "RAG");
        boolean bMJob = false;
        bMJob = this.checkFlags3(pme_flags3, "MJob");
        String flags3_type = "";
        if (bMJob) {
            flags3_type = "MJob";
        }
        this.obsmodel.flags3Type = flags3_type;
        this.obsmodel.importedObservation = this.checkFlags3(pme_flags3, "Imprt");
        this.obsmodel.cdb2 = this.checkFlags3(pme_flags3, "CDB2");
        String r02_desc = "";
        if (pme_reqlink > 0) {
            r02_desc = String.valueOf(wrk_progname) + "   " + wrk_stepname + "   " + wrk_procstep;
            if (r02_desc.trim().length() <= 0) {
                r02_desc = pme_desc;
            }
        } else {
            r02_desc = pme_desc;
        }
        if (bMJob) {
            r02_desc = "";
        } else if (USSStp && (JVFnd = this.checkFlags2(pme_flags2, "JVFnd"))) {
            r02_desc = String.valueOf(r02_desc) + " *Java*";
        }
        this.obsmodel.r02Description = r02_desc;
        if (bRAG) {
            long lReqTime = this.tmpdate.getTime();
            long lMinute = pme_run_again_mins;
            long lOffset = lMinute * 60L * 1000L;
            long schedTime = lReqTime + lOffset;
            Date dRepeatDateTime = new Date(schedTime);
            this.obsmodel.repeatTimes = pme_repeat_times > 0 ? Integer.valueOf(pme_repeat_times) : null;
            this.obsmodel.repeatBeforeDate = pme_run_again_mins > 0 ? dRepeatDateTime : null;
        } else {
            this.obsmodel.repeatTimes = null;
            this.obsmodel.repeatBeforeDate = null;
        }
        int pme_trgd_reqnum = bbRespBuffer.getInt(offset + Integer.parseInt("145", 16));
        this.obsmodel.triggers = pme_trgd_reqnum;
        int pme_ptrg_reqnum = bbRespBuffer.getInt(offset + Integer.parseInt("149", 16));
        this.obsmodel.triggeredBy = pme_ptrg_reqnum;
        bbRespBuffer.getShort(offset + Integer.parseInt("14D", 16));
        bbRespBuffer.getShort(offset + Integer.parseInt("14F", 16));
        this.obsmodel.imsTranCode = pme_IMS_IMSTranCode = this.byteBufToString(offset + Integer.parseInt("102", 16), 8);
        this.obsmodel.imsSubsystemId = pme_IMS_IMSId = this.byteBufToString(offset + Integer.parseInt("151", 16), 4);
        String pme_IMS_TxnCode = "";
        String pme_IMS_ProgName = "";
        String pme_IMS_UserId = "";
        String pme_jobid = "";
        if (ssloe_version > 2) {
            int pme_ext;
            pme_IMS_TxnCode = this.byteBufToString(offset + Integer.parseInt("155", 16), 8);
            pme_IMS_ProgName = this.byteBufToString(offset + Integer.parseInt("15D", 16), 8);
            pme_IMS_UserId = this.byteBufToString(offset + Integer.parseInt("165", 16), 8);
            byte[] pme_flags4 = new byte[]{bbRespBuffer.get(offset + Integer.parseInt("16D", 16))};
            this.parseutils.parsePME_flags4(pme_flags4);
            this.obsmodel.pmexReqnum = pme_ext = bbRespBuffer.getInt(offset + Integer.parseInt("16E", 16));
            try {
                pme_jobid = this.byteBufToString(offset + Integer.parseInt("172", 16), 8);
                if (!pme_jobid.matches("^([A-Za-z]|[0-9])+$")) {
                    pme_jobid = "";
                }
            }
            catch (Exception exception) {}
            this.errMsgStatus = false;
            try {
                this.pme_flagse[0] = bbRespBuffer.get(offset + Integer.parseInt("17A", 16));
                this.errMsgStatus = this.parseutils.parsePME_flagse(this.pme_flagse, "flage_Err");
            }
            catch (Exception exception) {}
            boolean ltbe64 = false;
            try {
                byte[] pme_flags5 = new byte[]{bbRespBuffer.get(offset + Integer.parseInt("17E", 16))};
                ltbe64 = this.parseutils.parsePME_flags5(pme_flags5);
            }
            catch (Exception exception) {}
            this.obsmodel.ltbe64 = ltbe64;
        }
        if (ssloe_version >= 5) {
            String pme_notes1 = this.byteBufToString(offset + Integer.parseInt("17F", 16), 48);
            String pme_notes2 = this.byteBufToString(offset + Integer.parseInt("1AF", 16), 48);
            String pme_notes3 = this.byteBufToString(offset + Integer.parseInt("1DF", 16), 48);
            if (pme_notes1.length() > 0 || pme_notes2.length() > 0 || pme_notes3.length() > 0) {
                this.obsmodel.notes1 = pme_notes1.trim();
                this.obsmodel.notes2 = pme_notes2.trim();
                this.obsmodel.notes3 = pme_notes3.trim();
            }
        }
        this.obsmodel.jobid = pme_jobid;
        this.obsmodel.imsTxnCode = pme_IMS_TxnCode;
        this.obsmodel.imsProgramName = pme_IMS_ProgName;
        this.obsmodel.imsUserId = pme_IMS_UserId;
        this.obsmodel.wasExtractor = new Boolean(this.parseutils.wasExtractor);
        this.obsmodel.wasServantSampling = new Boolean(this.parseutils.wasServantSampling);
        String racfSysname = "?";
        racfSysname = pme_spxservsys.trim().length() == 0 ? (pme_systems.trim().length() == 0 || pme_systems.trim().equals("*") ? (pme_origsysname.trim().length() == 0 ? "?" : pme_origsysname.trim()) : pme_systems.trim()) : pme_spxservsys.trim();
        this.obsmodel.validateSystem = new String(racfSysname);
        char cVariant = pme_variant.charAt(0);
        switch (cVariant) {
            case 'I': {
                this.parsePME_I_Overlay(offset + overlay_offset);
                break;
            }
            case 'M': {
                this.parsePME_M_Overlay(offset + overlay_offset);
                break;
            }
            case 'T': {
                this.parsePME_T_Overlay(offset + overlay_offset);
                break;
            }
            case 'X': {
                break;
            }
            default: {
                this.parsePME_Overlay(offset + overlay_offset, pme_variant, pme_status);
            }
        }
        int iSamples = pme_samples_done;
        if (pme_status.equalsIgnoreCase("W") || pme_status.equalsIgnoreCase("A")) {
            iSamples = pme_te_samp;
        }
        if (pme_variant.equalsIgnoreCase("X") && this.pmex_h_type[0] == 1) {
            iSamples = pme_te_samp;
        }
        if (iSamples == 0) {
            iSamples = pme_samples;
        }
        if (pme_status.equalsIgnoreCase("X")) {
            iSamples = pme_samples_done;
        }
        this.obsmodel.r02Samples = iSamples;
        this.obsmodel.statusLong = pme_status_long = this.buildStatusDescription(pme_status, pme_variant, "long", bRAG);
        this.obsmodel.statusShort = pme_status_short = this.buildStatusDescription(pme_status, pme_variant, "short", bRAG);
    }

    private void parsePME_Overlay(int offset, String sVariant, String sStatus) {
        String pme_dsname;
        ByteBuffer bbRespBuffer = ByteBuffer.wrap(this.bRespBuffer);
        long lsSTCK = 0L;
        long leSTCK = 0L;
        Date pme_stck_start = null;
        Date pme_stck_end = null;
        if (sVariant.equals("P") && (sStatus.equalsIgnoreCase("C") || sStatus.equalsIgnoreCase("F") || sStatus.equalsIgnoreCase("X") || sStatus.equalsIgnoreCase("I"))) {
            lsSTCK = bbRespBuffer.getLong(offset + Integer.parseInt("151", 16));
            if (lsSTCK > 0L) {
                pme_stck_start = this.parseutils.parseSTCK(lsSTCK);
            }
            if ((leSTCK = bbRespBuffer.getLong(offset + Integer.parseInt("159", 16))) > 0L) {
                pme_stck_end = this.parseutils.parseSTCK(leSTCK);
            }
        }
        this.obsmodel.sessionStart = pme_stck_start;
        this.obsmodel.sessionEnd = pme_stck_end;
        Long lDSTCKDuration = null;
        if (pme_stck_start != null && pme_stck_end != null) {
            String sSTCKStart = Long.toHexString(lsSTCK);
            String sESTCKEnd = Long.toHexString(leSTCK);
            lDSTCKDuration = this.computeDuration(sSTCKStart, sESTCKEnd);
        }
        this.obsmodel.sessionDuration = lDSTCKDuration;
        boolean UDSN_status = false;
        try {
            UDSN_status = this.parseutils.parsePME_flagse(this.pme_flagse, "flage_UDSN");
        }
        catch (Exception exception) {}
        this.obsmodel.udsn = UDSN_status;
        this.obsmodel.dsname = pme_dsname = this.byteBufToString(offset + Integer.parseInt("161", 16), 44);
        Short work_asid = bbRespBuffer.getShort(offset + Integer.parseInt("18D", 16));
        String lc_asid = Integer.toHexString(work_asid.shortValue());
        String pme_asid = lc_asid.toUpperCase();
        int i = pme_asid.length();
        while (i < 4) {
            pme_asid = "0" + pme_asid;
            ++i;
        }
        if (pme_asid.equalsIgnoreCase("0000")) {
            pme_asid = "";
        }
        this.obsmodel.asid = pme_asid;
        Date datetime = null;
        datetime = pme_stck_end != null ? (pme_stck_end.compareTo(this.tmpdate) < 0 ? this.tmpdate : pme_stck_end) : this.tmpdate;
        this.obsmodel.sessionDateTime = datetime;
        this.obsmodel.thresSettings = null;
        this.obsmodel.stepsSched = 0;
        this.obsmodel.itemsSched = 0;
        this.obsmodel.stepInfo = null;
        this.obsmodel.schedInfo = null;
    }

    private void parsePME_I_Overlay(int offset) {
        this.obsmodel.thresSettings = null;
        this.obsmodel.stepsSched = 0;
        this.obsmodel.itemsSched = 0;
        this.obsmodel.stepInfo = null;
        this.obsmodel.schedInfo = null;
        this.obsmodel.sessionStart = null;
        this.obsmodel.sessionEnd = null;
        this.obsmodel.sessionDuration = null;
        this.obsmodel.dsname = "";
        this.obsmodel.asid = "";
        this.obsmodel.sessionDateTime = this.tmpdate;
    }

    private void parsePME_M_Overlay(int offset) {
        ByteBuffer bbRespBuffer = ByteBuffer.wrap(this.bRespBuffer);
        this.obsmodel.sessionEnd = null;
        this.obsmodel.sessionDuration = null;
        this.obsmodel.dsname = "";
        this.obsmodel.asid = "";
        this.obsmodel.sessionDateTime = this.tmpdate;
        Short tmp_m_steparrctr = bbRespBuffer.getShort(offset + Integer.parseInt("151", 16));
        this.pme_m_steparrctr = tmp_m_steparrctr.shortValue();
        this.obsmodel.stepsSched = this.pme_m_steparrctr;
        Short tmp_m_schdarrctr = bbRespBuffer.getShort(offset + Integer.parseInt("30B", 16));
        this.pme_m_schdarrctr = tmp_m_schdarrctr.shortValue();
        this.obsmodel.itemsSched = this.pme_m_schdarrctr;
        boolean skipStepArray = false;
        if (this.pme_m_schdarrctr > 0 || this.pme_m_steparrctr < 0) {
            skipStepArray = true;
        }
        if (!skipStepArray) {
            int j = 0;
            String[] stepTextArr = new String[this.pme_m_steparrctr];
            String stepProgName = "";
            String stepStepName = "";
            String stepProcName = "";
            byte[] bStepType = new byte[1];
            int i = 0;
            while (i < this.pme_m_steparrctr) {
                this.byteBufToString(offset + Integer.parseInt("153", 16) + j, 22);
                bStepType[0] = bbRespBuffer.get(offset + Integer.parseInt("153", 16) + j + 21);
                int iStepType = this.parseutils.checkStepType(bStepType);
                if (iStepType == 128) {
                    short stepNum = bbRespBuffer.getShort(offset + Integer.parseInt("153", 16) + j);
                    String cfr_ignored_0 = String.valueOf(Messages.getString("ObservationsList.Step.StepNumber")) + stepNum;
                    stepTextArr[i] = String.valueOf(Messages.getString("ObservationsList.Step.StepNumber")) + stepNum;
                }
                if (iStepType == 64) {
                    stepProgName = "";
                    stepProgName = this.byteBufToString(offset + Integer.parseInt("153", 16) + j, 8);
                    String cfr_ignored_1 = String.valueOf(Messages.getString("ObservationsList.Step.ProgName")) + stepProgName;
                    stepTextArr[i] = String.valueOf(Messages.getString("ObservationsList.Step.ProgName")) + stepProgName;
                }
                if (iStepType == 32) {
                    stepStepName = this.byteBufToString(offset + Integer.parseInt("153", 16) + j, 8);
                    stepProcName = this.byteBufToString(offset + Integer.parseInt("153", 16) + j + 8, 8);
                    if (stepProcName.equals("")) {
                        String cfr_ignored_2 = String.valueOf(Messages.getString("ObservationsList.Step.StepName")) + stepStepName;
                        stepTextArr[i] = String.valueOf(Messages.getString("ObservationsList.Step.StepName")) + stepStepName;
                    } else {
                        String cfr_ignored_3 = String.valueOf(Messages.getString("ObservationsList.Step.StepName")) + stepStepName + Messages.getString("ObservationsList.Step.ProcStep") + stepProcName;
                        stepTextArr[i] = String.valueOf(Messages.getString("ObservationsList.Step.StepName")) + stepStepName + Messages.getString("ObservationsList.Step.ProcStep") + stepProcName;
                    }
                }
                j += 22;
                ++i;
            }
            this.obsmodel.stepInfo = stepTextArr;
        } else {
            this.obsmodel.stepInfo = null;
        }
        bbRespBuffer.getShort(offset + Integer.parseInt("30D", 16));
        byte[] pme_m_retryafter = new byte[]{bbRespBuffer.get(offset + Integer.parseInt("30F", 16))};
        byte[] pme_m_retrytimes = new byte[]{bbRespBuffer.get(offset + Integer.parseInt("310", 16))};
        int j = 0;
        String[] schedTextArr = new String[this.pme_m_schdarrctr];
        int i = 0;
        while (i < this.pme_m_schdarrctr) {
            this.byteBufToString(offset + Integer.parseInt("311", 16) + j, 3);
            byte[] schedByte = new byte[]{bbRespBuffer.get(offset + Integer.parseInt("311", 16) + j)};
            String sched = this.parseutils.checkScheduleFlags(schedByte);
            byte[] minuteBytes = new byte[4];
            minuteBytes[0] = bbRespBuffer.get(offset + Integer.parseInt("311", 16) + j);
            Integer minuteNibble = 0;
            minuteNibble = minuteBytes[0] & 0xF;
            minuteBytes[0] = 0;
            minuteBytes[1] = minuteNibble.byteValue();
            minuteBytes[2] = bbRespBuffer.get(offset + Integer.parseInt("311", 16) + j + 1);
            minuteBytes[3] = bbRespBuffer.get(offset + Integer.parseInt("311", 16) + j + 2);
            ByteBuffer minuteBuf = ByteBuffer.wrap(minuteBytes);
            int iMinute = minuteBuf.getInt();
            long lReqTime = this.tmpdate.getTime();
            long lMinute = iMinute;
            long lOffset = lMinute * 60L * 1000L;
            long schedTime = lReqTime + lOffset;
            Date dSchedDateTime = new Date(schedTime);
            TimeZone tz = Calendar.getInstance().getTimeZone();
            boolean isTodayDST = TimeZone.getDefault().inDaylightTime(new Date());
            boolean isSchedDateDST = TimeZone.getDefault().inDaylightTime(dSchedDateTime);
            boolean isReqDateDST = TimeZone.getDefault().inDaylightTime(this.requestDate);
            int dstOffset = 0;
            int dstMultiplier = 0;
            if (isTodayDST && !isReqDateDST && isSchedDateDST) {
                dstMultiplier = -1;
            }
            if (isTodayDST && isReqDateDST && !isSchedDateDST) {
                dstMultiplier = 1;
            }
            if (!isTodayDST && !isReqDateDST && isSchedDateDST) {
                dstMultiplier = -1;
            }
            if (!isTodayDST && isReqDateDST && !isSchedDateDST) {
                dstMultiplier = 1;
            }
            dstOffset = tz.getDSTSavings() * dstMultiplier;
            schedTime = lReqTime + lOffset + (long)dstOffset;
            dSchedDateTime = new Date(schedTime);
            String sSchedDateTime = this.dtfmtlist.format(dSchedDateTime);
            String cfr_ignored_4 = String.valueOf(sSchedDateTime) + " " + sched;
            schedTextArr[i] = String.valueOf(sSchedDateTime) + "|" + sched + "| | ";
            j += 3;
            ++i;
        }
        this.obsmodel.schedInfo = this.pme_m_schdarrctr > 0 ? schedTextArr : null;
        this.obsmodel.thresSettings = null;
    }

    private void parsePME_T_Overlay(int offset) {
        ByteBuffer bbRespBuffer = ByteBuffer.wrap(this.bRespBuffer);
        this.obsmodel.sessionStart = null;
        this.obsmodel.sessionEnd = null;
        this.obsmodel.sessionDuration = null;
        this.obsmodel.dsname = "";
        this.obsmodel.asid = "";
        this.obsmodel.stepsSched = 0;
        this.obsmodel.itemsSched = 0;
        this.obsmodel.stepInfo = null;
        this.obsmodel.schedInfo = null;
        this.obsmodel.sessionDateTime = this.tmpdate;
        Short pme_tm_sel_dsmll = bbRespBuffer.getShort(offset + Integer.parseInt("151", 16));
        String pme_tm_sel_dsml = this.byteBufToString(offset + Integer.parseInt("153", 16), pme_tm_sel_dsmll.shortValue());
        this.obsmodel.thresSettings = new String(pme_tm_sel_dsml);
    }

    private void parsePMEX(int offset) {
        ByteBuffer bbRespBuffer = ByteBuffer.wrap(this.bRespBuffer);
        byte[] pmex_type = new byte[]{bbRespBuffer.get(offset + Integer.parseInt("D", 16))};
        switch (pmex_type[0]) {
            case 1: {
                this.parsePMEXType1(offset);
                break;
            }
            case 2: {
                this.parsePMEXType2(offset);
                break;
            }
            case 3: {
                this.parsePMEXType3(offset);
                break;
            }
        }
    }

    private void parsePMEXType1(int offset) {
        String pme_status_short;
        String pme_status_long;
        String pme_desc_x;
        String pme_systems_x;
        String pme_stepname_x;
        String pme_jobname_x;
        String pme_userid_x;
        String pmex_variant_h;
        String sStatus;
        ByteBuffer bbRespBuffer = ByteBuffer.wrap(this.bRespBuffer);
        long lSTCK = 0L;
        long lsSTCK = 0L;
        long leSTCK = 0L;
        int pmex_h_reqnbr = bbRespBuffer.getInt(offset + Integer.parseInt("0", 16));
        this.iReqnum = 0;
        this.iReqnum = new Integer(pmex_h_reqnbr);
        this.iReqlink = 0;
        this.parent = this.root;
        if (this.iReqlink == this.reqnum) {
            this.iReqlink = 0;
        }
        if (this.iReqlink > 0) {
            try {
                this.parent = CorePlugin.getDefault().observations.get(CorePlugin.getDefault().observationId.indexOf(this.iReqlink));
            }
            catch (Exception exception) {
                String logstr = "parsePMEXType1:  observation reqnum " + this.reqnum + ", linked reqnum " + this.iReqlink + " not found, added to orphans list.";
                System.out.println("ObservationList - " + logstr);
                this.listOrphanReq.add(this.iReqnum + "," + this.iReqlink);
                this.iReqlink = 0;
                this.parent = this.root;
            }
        }
        this.obsmodel = new ObservationsModel(this.parent);
        this.obsmodel.reqnum = this.iReqnum;
        this.obsmodel.reqlink = this.iReqlink;
        Date pme_stck_req_x = null;
        lSTCK = bbRespBuffer.getLong(offset + Integer.parseInt("4", 16));
        this.obsmodel.reqdate = pme_stck_req_x = this.parseutils.parseSTCK(lSTCK);
        this.tmpdate = pme_stck_req_x;
        byte[] pmex_h_version = new byte[]{bbRespBuffer.get(offset + Integer.parseInt("C", 16))};
        this.pmex_h_type[0] = bbRespBuffer.get(offset + Integer.parseInt("D", 16));
        this.byteBufToString(offset + Integer.parseInt("E", 16), 8);
        byte[] pmex_h_flags = new byte[]{bbRespBuffer.get(offset + Integer.parseInt("16", 16))};
        String pme_h_status = new String();
        this.obsmodel.statusCode = pme_h_status = (sStatus = this.byteBufToString(offset + Integer.parseInt("17", 16), 1));
        this.obsmodel.variant = pmex_variant_h = this.byteBufToString(offset + Integer.parseInt("18", 16), 1);
        byte[] pme_select_x = new byte[]{bbRespBuffer.get(offset + Integer.parseInt("19", 16))};
        this.obsmodel.ownedby = pme_userid_x = this.byteBufToString(offset + Integer.parseInt("1A", 16), 8);
        this.obsmodel.jobname = pme_jobname_x = this.byteBufToString(offset + Integer.parseInt("22", 16), 8);
        int pme_stepnbr_x = bbRespBuffer.getInt(offset + Integer.parseInt("2A", 16));
        this.obsmodel.stepNum = pme_stepnbr_x;
        this.obsmodel.stepName = pme_stepname_x = this.byteBufToString(offset + Integer.parseInt("2E", 16), 8);
        String pme_procstep_x = this.byteBufToString(offset + Integer.parseInt("36", 16), 8);
        this.obsmodel.procStep = new String(pme_procstep_x);
        String pme_progname_x = this.byteBufToString(offset + Integer.parseInt("3E", 16), 8);
        this.obsmodel.progName = new String(pme_progname_x);
        String pme_select_mstep_x = "";
        this.displayField = this.parseutils.checkSelect(pme_select_x, "pme_select_mstep_x");
        if (this.displayField) {
            pme_select_mstep_x = Messages.getString("ObservationsList.Step.AllSteps");
        }
        this.obsmodel.selectMstep = new String(pme_select_mstep_x);
        this.obsmodel.system = pme_systems_x = this.byteBufToString(offset + Integer.parseInt("46", 16), 8);
        int pme_interval_x = bbRespBuffer.getInt(offset + Integer.parseInt("4E", 16));
        this.obsmodel.interval = pme_interval_x;
        int pme_samples_x = bbRespBuffer.getInt(offset + Integer.parseInt("52", 16));
        this.obsmodel.samples = pme_samples_x;
        this.obsmodel.r02Samples = pme_samples_x;
        int pme_duration_x = bbRespBuffer.getInt(offset + Integer.parseInt("56", 16));
        this.obsmodel.duration = pme_duration_x;
        int pme_features_x = bbRespBuffer.getInt(offset + Integer.parseInt("5A", 16));
        this.parseutils.buildExtractors(pme_features_x);
        this.obsmodel.cicsExtractor = new Boolean(this.parseutils.cicsExtractor);
        this.obsmodel.cicsiExtractor = new Boolean(this.parseutils.cicsiExtractor);
        this.obsmodel.imsExtractor = new Boolean(this.parseutils.imsExtractor);
        this.obsmodel.imsiExtractor = new Boolean(this.parseutils.imsiExtractor);
        this.obsmodel.db2Extractor = new Boolean(this.parseutils.db2Extractor);
        this.obsmodel.db2iExtractor = new Boolean(this.parseutils.db2iExtractor);
        this.obsmodel.db2vExtractor = new Boolean(this.parseutils.db2vExtractor);
        this.obsmodel.db2xExtractor = new Boolean(this.parseutils.db2xExtractor);
        this.obsmodel.cdb2Extractor = new Boolean(this.parseutils.cdb2Extractor);
        this.obsmodel.mqseriesExtractor = new Boolean(this.parseutils.mqsExtractor);
        this.obsmodel.javaExtractor = new Boolean(this.parseutils.javaExtractor);
        this.obsmodel.naturalExtractor = new Boolean(this.parseutils.naturalExtractor);
        this.obsmodel.adabasExtractor = new Boolean(this.parseutils.adabasExtractor);
        this.obsmodel.wasExtractor = new Boolean(this.parseutils.wasExtractor);
        this.obsmodel.wasServantSampling = new Boolean(this.parseutils.wasServantSampling);
        this.obsmodel.srbExtractor = new Boolean(this.parseutils.srbExtractor);
        this.obsmodel.mqiExtractor = new Boolean(this.parseutils.mqiExtractor);
        this.obsmodel.sysExtractor = new Boolean(this.parseutils.sysExtractor);
        this.obsmodel.wlpExtractor = new Boolean(this.parseutils.wlpExtractor);
        Date pme_exp_date_x = null;
        lSTCK = bbRespBuffer.getLong(offset + Integer.parseInt("5E", 16));
        if (lSTCK > 0L) {
            pme_exp_date_x = this.parseutils.parseSTCK(lSTCK);
        }
        this.obsmodel.sessionDeleteDate = pme_exp_date_x;
        this.obsmodel.description = pme_desc_x = this.byteBufToString(offset + Integer.parseInt("66", 16), 48);
        this.obsmodel.r02Description = pme_desc_x;
        bbRespBuffer.getShort(offset + Integer.parseInt("96", 16));
        String pme_spxservsys_x = this.byteBufToString(offset + Integer.parseInt("98", 16), 8);
        byte[] pme_delete_flag_x = new byte[]{bbRespBuffer.get(offset + Integer.parseInt("A0", 16))};
        if (pme_delete_flag_x[0] == 1) {
            // empty if block
        }
        this.obsmodel.deleteFlag = pme_delete_flag_x;
        String pme_origsysname_x = this.byteBufToString(offset + Integer.parseInt("A1", 16), 8);
        byte[] pme_flags2_x = new byte[]{bbRespBuffer.get(offset + Integer.parseInt("A9", 16))};
        byte[] pme_flags3_x = new byte[]{bbRespBuffer.get(offset + Integer.parseInt("AA", 16))};
        boolean bRAG = this.checkFlags3(pme_flags3_x, "RAG");
        boolean bMJob = false;
        bMJob = this.checkFlags3(pme_flags3_x, "MJob");
        String flags3_type = "";
        if (bMJob) {
            flags3_type = "MJob";
        }
        this.obsmodel.flags3Type = flags3_type;
        this.obsmodel.importedObservation = this.checkFlags3(pme_flags3_x, "Imprt");
        this.obsmodel.cdb2 = this.checkFlags3(pme_flags3_x, "CDB2");
        int pme_trgd_reqnum_x = bbRespBuffer.getInt(offset + Integer.parseInt("AB", 16));
        this.obsmodel.triggers = pme_trgd_reqnum_x;
        int pme_ptrg_reqnum_x = bbRespBuffer.getInt(offset + Integer.parseInt("AF", 16));
        this.obsmodel.triggeredBy = pme_ptrg_reqnum_x;
        bbRespBuffer.getShort(offset + Integer.parseInt("B3", 16));
        bbRespBuffer.getShort(offset + Integer.parseInt("B5", 16));
        Date pme_stck_start_x = null;
        Date pme_stck_end_x = null;
        if (pme_h_status.equalsIgnoreCase("C")) {
            lsSTCK = bbRespBuffer.getLong(offset + Integer.parseInt("B7", 16));
            if (lsSTCK > 0L) {
                pme_stck_start_x = this.parseutils.parseSTCK(lsSTCK);
            }
            if ((leSTCK = bbRespBuffer.getLong(offset + Integer.parseInt("BF", 16))) > 0L) {
                pme_stck_end_x = this.parseutils.parseSTCK(leSTCK);
            }
        }
        this.obsmodel.sessionStart = pme_stck_start_x;
        this.obsmodel.sessionEnd = pme_stck_end_x;
        Long lDSTCKDuration = null;
        if (pme_stck_start_x != null && pme_stck_end_x != null) {
            String sSTCKStart = Long.toHexString(lsSTCK);
            String sESTCKEnd = Long.toHexString(leSTCK);
            lDSTCKDuration = this.computeDuration(sSTCKStart, sESTCKEnd);
        }
        this.obsmodel.sessionDuration = lDSTCKDuration;
        String pme_dsname_x = this.byteBufToString(offset + Integer.parseInt("C7", 16), 8);
        this.obsmodel.dsname = new String(pme_dsname_x);
        Short work_asid = bbRespBuffer.getShort(offset + Integer.parseInt("F3", 16));
        String lc_asid = Integer.toHexString(work_asid.shortValue());
        String pme_asid_x = lc_asid.toUpperCase();
        int i = pme_asid_x.length();
        while (i < 4) {
            pme_asid_x = "0" + pme_asid_x;
            ++i;
        }
        if (pme_asid_x.equalsIgnoreCase("0000")) {
            pme_asid_x = "";
        }
        this.obsmodel.asid = new String(pme_asid_x);
        String pme_notes1 = this.byteBufToString(offset + Integer.parseInt("F5", 16), 48);
        String pme_notes2 = this.byteBufToString(offset + Integer.parseInt("125", 16), 48);
        String pme_notes3 = this.byteBufToString(offset + Integer.parseInt("155", 16), 48);
        if (pme_notes1.length() > 0 || pme_notes2.length() > 0 || pme_notes3.length() > 0) {
            this.obsmodel.notes1 = pme_notes1;
            this.obsmodel.notes2 = pme_notes2;
            this.obsmodel.notes3 = pme_notes3;
        }
        this.obsmodel.jobid = "";
        this.obsmodel.statusLong = pme_status_long = this.buildStatusDescription(pme_h_status, pmex_variant_h, "long", bRAG);
        this.obsmodel.statusShort = pme_status_short = this.buildStatusDescription(pme_h_status, pmex_variant_h, "short", bRAG);
        this.obsmodel.reqlink = 0;
        this.obsmodel.samplesDone = 0;
        this.obsmodel.thresSettings = null;
        String racfSysname = "?";
        racfSysname = pme_spxservsys_x.trim().length() == 0 ? (pme_systems_x.trim().length() == 0 || pme_systems_x.trim().equals("*") ? (pme_origsysname_x.trim().length() == 0 ? "?" : pme_origsysname_x.trim()) : pme_systems_x.trim()) : pme_spxservsys_x.trim();
        this.obsmodel.validateSystem = new String(racfSysname);
        this.obsmodel.db2Type = "";
        this.obsmodel.db2Subsystem = "";
        this.obsmodel.db2Schema = "";
        this.obsmodel.db2Name = "";
        this.obsmodel.reasonCode = 22;
        this.obsmodel.stepsSched = 0;
        this.obsmodel.itemsSched = 0;
        this.obsmodel.stepInfo = null;
        this.obsmodel.schedInfo = null;
        this.obsmodel.repeatTimes = null;
        this.obsmodel.repeatBeforeDate = null;
        this.obsmodel.imsTranCode = "";
        this.obsmodel.imsSubsystemId = "";
        this.obsmodel.imsUserId = "";
        this.obsmodel.imsTxnCode = "";
        this.obsmodel.imsProgramName = "";
        this.obsmodel.imsUserId = "";
        this.obsmodel.pmexReqnum = 0;
        Date datetime = null;
        datetime = pme_stck_start_x != null ? pme_stck_start_x : this.tmpdate;
        this.obsmodel.sessionDateTime = datetime;
        this.obsmodel.runAgainMins = 0;
        this.obsmodel.runAgainFor = 0;
        this.obsmodel.runAgainCtr = 0;
    }

    private void parsePMEXType2(int offset) {
        ByteBuffer bbRespBuffer = ByteBuffer.wrap(this.bRespBuffer);
        int pmex_h_reqnbr = bbRespBuffer.getInt(offset + Integer.parseInt("0", 16));
        boolean pmex_was_img = false;
        String pmex_WasImg = this.byteBufToString(offset + Integer.parseInt("19", 16), 1);
        pmex_was_img = pmex_WasImg.equals("Y");
        boolean wasAppendReqWildcard = false;
        boolean wasAppendAppWildcard = false;
        boolean wasAppendOrgWildcard = false;
        byte PMEX_WasFflags = bbRespBuffer.get(offset + Integer.parseInt("1A", 16));
        int pmexWasFflags_result = 0x80 & PMEX_WasFflags;
        if (pmexWasFflags_result == 128) {
            wasAppendReqWildcard = true;
        }
        if ((pmexWasFflags_result = 0x40 & PMEX_WasFflags) == 64) {
            wasAppendAppWildcard = true;
        }
        if ((pmexWasFflags_result = 0x20 & PMEX_WasFflags) == 32) {
            wasAppendOrgWildcard = true;
        }
        Byte[] pmex_WasFexLen = new Byte[]{bbRespBuffer.get(offset + Integer.parseInt("1B", 16))};
        String pmex_WasFexTxt = null;
        if (pmex_WasFexLen[0].intValue() > 0) {
            pmex_WasFexTxt = this.byteBufToString(offset + Integer.parseInt("1C", 16), pmex_WasFexLen[0].intValue());
        }
        Byte[] pmex_WasReqLen = new Byte[]{bbRespBuffer.get(offset + Integer.parseInt("6B", 16))};
        String pmex_WasReqTxt = null;
        if (pmex_WasReqLen[0].intValue() > 0) {
            pmex_WasReqTxt = this.byteBufToString(offset + Integer.parseInt("6C", 16), pmex_WasReqLen[0].intValue());
            if (wasAppendReqWildcard) {
                pmex_WasReqTxt = pmex_WasReqTxt.concat("*");
            }
        }
        Byte[] pmex_WasAppLen = new Byte[]{bbRespBuffer.get(offset + Integer.parseInt("BB", 16))};
        String pmex_WasAppTxt = null;
        if (pmex_WasAppLen[0].intValue() > 0) {
            pmex_WasAppTxt = this.byteBufToString(offset + Integer.parseInt("BC", 16), pmex_WasAppLen[0].intValue());
            if (wasAppendAppWildcard) {
                pmex_WasAppTxt = pmex_WasAppTxt.concat("*");
            }
        }
        String pmex_was_origType = "";
        byte pmex_WasOrigTyp = bbRespBuffer.get(offset + Integer.parseInt("10B", 16));
        if (pmex_WasOrigTyp == 12) {
            this.constants.getClass();
            pmex_was_origType = "J";
        }
        if (pmex_WasOrigTyp == 8) {
            pmex_was_origType = this.constants.WASORIGINTYPE_HOST;
        }
        if (pmex_WasOrigTyp == 4) {
            pmex_was_origType = this.constants.WASORIGINTYPE_IPADR;
        }
        Byte[] pmex_WasOrigLen = new Byte[]{bbRespBuffer.get(offset + Integer.parseInt("10C", 16))};
        String pmex_WasOrigTxt = null;
        if (pmex_WasOrigLen[0].intValue() > 0) {
            pmex_WasOrigTxt = this.byteBufToString(offset + Integer.parseInt("10D", 16), pmex_WasOrigLen[0].intValue());
            if (wasAppendOrgWildcard) {
                pmex_WasOrigTxt = pmex_WasOrigTxt.concat("*");
            }
        }
        PmexType2Item wasitem = new PmexType2Item();
        wasitem.was_reqnum = pmex_h_reqnbr;
        wasitem.was_img = pmex_was_img;
        wasitem.was_req = pmex_WasReqTxt;
        wasitem.was_app = pmex_WasAppTxt;
        wasitem.was_origType = pmex_was_origType;
        wasitem.was_orig = pmex_WasOrigTxt;
        wasitem.was_fex = pmex_WasFexTxt;
        CorePlugin.getDefault().wasitems.put(pmex_h_reqnbr, wasitem);
    }

    private void parsePMEXType3(int offset) {
        ByteBuffer bbRespBuffer = ByteBuffer.wrap(this.bRespBuffer);
        int pmex_h_reqnbr = bbRespBuffer.getInt(offset + Integer.parseInt("0", 16));
        boolean wlpAppendReqWildcard = false;
        boolean wlpAppendOrgWildcard = false;
        byte PMEX_WlpFflags = bbRespBuffer.get(offset + Integer.parseInt("1A", 16));
        int pmexWlpFflags_result = 0x80 & PMEX_WlpFflags;
        if (pmexWlpFflags_result == 128) {
            wlpAppendReqWildcard = true;
        }
        if ((pmexWlpFflags_result = 0x20 & PMEX_WlpFflags) == 32) {
            wlpAppendOrgWildcard = true;
        }
        Byte[] pmex_WlpReqLen = new Byte[]{bbRespBuffer.get(offset + Integer.parseInt("6D", 16))};
        String pmex_WlpReqTxt = null;
        if (pmex_WlpReqLen[0].intValue() > 0) {
            pmex_WlpReqTxt = this.byteBufToString(offset + Integer.parseInt("6E", 16), pmex_WlpReqLen[0].intValue());
            if (wlpAppendReqWildcard) {
                pmex_WlpReqTxt = pmex_WlpReqTxt.concat("*");
            }
        }
        String pmex_wlp_origType = "";
        byte pmex_WlpOrigTyp = bbRespBuffer.get(offset + Integer.parseInt("10D", 16));
        if (pmex_WlpOrigTyp == 8) {
            pmex_wlp_origType = this.constants.WASORIGINTYPE_HOST;
        }
        if (pmex_WlpOrigTyp == 4) {
            pmex_wlp_origType = this.constants.WASORIGINTYPE_IPADR;
        }
        Byte[] pmex_WlpOrigLen = new Byte[]{bbRespBuffer.get(offset + Integer.parseInt("10E", 16))};
        String pmex_WlpOrigTxt = null;
        if (pmex_WlpOrigLen[0].intValue() > 0) {
            pmex_WlpOrigTxt = this.byteBufToString(offset + Integer.parseInt("10F", 16), pmex_WlpOrigLen[0].intValue());
            if (wlpAppendOrgWildcard) {
                pmex_WlpOrigTxt = pmex_WlpOrigTxt.concat("*");
            }
        }
        PmexType3Item wlpitem = new PmexType3Item();
        wlpitem.wlp_reqnum = pmex_h_reqnbr;
        wlpitem.wlp_req = pmex_WlpReqTxt;
        wlpitem.wlp_origType = pmex_wlp_origType;
        wlpitem.wlp_orig = pmex_WlpOrigTxt;
        CorePlugin.getDefault().wlpitems.put(pmex_h_reqnbr, wlpitem);
    }

    private String byteBufToString(int offset, int length) {
        ByteBuffer bbRespBuffer = ByteBuffer.wrap(this.bRespBuffer);
        byte[] ba = new byte[length];
        int j = 0;
        while (j < length) {
            ba[j] = bbRespBuffer.get(offset + j);
            ++j;
        }
        String sValue = new String(ba).trim();
        return sValue;
    }

    private String buildStatusDescription(String sStatusCode, String sVariant, String statusFmt, boolean bRAG) {
        String sStatus = new String();
        char cStatus = sStatusCode.charAt(0);
        char cVariant = sVariant.charAt(0);
        String appendplus = "";
        if (bRAG) {
            appendplus = " +";
        }
        if (!statusFmt.equalsIgnoreCase("short") || cStatus != 'F' && cStatus != 'I' && cStatus != 'X') {
            switch (cVariant) {
                case 'J': {
                    sStatus = Messages.getString("ObservationsList.Status.MultJb");
                    break;
                }
                case 'I': {
                    sStatus = Messages.getString("ObservationsList.Status.IMS");
                    break;
                }
                case 'M': {
                    if (this.pme_m_schdarrctr != 0) {
                        sStatus = Messages.getString("ObservationsList.Status.REPEAT");
                        break;
                    }
                    if (this.pme_m_steparrctr == 0) break;
                    sStatus = Messages.getString("ObservationsList.Status.Steps");
                    break;
                }
                case 'T': {
                    sStatus = Messages.getString("ObservationsList.Status.Thresh");
                    break;
                }
                case 'U': {
                    sStatus = Messages.getString("ObservationsList.Status.USS");
                    break;
                }
                case 'X': {
                    if (this.pmex_h_type[0] != 1) break;
                    if (statusFmt.equalsIgnoreCase("short")) {
                        sStatus = Messages.getString("ObservationsList.Status.Trig");
                        break;
                    }
                    sStatus = Messages.getString("ObservationsList.Status.Trigger");
                    break;
                }
            }
        }
        if (sStatus.length() == 0) {
            switch (cStatus) {
                case 'A': {
                    sStatus = Messages.getString("ObservationsList.Status.Active");
                    break;
                }
                case 'C': {
                    sStatus = Messages.getString("ObservationsList.Status.Ended");
                    break;
                }
                case 'D': {
                    sStatus = Messages.getString("ObservationsList.Status.Delete");
                    break;
                }
                case 'F': {
                    sStatus = Messages.getString("ObservationsList.Status.Failed");
                    break;
                }
                case 'I': {
                    sStatus = Messages.getString("ObservationsList.Status.Incomplete");
                    break;
                }
                case 'N': {
                    sStatus = Messages.getString("ObservationsList.Status.New");
                    break;
                }
                case 'W': {
                    sStatus = Messages.getString("ObservationsList.Status.Writing");
                    break;
                }
                case 'X': {
                    sStatus = Messages.getString("ObservationsList.Status.Cancelled");
                    break;
                }
                default: {
                    sStatus = "????";
                }
            }
            if (cStatus == 'C' && this.errMsgStatus) {
                sStatus = Messages.getString("ObservationsList.Status.Errmsg");
            }
        }
        sStatus = String.valueOf(sStatus) + appendplus;
        return sStatus;
    }

    public long computeDuration(String sSTCKStart, String sESTCKEnd) {
        long dDiff = 0L;
        try {
            sSTCKStart = String.valueOf(sSTCKStart) + "0";
            sESTCKEnd = String.valueOf(sESTCKEnd) + "0";
            Date dtSTCKStart = new SimpleDateFormat("yyyyMMddHHmmssSSS").parse(sSTCKStart);
            Date dtESTCKEnd = new SimpleDateFormat("yyyyMMddHHmmssSSS").parse(sESTCKEnd);
            long dDiffe = dtESTCKEnd.getTime();
            long dDiffs = dtSTCKStart.getTime();
            dDiff = dDiffe - dDiffs;
        }
        catch (Exception exception) {
            System.out.println("Date Parsing Error in computeDuration, reqnum: " + this.reqnum + ", sSTCKStart: " + sSTCKStart + ", sESTCKEnd: " + sESTCKEnd);
        }
        return dDiff;
    }

    private boolean checkFlags2(byte[] flags2, String flag) {
        boolean USSStp = false;
        boolean JVFnd = false;
        boolean returnVal = false;
        int result = 1 & flags2[0];
        if (result == 1) {
            // empty if block
        }
        if ((result = 2 & flags2[0]) == 2) {
            // empty if block
        }
        if ((result = 4 & flags2[0]) == 4) {
            // empty if block
        }
        if ((result = 8 & flags2[0]) == 8) {
            JVFnd = true;
        }
        if ((result = 0x10 & flags2[0]) == 16) {
            USSStp = true;
        }
        if ((result = 0x20 & flags2[0]) == 32) {
            // empty if block
        }
        if ((result = 0x40 & flags2[0]) == 64) {
            // empty if block
        }
        if ((result = 0x80 & flags2[0]) == 128) {
            // empty if block
        }
        if (flag == "USSStp" && USSStp) {
            returnVal = true;
        }
        if (flag == "JVFnd" && JVFnd) {
            returnVal = true;
        }
        return returnVal;
    }

    private boolean checkFlags3(byte[] flags3, String flag) {
        boolean ragsl = false;
        boolean ragcm = false;
        boolean multj = false;
        boolean imprt = false;
        boolean cdb2 = false;
        boolean returnVal = false;
        int result = 2 & flags3[0];
        if (result == 2) {
            cdb2 = true;
        }
        if ((result = 8 & flags3[0]) == 8) {
            imprt = true;
        }
        if ((result = 0x10 & flags3[0]) == 16) {
            // empty if block
        }
        if ((result = 0x20 & flags3[0]) == 32) {
            multj = true;
        }
        if ((result = 0x40 & flags3[0]) == 64) {
            ragcm = true;
        }
        if ((result = 0x80 & flags3[0]) == 128) {
            ragsl = true;
        }
        if (flag.equals("RAG") && ragsl && !ragcm) {
            returnVal = true;
        }
        if (flag.equals("MJob") && multj) {
            returnVal = true;
        }
        if (flag.toUpperCase().equals("IMPRT") && imprt) {
            returnVal = true;
        }
        if (flag.toUpperCase().equals("CDB2") && cdb2) {
            returnVal = true;
        }
        return returnVal;
    }

    private void setOrphanReq() {
        Integer orphanreq = 0;
        Integer orphanreqlink = 0;
        int i = 0;
        while (i < this.listOrphanReq.size()) {
            String[] orphanarr = this.listOrphanReq.get(i).split(",");
            orphanreq = new Integer(orphanarr[0]);
            orphanreqlink = new Integer(orphanarr[1]);
            ObservationsModel obsmodel = CorePlugin.getDefault().observations.get(CorePlugin.getDefault().observationId.indexOf(orphanreq));
            try {
                obsmodel.parent = this.parent = CorePlugin.getDefault().observations.get(CorePlugin.getDefault().observationId.indexOf(orphanreqlink));
                obsmodel.setDeleteDays();
                obsmodel.walkUpTree();
                obsmodel.setReportsAvail();
                obsmodel.setStickyNotes();
                obsmodel.setWasServantObsDsname();
                obsmodel.setTreeLevel();
                this.obsmodels = this.parent;
                this.obsmodels.child.add(obsmodel);
                this.obsmodels = this.root;
                this.obsmodels.child.remove(obsmodel);
            }
            catch (Exception exception) {
                String logstr = "setOrphanReq:  observation reqnum " + orphanreq + ", linked reqnum " + orphanreqlink + " orphaned.";
                System.out.println("ObservationList - " + logstr);
                CorePlugin.getDefault().log.error(logstr);
            }
            ++i;
        }
    }
}

