/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.data;

import com.banknet.core.CorePlugin;
import com.banknet.core.connection.ZosConnect;
import com.banknet.core.data.Messages;
import com.banknet.core.data.ParseUtilities;
import com.banknet.core.internal.Constants;
import com.banknet.core.internal.ZosSession;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.eclipse.core.runtime.IProgressMonitor;

public class ObservationDetail {
    Constants constants = new Constants();
    ParseUtilities parseutils = new ParseUtilities();
    ZosConnect zosconnect = new ZosConnect();
    public String commandLine = "";
    public String reqnum = "";
    public Integer ireqnum;
    public String pme_userid = "";
    public byte[] pme_version;
    int pme_version_4 = 4;
    public int pme_reqnbr;
    public String pme_jobname = "";
    public String pme_systems = "";
    public boolean activeJob;
    public int pme_samples;
    public int pme_duration;
    public boolean pme_flags_eos;
    public String pme_notify = "";
    public String pme_desc = "";
    public int pme_delay;
    public int pme_expdays;
    public int pme_ussmaxobs;
    public String pme_notes1 = "";
    public String pme_notes2 = "";
    public String pme_notes3 = "";
    public String pme_variant;
    public int pme_stepnbr;
    public String pme_progname;
    public String pme_stepname;
    public String pme_procstep;
    public int pme_features;
    public boolean cicsExtractor;
    public boolean cicsiExtractor;
    public boolean imsExtractor;
    public boolean imsiExtractor;
    public boolean db2Extractor;
    public boolean db2iExtractor;
    public boolean db2vExtractor;
    public boolean db2xExtractor;
    public boolean cdb2Extractor;
    public boolean mqsExtractor;
    public boolean mqiExtractor;
    public boolean javaExtractor;
    public boolean naturalExtractor;
    public boolean adabasExtractor;
    public boolean wasExtractor;
    public boolean ussFeature;
    public boolean srbExtractor;
    public boolean sysExtractor;
    public boolean wlpExtractor;
    public short pme_DB2IMaxTraceSize = 0;
    public short pme_IMSIMaxTraceSize = 0;
    public short pme_MQIMaxTraceSize = 0;
    public String pme_ARGDSN = "";
    public String pme_ARGMem = "";
    public boolean pme_flags_dirs;
    public String pme_dirs;
    public List<String> listLibs = new ArrayList<String>();
    public List<String> listSteps = new ArrayList<String>();
    public short pme_m_steparrctr = 0;
    public String stepProgName = "";
    public String stepStepName = "";
    public String stepProcName = "";
    public short stepNum;
    public String pme_cics_trans = "";
    public String pme_cics_termids = "";
    public String pme_cics_progs = "";
    public List<String> listCicsTrans = new ArrayList<String>();
    public List<String> listCicsTerms = new ArrayList<String>();
    public boolean buildCICSY = false;
    public boolean noncterm = true;
    public String pme_ims_txncode = "";
    public String pme_ims_progname = "";
    public String pme_ims_userid = "";
    public String pme_imsmass_txncode = "";
    public String pme_ims_subsystem = "";
    public String pme_ims_jobnames = "";
    public String pme_imsplex_group = "";
    public String pme_sspr_type = "";
    public String pme_sspr_subsys = "";
    public String pme_sspr_schema = "";
    public String pme_sspr_name = "";
    public boolean pme_ssrp_isGroupName = false;
    public boolean ddfsel = false;
    public String pme_db2_corrid = "";
    public String pme_db2_enduserid = "";
    public String pme_db2_wkstnid = "";
    public boolean pme_db2_corrid_isnull = false;
    public boolean pme_db2_enduserid_isnull = false;
    public boolean pme_db2_wkstnid_isnull = false;
    public boolean wasFilterSel = false;
    public String pme_was_req = "*";
    public String pme_was_app = "*";
    public String pme_was_orig = "*";
    public String pme_was_fex = "";
    public boolean pme_was_img = false;
    public String pme_was_origType = "";
    public boolean pme_was_origIpadr = false;
    public boolean pme_was_origHost = false;
    public boolean pme_was_origJob = true;
    public boolean wlpFilterSel = false;
    public String pme_wlp_req = "*";
    public String pme_wlp_orig = "*";
    public String pme_wlp_origType = "";
    public boolean pme_wlp_origIpadr = true;
    public boolean pme_wlp_origHost = false;
    public Short pme_m_schdarrctr;
    public String schedDate = "";
    public List<Date> listSchdDate = new ArrayList<Date>();
    public short pme_m_schdspan;
    public short pme_runagainmins;
    public short pme_runagainfor;
    public short pme_retryafter;
    public short pme_retrytimes;
    public Short pme_tm_sel_dsmll;
    public String pme_tm_sel_dsml;
    public boolean pme_tm_allsteps = false;
    public String tm_sel_cpu = "";
    public String tm_sel_elapsedtime = "";
    public String tm_sel_excp = "";
    public Date pme_stck_req = null;
    private String libName = "";
    public int ipme_ext;
    public String pme_ext;
    public byte[] bRespBuffer;
    IProgressMonitor progmonitor;

    public void getObservationDetail(Integer ireqnum, IProgressMonitor monitor) throws Exception {
        this.ireqnum = ireqnum;
        this.reqnum = CorePlugin.getDefault().constants.reqdecfmt.format(ireqnum);
        if (ireqnum != 0) {
            if (CorePlugin.getDefault().getPreferenceStore().getString("dataSource").compareToIgnoreCase("remote") >= 0) {
                this.getRemoteObservationDetail(monitor);
            } else {
                this.getLocalObservationDetail(monitor);
            }
        }
    }

    public void getLocalObservationDetail(IProgressMonitor monitor) throws Exception {
    }

    public void getRemoteObservationDetail(IProgressMonitor monitor) throws Exception {
        CorePlugin.getDefault().session.commandLine = "";
        this.progmonitor = monitor;
        String[] commandarr = new String[]{String.valueOf(this.constants.ZOSMESSAGE_GETOBSDETAIL) + " " + this.reqnum};
        String logstr = "getRemoteObservationDetail:  Running " + commandarr[0];
        System.out.println("ObservationDetail - " + logstr);
        CorePlugin.getDefault().log.debug(logstr);
        this.bRespBuffer = CorePlugin.getDefault().session.doCmdResp(commandarr[0], CorePlugin.getDefault().getPreferenceStore().getString("dataSource"));
        ByteBuffer bbRespBuffer = ByteBuffer.wrap(this.bRespBuffer);
        CorePlugin.getDefault().session.checkResponse();
        if (CorePlugin.getDefault().session.getReturnCode() >= 1000) {
            logstr = "getRemoteObservationDetail:  Connect error " + CorePlugin.getDefault().session.getReturnCode() + ", set connect local";
            System.out.println("ObservationDetail - " + logstr);
            CorePlugin.getDefault().log.debug(logstr);
            this.zosconnect.setConnectLocal();
            return;
        }
        if (CorePlugin.getDefault().session.getReturnCode() != 0) {
            logstr = "getRemoteObservationDetail:  error RC - " + CorePlugin.getDefault().session.getReturnCode();
            System.out.println("ObservationDetail - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            return;
        }
        this.parseutils.setBbRespBuffer(bbRespBuffer);
        this.parseObservationDetail(bbRespBuffer);
    }

    public void getTemplateDetail(String templateName, String templateScope, IProgressMonitor monitor) throws Exception {
        CorePlugin.getDefault().session.commandLine = "";
        this.progmonitor = monitor;
        String[] commandarr = new String[]{String.valueOf(this.constants.ZOSMESSAGE_GETTEMPLATEDETAIL) + " " + templateName + "," + templateScope};
        String logstr = "getRemoteTemplateDetail:  Running " + commandarr[0];
        System.out.println("ObservationDetail - " + logstr);
        CorePlugin.getDefault().log.debug(logstr);
        this.bRespBuffer = CorePlugin.getDefault().session.doCmdResp(commandarr[0], CorePlugin.getDefault().getPreferenceStore().getString("dataSource"));
        ByteBuffer bbRespBuffer = ByteBuffer.wrap(this.bRespBuffer);
        CorePlugin.getDefault().session.checkResponse();
        if (CorePlugin.getDefault().session.getReturnCode() >= 1000) {
            logstr = "getRemoteTemplateDetail:  Connect error " + CorePlugin.getDefault().session.getReturnCode() + ", set connect local";
            System.out.println("ObservationDetail - " + logstr);
            CorePlugin.getDefault().log.debug(logstr);
            this.zosconnect.setConnectLocal();
            return;
        }
        if (CorePlugin.getDefault().session.getReturnCode() != 0) {
            logstr = "getRemoteTemplateDetail:  error RC - " + CorePlugin.getDefault().session.getReturnCode();
            System.out.println("ObservationDetail - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            return;
        }
        this.parseutils.setBbRespBuffer(bbRespBuffer);
        this.parseObservationDetail(bbRespBuffer);
    }

    public void parseObservationDetail(ByteBuffer bbRespBuffer) throws Exception {
        int i;
        String pme_loads;
        ZosSession cfr_ignored_0 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_1 = CorePlugin.getDefault().session;
        int offset = ZosSession.bnetHeaderOffset + ZosSession.tcpipHeaderOffset;
        this.pme_version = new byte[1];
        this.pme_version[0] = bbRespBuffer.get(offset + Integer.parseInt("1C", 16));
        System.out.println("PME Version is  " + this.pme_version[0]);
        byte[] pme_flags = new byte[]{bbRespBuffer.get(offset + Integer.parseInt("39E", 16))};
        this.pme_reqnbr = bbRespBuffer.getInt(offset + Integer.parseInt("8", 16));
        Integer reqnum = this.pme_reqnbr;
        System.out.println("Request Number " + this.pme_reqnbr);
        this.pme_variant = this.parseutils.byteBufToString(offset + Integer.parseInt("29", 16), 1);
        System.out.println("PME Variant is  " + this.pme_variant);
        this.pme_userid = this.parseutils.byteBufToString(offset + Integer.parseInt("2C", 16), 8);
        System.out.println("Owned By " + this.pme_userid);
        this.pme_jobname = this.parseutils.byteBufToString(offset + Integer.parseInt("34", 16), 8);
        if (this.pme_jobname.length() == 8 && this.pme_variant.equals("J") && !this.pme_jobname.contains("%")) {
            this.pme_jobname = this.pme_jobname.concat("%");
        }
        System.out.println("Job Name/Pattern " + this.pme_jobname);
        this.pme_stepnbr = bbRespBuffer.getInt(offset + Integer.parseInt("3C", 16));
        System.out.println("Step No " + this.pme_stepnbr);
        this.pme_progname = this.parseutils.byteBufToString(offset + Integer.parseInt("50", 16), 8);
        System.out.println("Program Name " + this.pme_progname);
        this.pme_stepname = this.parseutils.byteBufToString(offset + Integer.parseInt("40", 16), 8);
        System.out.println("Step Name " + this.pme_stepname);
        this.pme_procstep = this.parseutils.byteBufToString(offset + Integer.parseInt("48", 16), 8);
        System.out.println("ProcStep Name " + this.pme_procstep);
        this.pme_systems = this.parseutils.byteBufToString(offset + Integer.parseInt("68", 16), 8);
        System.out.println("System Name " + this.pme_systems);
        this.pme_desc = this.parseutils.byteBufToString(offset + Integer.parseInt("C0", 16), 48);
        System.out.println("Description " + this.pme_desc);
        this.pme_notes1 = this.parseutils.byteBufToString(offset + Integer.parseInt("981", 16), 48).trim();
        System.out.println("Notes1 " + this.pme_notes1);
        this.pme_notes2 = this.parseutils.byteBufToString(offset + Integer.parseInt("9B1", 16), 48).trim();
        System.out.println("Notes2 " + this.pme_notes2);
        this.pme_notes3 = this.parseutils.byteBufToString(offset + Integer.parseInt("9E1", 16), 48).trim();
        System.out.println("Notes3 " + this.pme_notes3);
        this.pme_samples = bbRespBuffer.getInt(offset + Integer.parseInt("94", 16));
        System.out.println("Number of Samples " + this.pme_samples);
        this.pme_flags_eos = false;
        int result = 0x40 & pme_flags[0];
        if (result == 64) {
            this.pme_flags_eos = true;
        }
        System.out.println("Measure to step end " + this.pme_flags_eos);
        this.pme_duration = bbRespBuffer.getInt(offset + Integer.parseInt("98", 16));
        System.out.println("Duration (min:sec) " + this.pme_duration);
        this.pme_delay = bbRespBuffer.getInt(offset + Integer.parseInt("3AA", 16));
        System.out.println("Delay by (secs) " + this.pme_delay);
        this.pme_notify = this.parseutils.byteBufToString(offset + Integer.parseInt("3A2", 16), 8);
        System.out.println("Notify TSO User " + this.pme_notify);
        this.pme_expdays = bbRespBuffer.getShort(offset + Short.parseShort("3AE", 16));
        System.out.println("Retain file for (days) " + this.pme_expdays);
        this.pme_ussmaxobs = bbRespBuffer.getShort(offset + Short.parseShort("34A", 16));
        System.out.println("USS observations " + this.pme_ussmaxobs);
        byte[] pme_select = new byte[]{bbRespBuffer.get(offset + Integer.parseInt("2B", 16))};
        this.activeJob = false;
        this.activeJob = this.parseutils.checkSelect(pme_select, "pme_select_act");
        System.out.println("Active job " + this.activeJob);
        boolean buildParm = false;
        String stepText = "";
        buildParm = this.parseutils.checkSelect(pme_select, "pme_stepnbr");
        stepText = buildParm ? this.constants.decfmt5.format(this.pme_stepnbr) : "^";
        stepText = String.valueOf(stepText) + ",";
        buildParm = this.parseutils.checkSelect(pme_select, "pme_progname");
        stepText = buildParm ? String.valueOf(stepText) + this.pme_progname : String.valueOf(stepText) + "^";
        stepText = String.valueOf(stepText) + ",";
        buildParm = this.parseutils.checkSelect(pme_select, "pme_stepname");
        stepText = buildParm ? String.valueOf(stepText) + this.pme_stepname : String.valueOf(stepText) + "^";
        stepText = String.valueOf(stepText) + ",";
        buildParm = this.parseutils.checkSelect(pme_select, "pme_procstep");
        stepText = buildParm ? String.valueOf(stepText) + this.pme_procstep : String.valueOf(stepText) + "^";
        if (!stepText.equals("^,^,^,^")) {
            this.listSteps.add(stepText);
        }
        this.pme_features = bbRespBuffer.getInt(offset + Integer.parseInt("9C", 16));
        this.parseutils.buildExtractors(this.pme_features);
        this.cicsExtractor = this.parseutils.cicsExtractor;
        this.cicsiExtractor = this.parseutils.cicsiExtractor;
        this.imsExtractor = this.parseutils.imsExtractor;
        this.db2Extractor = this.parseutils.db2Extractor;
        this.mqsExtractor = this.parseutils.mqsExtractor;
        this.ussFeature = this.parseutils.ussFeature;
        this.db2iExtractor = this.parseutils.db2iExtractor;
        this.imsiExtractor = this.parseutils.imsiExtractor;
        this.javaExtractor = this.parseutils.javaExtractor;
        this.db2vExtractor = this.parseutils.db2vExtractor;
        this.db2xExtractor = this.parseutils.db2xExtractor;
        this.cdb2Extractor = this.parseutils.cdb2Extractor;
        this.naturalExtractor = this.parseutils.naturalExtractor;
        this.adabasExtractor = this.parseutils.adabasExtractor;
        this.srbExtractor = this.parseutils.srbExtractor;
        this.mqiExtractor = this.parseutils.mqiExtractor;
        this.sysExtractor = this.parseutils.sysExtractor;
        this.wlpExtractor = this.parseutils.wlpExtractor;
        System.out.println("CICS information " + this.cicsExtractor);
        System.out.println("CICS+ information " + this.cicsiExtractor);
        System.out.println("MQ call information " + this.mqsExtractor);
        System.out.println("MQ+ " + this.mqiExtractor);
        System.out.println("SQL call information " + this.db2Extractor);
        System.out.println("SQL service/CPU time/counts " + this.db2iExtractor);
        System.out.println("SQL Variables " + this.db2vExtractor);
        System.out.println("Db2 Explain Variables " + this.db2xExtractor);
        System.out.println("Collateral Db2 activity " + this.cdb2Extractor);
        System.out.println("DLI call information " + this.imsExtractor);
        System.out.println("DLI service/CPU time/counts " + this.imsiExtractor);
        System.out.println("Java information " + this.javaExtractor);
        System.out.println("Natural information " + this.naturalExtractor);
        System.out.println("ADABAS information " + this.adabasExtractor);
        System.out.println("SRB Sampling " + this.srbExtractor);
        System.out.println("SYS Sampling " + this.sysExtractor);
        System.out.println("WLP Sampling " + this.wlpExtractor);
        this.pme_flags_dirs = false;
        result = 0x20 & pme_flags[0];
        if (result == 32) {
            this.pme_flags_dirs = true;
        }
        if ((pme_loads = this.parseutils.byteBufToString(offset + Integer.parseInt("0F0", 16), 440)).length() > 0) {
            if (this.pme_flags_dirs) {
                System.out.println("hfs dirs ");
                this.pme_dirs = pme_loads.trim();
                System.out.println(this.pme_dirs);
            } else {
                System.out.println("Loads ");
                int start = 0;
                int delta = 43;
                int k = pme_loads.length() / 44 + 2;
                int i2 = 1;
                while (i2 < k) {
                    if (delta > pme_loads.length()) {
                        delta = pme_loads.length();
                        i2 = 99;
                    }
                    String tempLib = pme_loads.substring(start, delta).trim();
                    this.libName = String.valueOf(this.libName) + "'" + tempLib + "' ";
                    this.listLibs.add(tempLib);
                    start += 44;
                    delta += 44;
                    ++i2;
                }
            }
        }
        this.pme_DB2IMaxTraceSize = bbRespBuffer.getShort(offset + Integer.parseInt("3EA", 16));
        System.out.println("Db2IMaxTraceSize " + this.pme_DB2IMaxTraceSize);
        this.pme_IMSIMaxTraceSize = bbRespBuffer.getShort(offset + Integer.parseInt("3EC", 16));
        System.out.println("IMSIMaxTraceSize " + this.pme_IMSIMaxTraceSize);
        this.pme_MQIMaxTraceSize = bbRespBuffer.getShort(offset + Integer.parseInt("422", 16));
        System.out.println("MQIMaxTraceSize " + this.pme_MQIMaxTraceSize);
        if (CorePlugin.getDefault().versionextension.chkNewField("ArgDsn")) {
            this.pme_ARGDSN = this.parseutils.byteBufToString(offset + Integer.parseInt("900", 16), 44);
            if (this.pme_ARGDSN.length() > 0) {
                this.pme_ARGDSN = "'" + this.pme_ARGDSN + "'";
            }
            System.out.println("ARGDSN " + this.pme_ARGDSN);
            this.pme_ARGMem = this.parseutils.byteBufToString(offset + Integer.parseInt("92C", 16), 8);
            System.out.println("ARGMem " + this.pme_ARGMem);
        }
        if (CorePlugin.getDefault().versionextension.chkNewField("CicsProg")) {
            byte[] pme_pgm_cnt = new byte[]{bbRespBuffer.get(offset + Integer.parseInt("940", 16))};
            System.out.println("CICS Program Count is  " + pme_pgm_cnt[0]);
            this.pme_cics_progs = "";
            int i3 = 0;
            while (i3 < pme_pgm_cnt[0]) {
                String pme_cics_prog = this.parseutils.byteBufToString(offset + Integer.parseInt("941", 16) + 8 * i3, 8, 'e');
                if ((pme_cics_prog = pme_cics_prog.trim()).length() > 0) {
                    this.pme_cics_progs = String.valueOf(this.pme_cics_progs) + "," + pme_cics_prog;
                }
                ++i3;
            }
            if (this.pme_cics_progs.length() > 0) {
                this.pme_cics_progs = this.pme_cics_progs.substring(1);
                System.out.println(this.pme_cics_progs);
            }
        }
        if (this.pme_variant.equals("M")) {
            int pme_m_steparrctr = bbRespBuffer.getShort(offset + Integer.parseInt("434", 16));
            if (pme_m_steparrctr == -1) {
                System.out.println(reqnum + " Steps Scheduled All Steps");
                CorePlugin.getDefault().session.buildCommandParm("ALLSTEPS", "YES");
                this.listSteps.add("*,^,^,^");
            }
            if (pme_m_steparrctr > 0 && !this.activeJob) {
                System.out.println(reqnum + " Steps Scheduled " + pme_m_steparrctr);
                String stepPrint = "";
                int j = 0;
                byte[] bStepType = new byte[1];
                i = 0;
                while (i < pme_m_steparrctr) {
                    stepText = "";
                    String stepProgName = "";
                    String stepStepName = "";
                    String stepProcName = "";
                    int stepNum = -1;
                    bStepType[0] = bbRespBuffer.get(offset + Integer.parseInt("436", 16) + j + 21);
                    int iStepType = this.parseutils.checkStepType(bStepType);
                    if (iStepType == 128) {
                        stepNum = bbRespBuffer.getShort(offset + Integer.parseInt("436", 16) + j);
                        stepPrint = String.valueOf(Messages.getString("ObservationDetail.Step.StepNumber")) + stepNum;
                    }
                    if (iStepType == 64) {
                        stepProgName = "";
                        stepProgName = this.parseutils.byteBufToString(offset + Integer.parseInt("436", 16) + j, 8);
                        stepProgName = stepProgName.trim();
                        stepPrint = String.valueOf(Messages.getString("ObservationDetail.Step.ProgName")) + stepProgName;
                    }
                    if (iStepType == 32) {
                        stepStepName = this.parseutils.byteBufToString(offset + Integer.parseInt("436", 16) + j, 8);
                        stepStepName = stepStepName.trim();
                        stepProcName = this.parseutils.byteBufToString(offset + Integer.parseInt("436", 16) + j + 8, 8);
                        stepPrint = (stepProcName = stepProcName.trim()).equals("") ? String.valueOf(Messages.getString("ObservationDetail.Step.StepName")) + stepStepName : String.valueOf(Messages.getString("ObservationDetail.Step.StepNameProcStep")) + stepStepName + Messages.getString("ObservationDetail.Step.ProcStep") + stepProcName;
                    }
                    if ((stepText = this.constants.decfmt5.format(stepNum)).equals("-1")) {
                        stepText = "^";
                    }
                    stepText = String.valueOf(stepText) + ",";
                    stepText = stepProgName.length() > 0 ? String.valueOf(stepText) + stepProgName : String.valueOf(stepText) + "^";
                    stepText = String.valueOf(stepText) + ",";
                    stepText = stepStepName.length() > 0 ? String.valueOf(stepText) + stepStepName : String.valueOf(stepText) + "^";
                    stepText = String.valueOf(stepText) + ",";
                    stepText = stepProcName.length() > 0 ? String.valueOf(stepText) + stepProcName : String.valueOf(stepText) + "^";
                    if (!stepText.equals("^,^,^,^")) {
                        this.listSteps.add(stepText);
                    }
                    System.out.println(stepPrint);
                    j += 22;
                    ++i;
                }
            }
        }
        if (this.pme_jobname.trim().equals("-")) {
            this.pme_ussmaxobs = 0;
            this.pme_sspr_type = this.parseutils.byteBufToString(offset + Integer.parseInt("2B0", 16), 1);
            System.out.println("Db2 Type " + this.pme_sspr_type);
            if (this.pme_sspr_type.length() > 0) {
                int sspr_FgrpNm = 128;
                byte[] pme_sspr_flags = new byte[]{bbRespBuffer.get(offset + Integer.parseInt("341", 16))};
                result = sspr_FgrpNm & pme_sspr_flags[0];
                if (result == 128) {
                    this.pme_ssrp_isGroupName = true;
                }
                System.out.println("Db2 Group Name " + this.pme_ssrp_isGroupName);
                this.pme_sspr_subsys = this.parseutils.byteBufToString(offset + Integer.parseInt("2B1", 16), 4);
                if (this.pme_ssrp_isGroupName) {
                    System.out.println("Db2 Group Name  " + this.pme_sspr_subsys);
                } else {
                    System.out.println("Db2 Subsys " + this.pme_sspr_subsys);
                }
                String[] work_sspr_schema = this.parseutils.byteBufToString(offset + Integer.parseInt("2B5", 16), 70).split(" ");
                this.pme_sspr_schema = work_sspr_schema[0];
                System.out.println("Db2 Schema " + this.pme_sspr_schema);
                String[] temp_sspr_name = this.parseutils.byteBufToString(offset + Integer.parseInt("2FB", 16), 70).split(" ");
                this.pme_sspr_name = temp_sspr_name[0];
                System.out.println("Db2 Name " + this.pme_sspr_name);
            } else {
                this.pme_imsmass_txncode = this.pme_ims_txncode = this.parseutils.byteBufToString(offset + Integer.parseInt("318", 16), 8);
                this.pme_ims_subsystem = this.parseutils.byteBufToString(offset + Integer.parseInt("330", 16), 4);
                if (this.pme_ims_txncode.length() > 0) {
                    System.out.println("IMS Transaction " + this.pme_ims_txncode);
                    System.out.println("IMS IMSId       " + this.pme_ims_subsystem);
                }
            }
        } else {
            String temp_cics_trans = this.parseutils.byteBufToString(offset + Integer.parseInt("2B1", 16), 64);
            if ((temp_cics_trans = temp_cics_trans.trim()).length() > 0) {
                int tranCount = temp_cics_trans.length() / 4;
                ++tranCount;
                int tranModulus = temp_cics_trans.length() % 4;
                if (tranModulus > 0) {
                    ++tranCount;
                }
                this.pme_cics_trans = "";
                int i4 = 0;
                while (i4 < tranCount - 1) {
                    String pme_cics_tran = this.parseutils.byteBufToString(offset + Integer.parseInt("2B1", 16) + 4 * i4, 4);
                    this.listCicsTrans.add(pme_cics_tran);
                    this.pme_cics_trans = String.valueOf(this.pme_cics_trans) + "," + pme_cics_tran;
                    ++i4;
                }
                if (this.pme_cics_trans.length() > 0) {
                    this.pme_cics_trans = this.pme_cics_trans.substring(1);
                    System.out.println(this.pme_cics_trans);
                }
            }
            String temp_cics_termids = this.parseutils.byteBufToString(offset + Integer.parseInt("2F2", 16), 32);
            if ((temp_cics_termids = temp_cics_termids.trim()).length() > 0) {
                int termCount = temp_cics_termids.length() / 4;
                ++termCount;
                int termModulus = temp_cics_termids.length() % 4;
                if (termModulus > 0) {
                    ++termCount;
                }
                this.pme_cics_termids = "";
                i = 0;
                while (i < termCount - 1) {
                    String pme_cics_termid = this.parseutils.byteBufToString(offset + Integer.parseInt("2F2", 16) + 4 * i, 4);
                    this.listCicsTerms.add(pme_cics_termid);
                    this.pme_cics_termids = String.valueOf(this.pme_cics_termids) + "," + pme_cics_termid;
                    ++i;
                }
                if (this.pme_cics_termids.length() > 0) {
                    this.pme_cics_termids = this.pme_cics_termids.substring(1);
                    System.out.println(this.pme_cics_termids);
                }
            }
            this.buildCICSY = false;
            this.buildCICSY = this.parseutils.checkSelect(pme_select, "pme_select_cicsy");
            byte[] pme_flags4 = new byte[]{bbRespBuffer.get(offset + Integer.parseInt("372", 16))};
            this.wasExtractor = false;
            result = 0x80 & pme_flags4[0];
            if (result == 128) {
                this.wasExtractor = true;
            }
            System.out.println("wasExtractor is " + this.wasExtractor);
            byte[] pme_select1 = new byte[]{bbRespBuffer.get(offset + Integer.parseInt("373", 16))};
            result = 0x80 & pme_select1[0];
            this.noncterm = false;
            if (result == 128) {
                this.noncterm = true;
            }
            this.ddfsel = false;
            if (this.pme_version[0] >= this.pme_version_4 && (result = 4 & pme_select1[0]) == 4) {
                this.ddfsel = true;
            }
            this.pme_imsmass_txncode = this.pme_ims_txncode = this.parseutils.byteBufToString(offset + Integer.parseInt("318", 16), 8);
            if (this.pme_ims_txncode.length() > 0) {
                System.out.println("IMS Transaction " + this.pme_ims_txncode);
            }
            this.pme_ims_progname = this.parseutils.byteBufToString(offset + Integer.parseInt("320", 16), 8);
            if (this.pme_ims_progname.length() > 0) {
                System.out.println("IMS Program " + this.pme_ims_progname);
            }
            this.pme_ims_userid = this.parseutils.byteBufToString(offset + Integer.parseInt("328", 16), 8);
            if (this.pme_ims_userid.length() > 0) {
                System.out.println("IMS User " + this.pme_ims_userid);
            }
            if (this.ddfsel) {
                this.pme_db2_corrid_isnull = true;
                this.pme_db2_corrid = this.parseutils.byteBufToString(offset + Integer.parseInt("3F0", 16), 12);
                if (!this.pme_db2_corrid.isEmpty()) {
                    System.out.println("PME_DB2corrId " + this.pme_db2_corrid);
                    this.pme_db2_corrid_isnull = false;
                }
                this.pme_db2_enduserid_isnull = true;
                this.pme_db2_enduserid = this.parseutils.byteBufToString(offset + Integer.parseInt("3FC", 16), 16);
                if (!this.pme_db2_enduserid.isEmpty()) {
                    System.out.println("PME_DB2endUserId " + this.pme_db2_enduserid);
                    this.pme_db2_enduserid_isnull = false;
                }
                this.pme_db2_wkstnid_isnull = true;
                this.pme_db2_wkstnid = this.parseutils.byteBufToString(offset + Integer.parseInt("40C", 16), 18);
                if (!this.pme_db2_wkstnid.isEmpty()) {
                    System.out.println("PME_DB2wkstnId " + this.pme_db2_wkstnid);
                    this.pme_db2_wkstnid_isnull = false;
                }
            }
            this.ipme_ext = bbRespBuffer.getInt(offset + Integer.parseInt("41E", 16));
            this.pme_ext = this.constants.decfmt2.format(this.ipme_ext);
        }
        if (this.pme_variant.equals("M")) {
            this.pme_m_schdarrctr = bbRespBuffer.getShort(offset + Integer.parseInt("5EE", 16));
            System.out.println("Sched Array Counter is: " + this.pme_m_schdarrctr);
            long lSTCK = bbRespBuffer.getLong(offset + Integer.parseInt("10", 16));
            this.pme_stck_req = this.parseutils.parseSTCK(lSTCK);
            int j = 0;
            if (this.pme_m_schdarrctr > 0) {
                int dstOffset = 0;
                int dstMultiplier = 1;
                i = 0;
                while (i < this.pme_m_schdarrctr) {
                    byte[] minuteBytes = new byte[4];
                    minuteBytes[0] = bbRespBuffer.get(offset + Integer.parseInt("5FC", 16) + j);
                    Integer minuteNibble = 0;
                    minuteNibble = minuteBytes[0] & 0xF;
                    minuteBytes[0] = 0;
                    minuteBytes[1] = minuteNibble.byteValue();
                    minuteBytes[2] = bbRespBuffer.get(offset + Integer.parseInt("5FC", 16) + j + 1);
                    minuteBytes[3] = bbRespBuffer.get(offset + Integer.parseInt("5FC", 16) + j + 2);
                    ByteBuffer minuteBuf = ByteBuffer.wrap(minuteBytes);
                    int iMinute = minuteBuf.getInt();
                    long lReqTime = this.pme_stck_req.getTime();
                    long lMinute = iMinute;
                    long lOffset = lMinute * 60L * 1000L;
                    long schedTime = lReqTime + lOffset;
                    Date dSchedDateTime = new Date(schedTime);
                    TimeZone tz = Calendar.getInstance().getTimeZone();
                    boolean isTodayDST = TimeZone.getDefault().inDaylightTime(new Date());
                    boolean isSchedDateDST = TimeZone.getDefault().inDaylightTime(dSchedDateTime);
                    dstMultiplier = isTodayDST ? (isSchedDateDST ? 0 : 1) : (isSchedDateDST ? 0 : 1);
                    dstOffset = tz.getDSTSavings() * dstMultiplier;
                    schedTime = lReqTime + lOffset + (long)dstOffset;
                    dSchedDateTime = new Date(schedTime);
                    this.listSchdDate.add(dSchedDateTime);
                    j += 3;
                    ++i;
                }
            }
        }
        if (!this.activeJob) {
            this.pme_m_schdspan = bbRespBuffer.getShort(offset + Integer.parseInt("5FA", 16));
            this.pme_runagainmins = bbRespBuffer.getShort(offset + Integer.parseInt("3B0", 16));
            byte[] tmp_runagainfor = new byte[]{bbRespBuffer.get(offset + Integer.parseInt("3B2", 16))};
            this.pme_runagainfor = tmp_runagainfor[0];
        } else {
            byte[] tmp_retryafter = new byte[]{bbRespBuffer.get(offset + Integer.parseInt("5FA", 16))};
            this.pme_retryafter = tmp_retryafter[0];
            byte[] tmp_retrytimes = new byte[]{bbRespBuffer.get(offset + Integer.parseInt("5FB", 16))};
            this.pme_retrytimes = tmp_retrytimes[0];
        }
        if (this.pme_variant.equals("T")) {
            byte pme_tm_flags = bbRespBuffer.get(offset + Integer.parseInt("42A", 16));
            result = 0x40 & pme_tm_flags;
            this.pme_tm_allsteps = false;
            if (result == 64) {
                this.pme_tm_allsteps = true;
            }
            this.pme_tm_sel_dsmll = bbRespBuffer.getShort(offset + Integer.parseInt("46E", 16));
            this.pme_tm_sel_dsml = this.parseutils.byteBufToString(offset + Integer.parseInt("470", 16), this.pme_tm_sel_dsmll.shortValue());
            if (this.pme_tm_sel_dsmll > 0) {
                System.out.println(this.pme_tm_sel_dsmll + " " + this.pme_tm_sel_dsml);
                String tm_delimiter = " ";
                String[] tm_tokens = this.pme_tm_sel_dsml.split(tm_delimiter);
                int tm_i = 0;
                while (tm_i < tm_tokens.length) {
                    System.out.println(tm_tokens[tm_i]);
                    if (tm_tokens[tm_i].contains("CPU=")) {
                        this.tm_sel_cpu = tm_tokens[tm_i].substring(4);
                        System.out.println("tm_sel_cpu is " + this.tm_sel_cpu);
                    }
                    if (tm_tokens[tm_i].contains("ELAPSEDTIME=")) {
                        this.tm_sel_elapsedtime = tm_tokens[tm_i].substring(12);
                        System.out.println("tm_sel_elapsedtime is " + this.tm_sel_elapsedtime);
                    }
                    if (tm_tokens[tm_i].contains("EXCP=")) {
                        this.tm_sel_excp = tm_tokens[tm_i].substring(5);
                        System.out.println("tm_sel_excp is " + this.tm_sel_excp);
                    }
                    ++tm_i;
                }
            }
        }
        if (this.ipme_ext > 0) {
            System.out.println(reqnum + " points to pmex " + this.pme_ext);
            int rc = this.getPmexObservationDetail(this.progmonitor);
            if (rc == 0) {
                this.parsePMEX(offset);
            } else {
                return;
            }
        }
        this.buildMessage();
    }

    private void parsePMEX(int offset) {
        ByteBuffer bbRespBuffer = ByteBuffer.wrap(this.bRespBuffer);
        byte[] pmex_type = new byte[]{bbRespBuffer.get(offset + Integer.parseInt("1D", 16))};
        switch (pmex_type[0]) {
            case 1: {
                break;
            }
            case 2: {
                this.parsePMEXType2(offset);
                break;
            }
            case 3: {
                this.parsePMEXType3(offset);
                break;
            }
        }
    }

    private void parsePMEXType2(int offset) {
        Byte[] pmex_WasOrigLen;
        byte pmex_WasOrigTyp;
        Byte[] pmex_WasAppLen;
        Byte[] pmex_WasReqLen;
        Byte[] pmex_WasFexLen;
        this.wasFilterSel = true;
        ByteBuffer bbRespBuffer = ByteBuffer.wrap(this.bRespBuffer);
        bbRespBuffer.getInt(offset + Integer.parseInt("8", 16));
        byte[] pmex_WasImg = new byte[]{bbRespBuffer.get(offset + Integer.parseInt("2A", 16))};
        this.pme_was_img = pmex_WasImg[0] == 89;
        boolean wasAppendReqWildcard = false;
        boolean wasAppendAppWildcard = false;
        boolean wasAppendOrgWildcard = false;
        byte PMEX_WasFflags = bbRespBuffer.get(offset + Integer.parseInt("2B", 16));
        int pmexWasFflags_result = 0x80 & PMEX_WasFflags;
        if (pmexWasFflags_result == 128) {
            wasAppendReqWildcard = true;
        }
        if ((pmexWasFflags_result = 0x40 & PMEX_WasFflags) == 64) {
            wasAppendAppWildcard = true;
        }
        if ((pmexWasFflags_result = 0x20 & PMEX_WasFflags) == 32) {
            wasAppendOrgWildcard = true;
        }
        if ((pmex_WasFexLen = new Byte[]{bbRespBuffer.get(offset + Integer.parseInt("2E", 16))})[0].intValue() > 0) {
            this.pme_was_fex = this.byteBufToString(offset + Integer.parseInt("2F", 16), pmex_WasFexLen[0].intValue());
        }
        if ((pmex_WasReqLen = new Byte[]{bbRespBuffer.get(offset + Integer.parseInt("7E", 16))})[0].intValue() > 0) {
            this.pme_was_req = this.byteBufToString(offset + Integer.parseInt("7F", 16), pmex_WasReqLen[0].intValue());
            if (wasAppendReqWildcard) {
                this.pme_was_req = this.pme_was_req.concat("*");
            }
        }
        if ((pmex_WasAppLen = new Byte[]{bbRespBuffer.get(offset + Integer.parseInt("CE", 16))})[0].intValue() > 0) {
            this.pme_was_app = this.byteBufToString(offset + Integer.parseInt("CF", 16), pmex_WasAppLen[0].intValue());
            if (wasAppendAppWildcard) {
                this.pme_was_app = this.pme_was_app.concat("*");
            }
        }
        if ((pmex_WasOrigTyp = bbRespBuffer.get(offset + Integer.parseInt("11E", 16))) == 0 || pmex_WasOrigTyp == 12) {
            this.pme_was_origJob = true;
            this.constants.getClass();
            this.pme_was_origType = "J";
        }
        if (pmex_WasOrigTyp == 8) {
            this.pme_was_origJob = false;
            this.pme_was_origHost = true;
            this.pme_was_origType = this.constants.WASORIGINTYPE_HOST;
        }
        if (pmex_WasOrigTyp == 4) {
            this.pme_was_origJob = false;
            this.pme_was_origIpadr = true;
            this.pme_was_origType = this.constants.WASORIGINTYPE_IPADR;
        }
        if ((pmex_WasOrigLen = new Byte[]{bbRespBuffer.get(offset + Integer.parseInt("11F", 16))})[0].intValue() > 0) {
            this.pme_was_orig = this.byteBufToString(offset + Integer.parseInt("120", 16), pmex_WasOrigLen[0].intValue());
            if (wasAppendOrgWildcard) {
                this.pme_was_orig = this.pme_was_orig.concat("*");
            }
        }
    }

    private void parsePMEXType3(int offset) {
        Byte[] pmex_WlpOrigLen;
        byte pmex_WlpOrigTyp;
        Byte[] pmex_WlpReqLen;
        this.wlpFilterSel = true;
        ByteBuffer bbRespBuffer = ByteBuffer.wrap(this.bRespBuffer);
        bbRespBuffer.getInt(offset + Integer.parseInt("8", 16));
        boolean wlpAppendReqWildcard = false;
        boolean wlpAppendOrgWildcard = false;
        byte PMEX_WlpFflags = bbRespBuffer.get(offset + Integer.parseInt("2B", 16));
        int pmexWlpFflags_result = 0x80 & PMEX_WlpFflags;
        if (pmexWlpFflags_result == 128) {
            wlpAppendReqWildcard = true;
        }
        if ((pmexWlpFflags_result = 0x40 & PMEX_WlpFflags) == 64) {
            // empty if block
        }
        if ((pmexWlpFflags_result = 0x20 & PMEX_WlpFflags) == 32) {
            wlpAppendOrgWildcard = true;
        }
        if ((pmex_WlpReqLen = new Byte[]{bbRespBuffer.get(offset + Integer.parseInt("7E", 16))})[0].intValue() > 0) {
            this.pme_wlp_req = this.byteBufToString(offset + Integer.parseInt("7F", 16), pmex_WlpReqLen[0].intValue());
            if (wlpAppendReqWildcard) {
                this.pme_wlp_req = this.pme_wlp_req.concat("*");
            }
        }
        if ((pmex_WlpOrigTyp = bbRespBuffer.get(offset + Integer.parseInt("11E", 16))) == 0 || pmex_WlpOrigTyp == 12) {
            this.pme_wlp_origIpadr = true;
            this.pme_wlp_origType = this.constants.WASORIGINTYPE_IPADR;
        }
        if (pmex_WlpOrigTyp == 8) {
            this.pme_wlp_origHost = true;
            this.pme_wlp_origType = this.constants.WASORIGINTYPE_HOST;
        }
        if (pmex_WlpOrigTyp == 4) {
            this.pme_wlp_origIpadr = true;
            this.pme_wlp_origType = this.constants.WASORIGINTYPE_IPADR;
        }
        if ((pmex_WlpOrigLen = new Byte[]{bbRespBuffer.get(offset + Integer.parseInt("11F", 16))})[0].intValue() > 0) {
            this.pme_wlp_orig = this.byteBufToString(offset + Integer.parseInt("120", 16), pmex_WlpOrigLen[0].intValue());
            if (wlpAppendOrgWildcard) {
                this.pme_wlp_orig = this.pme_wlp_orig.concat("*");
            }
        }
    }

    private String byteBufToString(int offset, int length) {
        ByteBuffer bbRespBuffer = ByteBuffer.wrap(this.bRespBuffer);
        byte[] ba = new byte[length];
        int j = 0;
        while (j < length) {
            ba[j] = bbRespBuffer.get(offset + j);
            ++j;
        }
        String sValue = new String(ba).trim();
        return sValue;
    }

    public int getPmexObservationDetail(IProgressMonitor monitor) throws Exception {
        int rc = 0;
        int errrc = -1;
        CorePlugin.getDefault().session.commandLine = "";
        String[] commandarr = new String[]{String.valueOf(this.constants.ZOSMESSAGE_GETOBSDETAIL) + " " + this.pme_ext};
        String logstr = "getPmexObservationDetail:  Running " + commandarr[0];
        System.out.println("ObservationDetail - " + logstr);
        CorePlugin.getDefault().log.debug(logstr);
        this.bRespBuffer = CorePlugin.getDefault().session.doCmdResp(commandarr[0], CorePlugin.getDefault().getPreferenceStore().getString("dataSource"));
        ByteBuffer bbRespBuffer = ByteBuffer.wrap(this.bRespBuffer);
        CorePlugin.getDefault().session.checkResponse();
        if (CorePlugin.getDefault().session.getReturnCode() >= 1000) {
            logstr = "getPmexObservationDetail:  Connect error " + CorePlugin.getDefault().session.getReturnCode() + ", set connect local";
            System.out.println("ObservationDetail - " + logstr);
            CorePlugin.getDefault().log.debug(logstr);
            this.zosconnect.setConnectLocal();
            return errrc;
        }
        if (CorePlugin.getDefault().session.getReturnCode() != 0) {
            logstr = "getPmexObservationDetail:  error RC - " + CorePlugin.getDefault().session.getReturnCode();
            System.out.println("ObservationDetail - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            return errrc;
        }
        this.parseutils.setBbRespBuffer(bbRespBuffer);
        ZosSession cfr_ignored_0 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_1 = CorePlugin.getDefault().session;
        int offset = ZosSession.bnetHeaderOffset + ZosSession.tcpipHeaderOffset;
        this.pme_version = new byte[1];
        this.pme_version[0] = bbRespBuffer.get(offset + Integer.parseInt("1C", 16));
        System.out.println("PME Version is  " + this.pme_version[0]);
        return rc;
    }

    public void buildMessage() {
        System.out.println("buildMessage: Job Name/Pattern " + this.pme_jobname);
        CorePlugin.getDefault().session.buildCommandParm("JOBNAME", this.pme_jobname);
        System.out.println("buildMessage: System Name " + this.pme_systems);
        CorePlugin.getDefault().session.buildCommandParm("SYSTEMS", this.pme_systems);
        System.out.println("buildMessage: Description " + this.pme_desc);
        CorePlugin.getDefault().session.buildCommandParm("DESCR", this.pme_desc);
        System.out.println("buildMessage: Notes1 " + this.pme_notes1);
        CorePlugin.getDefault().session.buildCommandParm("NOTES1", this.pme_notes1);
        System.out.println("buildMessage: Notes2 " + this.pme_notes2);
        CorePlugin.getDefault().session.buildCommandParm("NOTES2", this.pme_notes2);
        System.out.println("buildMessage: Notes3 " + this.pme_notes3);
        CorePlugin.getDefault().session.buildCommandParm("NOTES3", this.pme_notes3);
        System.out.println("buildMessage: Number of Samples " + this.pme_samples);
        CorePlugin.getDefault().session.buildCommandParm("SAMPLES", this.pme_samples);
        System.out.println("buildMessage: Measure to step end " + this.pme_flags_eos);
        if (this.pme_flags_eos) {
            CorePlugin.getDefault().session.buildCommandParm("RUNTOEOS", "Y");
        } else {
            CorePlugin.getDefault().session.buildCommandParm("RUNTOEOS", "N");
        }
        System.out.println("buildMessage: Duration (min:sec) " + this.pme_duration);
        CorePlugin.getDefault().session.buildCommandParm("DURATION", this.pme_duration);
        System.out.println("buildMessage: Delay by (secs) " + this.pme_delay);
        if (this.pme_delay > 0) {
            CorePlugin.getDefault().session.buildCommandParm("DELAYSAMPLING", this.pme_delay);
        }
        System.out.println("buildMessage: Notify TSO User " + this.pme_notify);
        CorePlugin.getDefault().session.buildCommandParm("NOTIFY", this.pme_notify);
        System.out.println("buildMessage: Retain file for (days) " + this.pme_expdays);
        CorePlugin.getDefault().session.buildCommandParm("EXPDAYS", this.pme_expdays);
        System.out.println("buildMessage: USS observations " + this.pme_ussmaxobs);
        if (this.pme_ussmaxobs > 0) {
            CorePlugin.getDefault().session.buildCommandParm("USSOBS", this.pme_ussmaxobs);
        }
        String featureLine = "";
        if (this.cicsExtractor) {
            featureLine = String.valueOf(featureLine) + "," + CorePlugin.getDefault().constants.EXTRACTORTYPE_CICS;
        }
        if (this.cicsiExtractor) {
            featureLine = String.valueOf(featureLine) + "," + CorePlugin.getDefault().constants.EXTRACTORTYPE_CICSI;
        }
        if (this.imsExtractor) {
            featureLine = String.valueOf(featureLine) + "," + CorePlugin.getDefault().constants.EXTRACTORTYPE_IMS;
        }
        if (this.imsiExtractor) {
            featureLine = String.valueOf(featureLine) + "," + CorePlugin.getDefault().constants.EXTRACTORTYPE_IMSI;
        }
        if (this.db2Extractor) {
            featureLine = String.valueOf(featureLine) + "," + CorePlugin.getDefault().constants.EXTRACTORTYPE_DB2;
        }
        if (this.db2iExtractor) {
            featureLine = String.valueOf(featureLine) + "," + CorePlugin.getDefault().constants.EXTRACTORTYPE_DB2I;
        }
        if (this.db2vExtractor) {
            featureLine = String.valueOf(featureLine) + "," + CorePlugin.getDefault().constants.EXTRACTORTYPE_DB2V;
        }
        if (this.db2xExtractor) {
            featureLine = String.valueOf(featureLine) + "," + CorePlugin.getDefault().constants.EXTRACTORTYPE_DB2X;
        }
        if (this.cdb2Extractor) {
            featureLine = String.valueOf(featureLine) + "," + CorePlugin.getDefault().constants.EXTRACTORTYPE_CDB2;
        }
        if (this.mqsExtractor) {
            featureLine = String.valueOf(featureLine) + "," + CorePlugin.getDefault().constants.EXTRACTORTYPE_MQSERIES;
        }
        if (this.mqiExtractor) {
            featureLine = String.valueOf(featureLine) + "," + CorePlugin.getDefault().constants.EXTRACTORTYPE_MQI;
        }
        if (this.javaExtractor) {
            featureLine = String.valueOf(featureLine) + "," + CorePlugin.getDefault().constants.EXTRACTORTYPE_JAVA;
        }
        if (this.adabasExtractor) {
            featureLine = String.valueOf(featureLine) + "," + CorePlugin.getDefault().constants.EXTRACTORTYPE_ADABAS;
        }
        if (this.naturalExtractor) {
            featureLine = String.valueOf(featureLine) + "," + CorePlugin.getDefault().constants.EXTRACTORTYPE_NATURAL;
        }
        if (this.wasExtractor) {
            featureLine = String.valueOf(featureLine) + "," + CorePlugin.getDefault().constants.EXTRACTORTYPE_WAS;
        }
        if (this.srbExtractor) {
            featureLine = String.valueOf(featureLine) + "," + CorePlugin.getDefault().constants.EXTRACTORTYPE_SRB;
        }
        if (this.sysExtractor) {
            featureLine = String.valueOf(featureLine) + "," + CorePlugin.getDefault().constants.EXTRACTORTYPE_SYS;
        }
        if (this.wlpExtractor) {
            featureLine = String.valueOf(featureLine) + "," + CorePlugin.getDefault().constants.EXTRACTORTYPE_WLP;
        }
        if (featureLine.length() > 0) {
            featureLine = featureLine.substring(1);
            System.out.println("buildMessage: Extractors " + featureLine);
            CorePlugin.getDefault().session.buildCommandParm("FEATURES", featureLine);
        }
        if (this.pme_DB2IMaxTraceSize > 0) {
            Integer idb2imax = new Integer(this.pme_DB2IMaxTraceSize) * 1000;
            CorePlugin.getDefault().session.buildCommandParm("DB2IMAX", this.constants.decfmt2.format(idb2imax));
        }
        if (this.pme_IMSIMaxTraceSize > 0) {
            Integer iimsimax = new Integer(this.pme_IMSIMaxTraceSize) * 1000;
            CorePlugin.getDefault().session.buildCommandParm("IMSIMAX", this.constants.decfmt2.format(iimsimax));
        }
        if (this.pme_MQIMaxTraceSize > 0) {
            Integer imqimax = new Integer(this.pme_MQIMaxTraceSize) * 1000;
            CorePlugin.getDefault().session.buildCommandParm("MQIMAX", this.constants.decfmt2.format(imqimax));
        }
        if (this.pme_ARGDSN.length() > 0) {
            String argdsnmem = this.pme_ARGDSN;
            if (this.pme_ARGMem.length() > 0) {
                argdsnmem = String.valueOf(argdsnmem) + "," + this.pme_ARGMem;
            }
            CorePlugin.getDefault().session.buildCommandParm("ARGDATA", argdsnmem);
        }
        if (this.pme_flags_dirs) {
            if (this.pme_dirs.length() > 0) {
                System.out.println("buildMessage: hfs dirs " + this.pme_dirs);
                CorePlugin.getDefault().session.buildCommandParm("DIRS", this.pme_dirs);
            }
        } else {
            this.libName = "";
            int i = 0;
            while (i < this.listLibs.size()) {
                String tempLib = this.listLibs.get(i);
                this.libName = String.valueOf(this.libName) + "'" + tempLib + "' ";
                ++i;
            }
            System.out.println("buildMessage: load libs " + this.libName);
            if (this.libName.length() > 0) {
                CorePlugin.getDefault().session.buildCommandParm("LIBS", this.libName.trim());
            }
        }
        int i = 0;
        while (i < this.listSteps.size()) {
            StringTokenizer st = new StringTokenizer(this.listSteps.get(i), ",");
            String stepNum = st.nextToken().replace("^", "");
            String stepProgName = st.nextToken().replace("^", "");
            String stepStepName = st.nextToken().replace("^", "");
            String stepProcName = st.nextToken().replace("^", "");
            if (stepNum.length() > 0) {
                CorePlugin.getDefault().session.buildCommandParm("STEP", stepNum);
            }
            if (stepProgName.length() > 0) {
                CorePlugin.getDefault().session.buildCommandParm("STEP", "," + stepProgName);
            }
            if (stepProcName.length() > 0) {
                CorePlugin.getDefault().session.buildCommandParm("STEP", ",," + stepStepName + "." + stepProcName);
            } else if (stepStepName.length() > 0) {
                CorePlugin.getDefault().session.buildCommandParm("STEP", ",," + stepStepName);
            }
            ++i;
        }
        if (this.pme_cics_trans.length() > 0) {
            System.out.println("buildMessage: cics trans " + this.pme_cics_trans);
            CorePlugin.getDefault().session.buildCommandParm("CTRAN", this.pme_cics_trans);
        }
        if (this.pme_cics_termids.length() > 0) {
            System.out.println("buildMessage: cics terminals " + this.pme_cics_termids);
            CorePlugin.getDefault().session.buildCommandParm("CTERM", this.pme_cics_termids);
        }
        if (CorePlugin.getDefault().versionextension.chkNewField("CicsProg") && this.pme_cics_progs.length() > 0) {
            System.out.println("buildMessage: cics programs " + this.pme_cics_progs);
            CorePlugin.getDefault().session.buildCommandParm("CPGM", this.pme_cics_progs);
        }
        if (this.cicsExtractor) {
            if (this.buildCICSY) {
                System.out.println("buildMessage: sysctran " + this.buildCICSY);
                CorePlugin.getDefault().session.buildCommandParm("SYSCTRAN", "Y");
            } else if (this.pme_cics_trans.equals("*")) {
                System.out.println("buildMessage: sysctran " + this.buildCICSY + ", SYSCTRAN=M");
                CorePlugin.getDefault().session.buildCommandParm("SYSCTRAN", "M");
            } else {
                System.out.println("buildMessage: sysctran " + this.buildCICSY);
                CorePlugin.getDefault().session.buildCommandParm("SYSCTRAN", "N");
            }
            System.out.println("buildMessage: noncterm " + this.noncterm);
            CorePlugin.getDefault().session.buildCommandParm("NONCTERM", "Y");
        }
        if (this.pme_ims_txncode.length() > 0) {
            CorePlugin.getDefault().session.buildCommandParm("ITRAN", this.pme_ims_txncode);
            System.out.println("buildMessage: IMS Transaction " + this.pme_ims_txncode);
        }
        if (this.pme_ims_progname.length() > 0) {
            CorePlugin.getDefault().session.buildCommandParm("IPROG", this.pme_ims_progname);
            System.out.println("buildMessage: IMS Program " + this.pme_ims_progname);
        }
        if (this.pme_ims_userid.length() > 0) {
            CorePlugin.getDefault().session.buildCommandParm("IUSER", this.pme_ims_userid);
            System.out.println("buildMessage: IMS User " + this.pme_ims_userid);
        }
        if (this.pme_ims_subsystem.length() > 0) {
            CorePlugin.getDefault().session.buildCommandParm("IMSID", this.pme_ims_subsystem);
            System.out.println("buildMessage: IMS Id " + this.pme_ims_subsystem);
        }
        if (this.pme_sspr_type.length() > 0) {
            String db2subsystemparm = ",";
            String db2groupparm = "";
            if (this.pme_ssrp_isGroupName) {
                db2groupparm = "," + this.pme_sspr_subsys;
            } else {
                db2subsystemparm = String.valueOf(this.pme_sspr_subsys) + db2subsystemparm;
            }
            String db2spparms = String.valueOf(this.pme_sspr_type) + "," + db2subsystemparm + this.pme_sspr_schema + "," + this.pme_sspr_name + db2groupparm;
            CorePlugin.getDefault().session.buildCommandParm("DB2SP", db2spparms);
            System.out.println("buildMessage: DB2SP PARMS (type, group subsys, subsystem subsys, schema, name) " + db2spparms);
        }
        if (this.ddfsel) {
            String ddfparms = "CORRID=(" + this.pme_db2_corrid + ",";
            String nullparm = this.pme_db2_corrid_isnull ? "NULL" : "";
            ddfparms = String.valueOf(ddfparms) + nullparm + "),";
            ddfparms = String.valueOf(ddfparms) + "EUSERID=(" + this.pme_db2_enduserid + ",";
            nullparm = this.pme_db2_enduserid_isnull ? "NULL" : "";
            ddfparms = String.valueOf(ddfparms) + nullparm + "),";
            ddfparms = String.valueOf(ddfparms) + "WKSTNID=(" + this.pme_db2_wkstnid + ",";
            nullparm = this.pme_db2_wkstnid_isnull ? "NULL" : "";
            ddfparms = String.valueOf(ddfparms) + nullparm + ")";
            CorePlugin.getDefault().session.buildCommandParm("DDFFILTERS", ddfparms);
            System.out.println("buildMessage: DDFFILTERS PARMS (corrid, euserid, wkstnid) " + ddfparms);
        }
        if (this.wasFilterSel) {
            String wasparms = "";
            wasparms = String.valueOf(wasparms) + "REQNAME='" + this.pme_was_req + "',";
            wasparms = String.valueOf(wasparms) + "APPNAME='" + this.pme_was_app + "',";
            wasparms = String.valueOf(wasparms) + "ORIGIN=(" + this.pme_was_origType + ",'" + this.pme_was_orig + "'),";
            wasparms = String.valueOf(wasparms) + "FILEEXT='" + this.pme_was_fex + "',";
            char pme_was_img_flag = 'N';
            if (this.pme_was_img) {
                pme_was_img_flag = 'Y';
            }
            wasparms = String.valueOf(wasparms) + "NOIMAGES=" + pme_was_img_flag;
            CorePlugin.getDefault().session.buildCommandParm("WASFILTERS", wasparms);
            System.out.println("buildMessage: WASFILTERS PARMS " + wasparms);
        }
        if (this.wlpFilterSel) {
            String wlpparms = "";
            wlpparms = String.valueOf(wlpparms) + "REQNAME='" + this.pme_wlp_req + "',";
            wlpparms = String.valueOf(wlpparms) + "ORIGIN=(" + this.pme_wlp_origType + ",'" + this.pme_wlp_orig + "'),";
            CorePlugin.getDefault().session.buildCommandParm("WLPFILTERS", wlpparms);
            System.out.println("buildMessage: WLPFILTERS PARMS " + wlpparms);
        }
        if (!this.pme_variant.equals("T")) {
            String schedDate = "";
            int i2 = 0;
            while (i2 < this.listSchdDate.size()) {
                schedDate = this.constants.yyyymmddhhmm3.format(this.listSchdDate.get(i2));
                System.out.println("buildMessage: schedule date " + schedDate);
                CorePlugin.getDefault().session.buildCommandParm("SCHDDATE", schedDate);
                ++i2;
            }
            if (this.activeJob) {
                CorePlugin.getDefault().session.buildCommandParm("ACTIVE", "Y");
            } else {
                CorePlugin.getDefault().session.buildCommandParm("ACTIVE", "N");
            }
            if (!this.activeJob) {
                if (this.pme_m_schdspan > 0) {
                    System.out.println("buildMessage: schedule span " + this.pme_m_schdspan);
                    CorePlugin.getDefault().session.buildCommandParm("SCHDSPAN", this.pme_m_schdspan);
                }
                if (this.pme_runagainmins > 0 && this.pme_runagainfor > 0) {
                    System.out.println("buildMessage: runagainmins " + this.pme_runagainmins + ", runagainfor " + this.pme_runagainfor);
                    CorePlugin.getDefault().session.buildCommandParm("RUNAGAIN", this.pme_runagainmins, this.pme_runagainfor);
                }
            } else if (this.pme_retryafter > 0 && this.pme_retrytimes > 0) {
                System.out.println("buildMessage: retry after " + this.pme_retryafter + ", retrytimes " + this.pme_retrytimes);
                CorePlugin.getDefault().session.buildCommandParm("RETRYAFTER", this.pme_retryafter, this.pme_retrytimes);
            }
        }
        if (this.pme_variant.equals("T") && this.pme_tm_sel_dsmll > 0) {
            CorePlugin.getDefault().session.buildCommandParm("TMSEL", this.pme_tm_sel_dsml);
            System.out.println("buildMessage: " + this.pme_tm_sel_dsmll + " " + this.pme_tm_sel_dsml);
        }
        this.commandLine = CorePlugin.getDefault().session.commandLine;
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public Integer getReqnum() {
        return this.ireqnum;
    }
}

