/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.data;

import com.banknet.core.CorePlugin;
import com.banknet.core.internal.Constants;
import com.banknet.core.internal.ZosSession;
import com.banknet.core.models.ImsActiveJobsItem;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class ImsActiveJobsList {
    byte[] bRespBuffer;
    ImsActiveJobsItem activeJobsItem;
    private List jobresults;
    private List selectedjobs;
    private int jobcounter;
    String imsSubsystem;
    String imsTrancode;
    String imsSystem;
    Constants constants = new Constants();

    public void getImsActiveJobsList(String imsSubsystem, String imsTrancode, String imsSystem, IProgressMonitor monitor) throws Exception {
        this.imsSubsystem = imsSubsystem;
        this.imsTrancode = imsTrancode;
        this.imsSystem = imsSystem;
        this.jobresults = new ArrayList();
        this.jobcounter = 0;
        this.getRemoteImsActiveJobsList(monitor);
    }

    public void getRemoteImsActiveJobsList(IProgressMonitor monitor) throws Exception {
        String[] commandarr = new String[]{String.valueOf(this.constants.ZOSMESSAGE_GETACTIVEJOBLISTFORIMS) + " " + this.imsSubsystem + "," + this.imsTrancode + ",," + this.imsSystem};
        String logstr = "ImsActiveJobsList: Running " + commandarr[0];
        System.out.println(logstr);
        CorePlugin.getDefault().log.debug("ImsActiveJobsList:  getRemoteImsActiveJobsList,  " + logstr);
        this.bRespBuffer = CorePlugin.getDefault().session.doCmdResp(commandarr[0], CorePlugin.getDefault().getPreferenceStore().getString("dataSource"));
        ByteBuffer bbRespBuffer = ByteBuffer.wrap(this.bRespBuffer);
        CorePlugin.getDefault().session.checkResponse();
        if (CorePlugin.getDefault().session.getReturnCode() != 0) {
            return;
        }
        ZosSession cfr_ignored_0 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_1 = CorePlugin.getDefault().session;
        int iNumber = bbRespBuffer.getInt(ZosSession.bnetHeaderOffset + ZosSession.tcpipHeaderOffset + 2);
        ZosSession cfr_ignored_2 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_3 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_4 = CorePlugin.getDefault().session;
        int iLen = bbRespBuffer.getInt(ZosSession.bnetHeaderOffset + ZosSession.tcpipHeaderOffset + ZosSession.lseHeaderOffset_len);
        bbRespBuffer.clear();
        ZosSession cfr_ignored_5 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_6 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_7 = CorePlugin.getDefault().session;
        int offset = ZosSession.bnetHeaderOffset + ZosSession.lseHeaderOffset + ZosSession.tcpipHeaderOffset;
        int i = 0;
        while (i < iNumber) {
            String SLAJE_Jobname = this.byteBufToString(offset + Integer.parseInt("0", 16), 8);
            String SLAJE_JobType = this.byteBufToString(offset + Integer.parseInt("8", 16), 1);
            if (SLAJE_JobType.equalsIgnoreCase("J")) {
                SLAJE_JobType = "JOB";
            } else if (SLAJE_JobType.equalsIgnoreCase("S")) {
                SLAJE_JobType = "STC";
            } else if (SLAJE_JobType.equalsIgnoreCase("T")) {
                SLAJE_JobType = "TSU";
            }
            String SLAJE_JobID = this.byteBufToString(offset + Integer.parseInt("9", 16), 8);
            String SLAJE_JobStep = this.byteBufToString(offset + Integer.parseInt("11", 16), 8);
            String SLAJE_JobPStep = this.byteBufToString(offset + Integer.parseInt("19", 16), 8);
            String SLAJE_ASID = this.byteBufToString(offset + Integer.parseInt("21", 16), 5);
            String SLAJE_ASIDX = this.byteBufToString(offset + Integer.parseInt("26", 16), 4);
            String SLAJE_CPU = this.byteBufToString(offset + Integer.parseInt("2A", 16), 5);
            float f_percent_cpu = Float.valueOf(SLAJE_CPU).floatValue() / 100.0f;
            String s_percent_cpu = this.constants.decfmt3.format(f_percent_cpu);
            String SLAJE_SIO = this.byteBufToString(offset + Integer.parseInt("2F", 16), 7);
            float f_percent_sio = Float.valueOf(SLAJE_SIO).floatValue() / 100.0f;
            String s_percent_sio = this.constants.decfmt3.format(f_percent_sio);
            String SLAJE_SysName = this.byteBufToString(offset + Integer.parseInt("36", 16), 8);
            String SLAJE_IMSId = this.byteBufToString(offset + Integer.parseInt("3E", 16), 4);
            this.activeJobsItem = new ImsActiveJobsItem();
            ++this.jobcounter;
            this.activeJobsItem.setCheckitem("");
            this.activeJobsItem.setJobname(SLAJE_Jobname);
            this.activeJobsItem.setJobtype(SLAJE_JobType);
            this.activeJobsItem.setJobid(SLAJE_JobID);
            this.activeJobsItem.setStepname(SLAJE_JobStep);
            this.activeJobsItem.setProcstep(SLAJE_JobPStep);
            this.activeJobsItem.setAsid(SLAJE_ASID);
            this.activeJobsItem.setAsidx(SLAJE_ASIDX);
            this.activeJobsItem.setSystem(SLAJE_SysName);
            this.activeJobsItem.setImsId(SLAJE_IMSId);
            this.activeJobsItem.setCpu(s_percent_cpu);
            this.activeJobsItem.setSio(s_percent_sio);
            this.activeJobsItem.setCounter(this.jobcounter);
            this.jobresults.add(this.activeJobsItem);
            offset += iLen;
            ++i;
        }
    }

    public List getJobResults() {
        return this.jobresults;
    }

    public List getSelectedJobResults() {
        ArrayList<ImsActiveJobsItem> selectedjobs = new ArrayList<ImsActiveJobsItem>();
        if (this.jobresults != null) {
            int i = 0;
            while (i < this.jobresults.size()) {
                if (((ImsActiveJobsItem)this.jobresults.get((int)i)).checkitem.length() > 0) {
                    selectedjobs.add((ImsActiveJobsItem)this.jobresults.get(i));
                }
                ++i;
            }
        }
        return selectedjobs;
    }

    public Integer getSelectedJobCount() {
        int selcnt = 0;
        int i = 0;
        while (i < this.jobresults.size()) {
            if (((ImsActiveJobsItem)this.jobresults.get((int)i)).checkitem.length() > 0) {
                ++selcnt;
            }
            ++i;
        }
        return selcnt;
    }

    private String byteBufToString(int offset, int length) {
        ByteBuffer bbRespBuffer = ByteBuffer.wrap(this.bRespBuffer);
        byte[] ba = new byte[length];
        int j = 0;
        while (j < length) {
            ba[j] = bbRespBuffer.get(offset + j);
            ++j;
        }
        String sValue = new String(ba).trim();
        return sValue;
    }

    public void initImsActiveJobsList() {
        this.jobresults = new ArrayList();
        this.jobcounter = 0;
    }
}

