/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.data;

import com.banknet.core.CorePlugin;
import com.banknet.core.connection.ZosConnect;
import com.banknet.core.internal.Constants;
import com.banknet.core.internal.ZosSession;
import java.io.File;
import java.nio.ByteBuffer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;

public class HostProperties {
    ZosConnect zosconnect = new ZosConnect();
    Constants constants = new Constants();
    public String sSystemName = "";
    public String sOSName = "";
    public String sOSVersion = "";
    public String sOSRelease = "";
    public String sOSMod = "";
    public String sGMTO = "";
    public String connectionid = "";
    public String connectionname = "";
    public String servername = "";
    public String portname = "";
    public boolean isremote = false;

    public void getHostProperties(IProgressMonitor monitor) throws Exception {
        this.getLocalConnection();
        this.getRemoteHostProperties(monitor);
    }

    public void getRemoteHostProperties(IProgressMonitor monitor) throws Exception {
        String[] commandarr = new String[]{this.constants.ZOSMESSAGE_GETHOSTPROPERTIES};
        String logstr = "getRemoteHostProperties:  Running " + commandarr[0];
        System.out.println("HostProperties - " + logstr);
        CorePlugin.getDefault().log.debug(logstr);
        byte[] bRespBuffer = CorePlugin.getDefault().session.doCmdResp(commandarr[0], CorePlugin.getDefault().getPreferenceStore().getString("dataSource"));
        if (CorePlugin.getDefault().session.getReturnCode() >= 1000) {
            logstr = "getRemoteHostProperties:  Connect error. " + CorePlugin.getDefault().session.getReturnCode() + ", set connect local";
            System.out.println("HostProperties - " + logstr);
            CorePlugin.getDefault().log.debug(logstr);
            this.zosconnect.setConnectLocal();
            return;
        }
        if (CorePlugin.getDefault().session.getReturnCode() != 0) {
            logstr = "getRemoteHostProperties:  error RC - " + CorePlugin.getDefault().session.getReturnCode();
            System.out.println("HostProperties - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            return;
        }
        if (bRespBuffer == null) {
            return;
        }
        ByteBuffer bbRespBuffer = ByteBuffer.wrap(bRespBuffer);
        if (bbRespBuffer.limit() <= 0) {
            return;
        }
        this.parseHostProperties(bbRespBuffer);
    }

    public void parseHostProperties(ByteBuffer bbRespBuffer) throws Exception {
        ZosSession cfr_ignored_0 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_1 = CorePlugin.getDefault().session;
        bbRespBuffer.getInt(ZosSession.bnetHeaderOffset + ZosSession.tcpipHeaderOffset);
        ZosSession cfr_ignored_2 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_3 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_4 = CorePlugin.getDefault().session;
        bbRespBuffer.getInt(ZosSession.bnetHeaderOffset + ZosSession.tcpipHeaderOffset + ZosSession.lseHeaderOffset_len);
        bbRespBuffer.clear();
        ZosSession cfr_ignored_5 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_6 = CorePlugin.getDefault().session;
        int offset = ZosSession.bnetHeaderOffset + ZosSession.tcpipHeaderOffset;
        byte[] cfr_ignored_7 = new byte[4];
        byte[] ba5 = new byte[5];
        byte[] ba8 = new byte[8];
        byte[] cfr_ignored_8 = new byte[17];
        byte[] ba2 = new byte[2];
        byte[] ba16 = new byte[16];
        int j = 0;
        while (j < 8) {
            ba8[j] = bbRespBuffer.get(offset + j);
            ++j;
        }
        this.sSystemName = new String(ba8).trim();
        j = 0;
        while (j < 16) {
            ba16[j] = bbRespBuffer.get(offset + j + 8);
            ++j;
        }
        this.sOSName = new String(ba16);
        j = 0;
        while (j < 2) {
            ba2[j] = bbRespBuffer.get(offset + j + 24);
            ++j;
        }
        this.sOSVersion = new String(ba2);
        j = 0;
        while (j < 2) {
            ba2[j] = bbRespBuffer.get(offset + j + 26);
            ++j;
        }
        this.sOSRelease = new String(ba2);
        j = 0;
        while (j < 2) {
            ba2[j] = bbRespBuffer.get(offset + j + 28);
            ++j;
        }
        this.sOSMod = new String(ba2);
        ZosSession cfr_ignored_9 = CorePlugin.getDefault().session;
        byte hostPropertiesVersion = bbRespBuffer.get(ZosSession.tcpipHeaderOffset + 12);
        System.out.println("Host Properties Version is " + hostPropertiesVersion);
        this.sGMTO = "0";
        if (hostPropertiesVersion > 1) {
            int j2 = 0;
            while (j2 < 5) {
                ba5[j2] = bbRespBuffer.get(offset + j2 + 30);
                ++j2;
            }
            this.sGMTO = new String(ba5);
        }
        CorePlugin.getDefault().activeSystemname = this.sSystemName;
        System.out.println("System Name " + this.sSystemName);
        System.out.println("OS Name " + this.sOSName);
        System.out.println("Version " + this.sOSVersion);
        System.out.println("Release " + this.sOSRelease);
        System.out.println("Mod     " + this.sOSMod);
        System.out.println("GMT Offset " + this.sGMTO);
    }

    public void getLocalConnection() {
        File path = new File(String.valueOf(CorePlugin.getDefault().getPreferenceStore().getString("coreDataPath")) + CorePlugin.getDefault().productextension.getProductFolder() + File.separator);
        if (!path.exists()) {
            path.mkdir();
        }
        this.connectionid = CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId");
        File[] folders = path.listFiles();
        int i = 0;
        while (i < folders.length) {
            if (folders[i].isDirectory()) {
                if (this.connectionid.length() <= 0) {
                    this.connectionid = folders[i].getName();
                    CorePlugin.getDefault().getPreferenceStore().setValue("activeConnectionId", this.connectionid);
                    break;
                }
                if (folders[i].getName().equalsIgnoreCase(this.connectionid)) break;
            }
            ++i;
        }
        if (CorePlugin.getDefault().connectionextension.getConnectionAttrib(this.connectionid)) {
            this.connectionid = CorePlugin.getDefault().connectionextension.getConnectionId();
            this.connectionname = CorePlugin.getDefault().connectionextension.getConnectionName();
            this.servername = CorePlugin.getDefault().connectionextension.getServerName();
            this.portname = CorePlugin.getDefault().connectionextension.getPortName();
            this.isremote = CorePlugin.getDefault().connectionextension.getIsConnectionRemote();
        }
    }

    private void getConnectionAttrib() {
        String connkey = "";
        StringBuilder stringBuilder = new StringBuilder("/instance/");
        CorePlugin.getDefault();
        IEclipsePreferences connprefs = InstanceScope.INSTANCE.getNode(stringBuilder.append("com.banknet.core").append("/connections").toString());
        try {
            int i = 0;
            while (i < connprefs.childrenNames().length) {
                connkey = connprefs.childrenNames()[i];
                if (this.connectionid.equalsIgnoreCase(connkey)) {
                    StringBuilder stringBuilder2 = new StringBuilder("/instance/");
                    CorePlugin.getDefault();
                    IEclipsePreferences childpref = InstanceScope.INSTANCE.getNode(stringBuilder2.append("com.banknet.core").append("/connections/").append(connkey).toString());
                    this.connectionname = childpref.get(CorePlugin.getDefault().constants.CONNPREF_CONN_NAME, "");
                    this.servername = childpref.get(CorePlugin.getDefault().constants.CONNPREF_SERVER_NAME, "");
                    this.portname = childpref.get(CorePlugin.getDefault().constants.CONNPREF_PORT_NAME, "");
                    break;
                }
                ++i;
            }
        }
        catch (Exception exception) {}
    }

    private void setHostProperties(ByteBuffer bbRespBuffer) {
        ZosSession cfr_ignored_0 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_1 = CorePlugin.getDefault().session;
        bbRespBuffer.getInt(ZosSession.bnetHeaderOffset + ZosSession.tcpipHeaderOffset);
        ZosSession cfr_ignored_2 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_3 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_4 = CorePlugin.getDefault().session;
        bbRespBuffer.getInt(ZosSession.bnetHeaderOffset + ZosSession.tcpipHeaderOffset + ZosSession.lseHeaderOffset_len);
        bbRespBuffer.clear();
        ZosSession cfr_ignored_5 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_6 = CorePlugin.getDefault().session;
        int offset = ZosSession.bnetHeaderOffset + ZosSession.tcpipHeaderOffset;
        byte[] cfr_ignored_7 = new byte[4];
        byte[] ba5 = new byte[5];
        byte[] ba8 = new byte[8];
        byte[] cfr_ignored_8 = new byte[17];
        byte[] ba2 = new byte[2];
        byte[] ba16 = new byte[16];
        int j = 0;
        while (j < 8) {
            ba8[j] = bbRespBuffer.get(offset + j);
            ++j;
        }
        this.sSystemName = new String(ba8).trim();
        j = 0;
        while (j < 16) {
            ba16[j] = bbRespBuffer.get(offset + j + 8);
            ++j;
        }
        this.sOSName = new String(ba16);
        j = 0;
        while (j < 2) {
            ba2[j] = bbRespBuffer.get(offset + j + 24);
            ++j;
        }
        this.sOSVersion = new String(ba2);
        j = 0;
        while (j < 2) {
            ba2[j] = bbRespBuffer.get(offset + j + 26);
            ++j;
        }
        this.sOSRelease = new String(ba2);
        j = 0;
        while (j < 2) {
            ba2[j] = bbRespBuffer.get(offset + j + 28);
            ++j;
        }
        this.sOSMod = new String(ba2);
        ZosSession cfr_ignored_9 = CorePlugin.getDefault().session;
        byte hostPropertiesVersion = bbRespBuffer.get(ZosSession.tcpipHeaderOffset + 12);
        System.out.println("Host Properties Version is " + hostPropertiesVersion);
        this.sGMTO = "0";
        if (hostPropertiesVersion > 1) {
            int j2 = 0;
            while (j2 < 5) {
                ba5[j2] = bbRespBuffer.get(offset + j2 + 30);
                ++j2;
            }
            this.sGMTO = new String(ba5);
        }
        System.out.println("System Name " + this.sSystemName);
        System.out.println("OS Name " + this.sOSName);
        System.out.println("Version " + this.sOSVersion);
        System.out.println("Release " + this.sOSRelease);
        System.out.println("Mod     " + this.sOSMod);
        System.out.println("GMT Offset " + this.sGMTO);
    }

    public void loadHostPropertiesFile(String connectionid) throws Exception {
        if (CorePlugin.getDefault().connectionextension.getConnectionAttrib(connectionid)) {
            this.connectionid = CorePlugin.getDefault().connectionextension.getConnectionId();
            this.connectionname = CorePlugin.getDefault().connectionextension.getConnectionName();
            this.servername = CorePlugin.getDefault().connectionextension.getServerName();
            this.portname = CorePlugin.getDefault().connectionextension.getPortName();
            this.isremote = CorePlugin.getDefault().connectionextension.getIsConnectionRemote();
        }
        String[] commandarr = new String[]{String.valueOf(this.constants.ZOSMESSAGE_GETHOSTPROPERTIES) + " " + connectionid};
        try {
            byte[] bRespBuffer = CorePlugin.getDefault().session.doCmdResp(commandarr[0], CorePlugin.getDefault().getPreferenceStore().getString("dataSource"));
            if (bRespBuffer == null) {
                return;
            }
            ByteBuffer bbRespBuffer = ByteBuffer.wrap(bRespBuffer);
            if (bbRespBuffer.limit() <= 0) {
                return;
            }
            this.setHostProperties(bbRespBuffer);
        }
        catch (Exception exception) {}
    }
}

