/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.data;

import com.banknet.core.CorePlugin;
import com.banknet.core.data.StcProperties;
import com.banknet.core.internal.Constants;
import com.banknet.core.models.ExtractorItem;
import java.util.ArrayList;
import java.util.List;

public class ExtractorsList {
    Constants constants = new Constants();
    ExtractorItem extractorItem;
    private List dataextractors;
    public List selectedextractors;
    String extractorType;
    String reqaction = "";

    public ExtractorsList(List selectedExtractors, String reqaction) {
        this.selectedextractors = selectedExtractors;
        this.reqaction = reqaction;
        this.loadDataExtractors();
    }

    public void loadDataExtractors() {
        StcProperties stcproperties = CorePlugin.getDefault().getStcProperties();
        boolean additem = true;
        this.dataextractors = null;
        this.dataextractors = new ArrayList();
        int i = 0;
        while (i < this.constants.extractorTypes.length) {
            additem = true;
            if (!stcproperties.adabasEnabled & this.constants.extractorTypes[i].equalsIgnoreCase(this.constants.EXTRACTORTYPE_ADABAS)) {
                additem = false;
            } else if (!stcproperties.naturalEnabled & this.constants.extractorTypes[i].equalsIgnoreCase(this.constants.EXTRACTORTYPE_NATURAL)) {
                additem = false;
            } else if (!stcproperties.cicsiEnabled & this.constants.extractorTypes[i].equalsIgnoreCase(this.constants.EXTRACTORTYPE_CICSI)) {
                additem = false;
            } else if (!stcproperties.imsiEnabled & this.constants.extractorTypes[i].equalsIgnoreCase(this.constants.EXTRACTORTYPE_IMSI)) {
                additem = false;
            } else if (!stcproperties.mqiEnabled & this.constants.extractorTypes[i].equalsIgnoreCase(this.constants.EXTRACTORTYPE_MQI)) {
                additem = false;
            } else if (!stcproperties.db2iEnabled) {
                if (this.constants.extractorTypes[i].equalsIgnoreCase(this.constants.EXTRACTORTYPE_DB2I) | this.constants.extractorTypes[i].equalsIgnoreCase(this.constants.EXTRACTORTYPE_DB2V) | this.constants.extractorTypes[i].equalsIgnoreCase(this.constants.EXTRACTORTYPE_DB2X) | this.constants.extractorTypes[i].equalsIgnoreCase(this.constants.EXTRACTORTYPE_CDB2)) {
                    additem = false;
                }
            } else if (!stcproperties.db2xEnabled & this.constants.extractorTypes[i].equalsIgnoreCase(this.constants.EXTRACTORTYPE_DB2X)) {
                additem = false;
            } else if (this.constants.extractorTypes[i].equalsIgnoreCase(this.constants.EXTRACTORTYPE_WAS)) {
                if (!stcproperties.wasEnabled | this.reqaction.equals(this.constants.ACTION_TNEW) | this.reqaction.equals(this.constants.ACTION_TMODIFY)) {
                    additem = false;
                }
            } else if (!stcproperties.sysEnabled & this.constants.extractorTypes[i].equalsIgnoreCase(this.constants.EXTRACTORTYPE_SYS)) {
                additem = false;
            } else if (this.constants.extractorTypes[i].equalsIgnoreCase(this.constants.EXTRACTORTYPE_WLP) && !stcproperties.wlpEnabled | this.reqaction.equals(this.constants.ACTION_TNEW) | this.reqaction.equals(this.constants.ACTION_TMODIFY)) {
                additem = false;
            }
            if (additem) {
                this.addExtractorItem(i);
            }
            ++i;
        }
    }

    private void addExtractorItem(int extractoridx) {
        String selectedtype = "";
        boolean extractorSelected = false;
        int j = 0;
        while (j < this.selectedextractors.size()) {
            selectedtype = (String)this.selectedextractors.get(j);
            if (selectedtype.equalsIgnoreCase(this.constants.extractorTypes[extractoridx])) {
                extractorSelected = true;
                break;
            }
            ++j;
        }
        this.extractorItem = new ExtractorItem();
        this.extractorItem.setExtractorSelected(extractorSelected);
        this.extractorItem.setExtractorType(this.constants.extractorTypes[extractoridx]);
        this.extractorItem.setExtractorName(this.constants.extractorNames[extractoridx]);
        this.dataextractors.add(this.extractorItem);
    }

    public List getDataExtractors() {
        ArrayList<ExtractorItem> dataExtractors = new ArrayList<ExtractorItem>();
        int i = 0;
        while (i < this.dataextractors.size()) {
            if (!((ExtractorItem)this.dataextractors.get((int)i)).extractorSelected) {
                dataExtractors.add((ExtractorItem)this.dataextractors.get(i));
            }
            ++i;
        }
        return dataExtractors;
    }

    public ExtractorItem getExtractorItem(String extractortype) {
        ExtractorItem item = null;
        int i = 0;
        while (i < this.dataextractors.size()) {
            if (extractortype.equalsIgnoreCase(((ExtractorItem)this.dataextractors.get((int)i)).extractorType)) {
                item = (ExtractorItem)this.dataextractors.get(i);
                break;
            }
            ++i;
        }
        return item;
    }

    public List getSelectedExtractors() {
        this.selectedextractors = null;
        this.selectedextractors = new ArrayList();
        int i = 0;
        while (i < this.dataextractors.size()) {
            if (((ExtractorItem)this.dataextractors.get((int)i)).extractorSelected) {
                this.selectedextractors.add((ExtractorItem)this.dataextractors.get(i));
            }
            ++i;
        }
        return this.selectedextractors;
    }

    private void updateDataExtractorsItems() {
        int i = 0;
        while (i < this.selectedextractors.size()) {
            int j = 0;
            while (j < this.dataextractors.size()) {
                if (((ExtractorItem)this.dataextractors.get((int)j)).extractorType.equals(((ExtractorItem)this.selectedextractors.get((int)i)).extractorType)) {
                    ((ExtractorItem)this.dataextractors.get((int)j)).extractorSelected = ((ExtractorItem)this.selectedextractors.get((int)i)).extractorSelected;
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    public boolean isExtractorSelected(String extractortype) {
        boolean extractorselected = false;
        int i = 0;
        while (i < this.selectedextractors.size()) {
            if (((ExtractorItem)this.selectedextractors.get((int)i)).extractorType.equalsIgnoreCase(extractortype)) {
                extractorselected = true;
                break;
            }
            ++i;
        }
        return extractorselected;
    }

    private void updateExtractorItem(ExtractorItem selecteditem, boolean checked) {
        int j = 0;
        while (j < this.dataextractors.size()) {
            if (((ExtractorItem)this.dataextractors.get((int)j)).extractorType.equals(selecteditem.extractorType)) {
                ((ExtractorItem)this.dataextractors.get((int)j)).extractorSelected = checked;
                break;
            }
            ++j;
        }
    }

    public void addSelectedExtractor(ExtractorItem item) {
        boolean itemfound = false;
        int i = 0;
        while (i < this.selectedextractors.size()) {
            ExtractorItem selecteditem = (ExtractorItem)this.selectedextractors.get(i);
            if (item.extractorType.equals(selecteditem.extractorType)) {
                selecteditem.extractorSelected = item.extractorSelected;
            }
            ++i;
        }
        if (!itemfound) {
            this.selectedextractors.add(item);
        }
    }

    public void addSelectedExtractor(String extractortype) {
        ExtractorItem eitem = this.getExtractorItem(extractortype);
        eitem.setExtractorSelected(true);
        this.selectedextractors.add(eitem);
    }

    public void removeSelectedExtractor(ExtractorItem item) {
        this.updateExtractorItem(item, false);
        int i = 0;
        while (i < this.selectedextractors.size()) {
            ExtractorItem selecteditem = (ExtractorItem)this.selectedextractors.get(i);
            if (item.extractorType.equals(selecteditem.extractorType)) {
                this.selectedextractors.remove(i);
                break;
            }
            ++i;
        }
    }

    public void removeSelectedExtractor(String extractortype) {
        ExtractorItem eitem = this.getExtractorItem(extractortype);
        this.removeSelectedExtractor(eitem);
    }

    public String getJobName() {
        String jobname = "";
        return jobname;
    }

    public void setCheckedItem(String extractorType) {
        int i = 0;
        while (i < this.dataextractors.size()) {
            if (((ExtractorItem)this.dataextractors.get((int)i)).extractorType.equals(extractorType)) {
                if (((ExtractorItem)this.dataextractors.get((int)i)).extractorSelected) break;
                ((ExtractorItem)this.dataextractors.get((int)i)).extractorSelected = true;
                this.addSelectedExtractor((ExtractorItem)this.dataextractors.get(i));
                break;
            }
            ++i;
        }
    }
}

