/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.data;

import com.banknet.core.CorePlugin;
import com.banknet.core.connection.ZosConnect;
import com.banknet.core.data.ParseUtilities;
import com.banknet.core.internal.Constants;
import com.banknet.core.internal.ZosSession;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class DatasetList {
    public List<String> dsnList;
    private String searchDsn;
    private static String DSNTYPE_NONVSAM = "A";
    public byte[] bRespBuffer;
    public ByteBuffer bbRespBuffer;
    Constants constants = new Constants();
    ZosConnect zosconnect = new ZosConnect();
    ParseUtilities parseUtilities = new ParseUtilities();

    public void getDatasetList(IProgressMonitor monitor, String searchDsn) throws Exception {
        this.searchDsn = searchDsn;
        this.dsnList = null;
        this.dsnList = new ArrayList<String>();
        this.getRemoteDatasetList(monitor);
    }

    public void getRemoteDatasetList(IProgressMonitor monitor) throws Exception {
        String[] commandarr = new String[]{String.valueOf(this.constants.ZOSMESSAGE_GETDATASETLIST) + " " + this.searchDsn};
        String logstr = "getRemoteDatasetList:  Running " + commandarr[0];
        System.out.println("DatasetList - " + logstr);
        CorePlugin.getDefault().log.debug(logstr);
        this.bRespBuffer = CorePlugin.getDefault().session.doCmdResp(commandarr[0], CorePlugin.getDefault().getPreferenceStore().getString("dataSource"));
        CorePlugin.getDefault().session.checkResponse();
        if (CorePlugin.getDefault().session.getReturnCode() >= 1000) {
            logstr = "getRemoteDatasetList:  Connect error " + CorePlugin.getDefault().session.getReturnCode() + ", set connect local";
            System.out.println("DatasetList - " + logstr);
            CorePlugin.getDefault().log.debug(logstr);
            this.zosconnect.setConnectLocal();
            return;
        }
        if (CorePlugin.getDefault().session.getReturnCode() != 0) {
            logstr = "getRemoteDatasetList: error RC - " + CorePlugin.getDefault().session.getReturnCode();
            System.out.println("DatasetList - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            return;
        }
        this.bbRespBuffer = ByteBuffer.wrap(this.bRespBuffer);
        if (this.bbRespBuffer.limit() <= 0) {
            return;
        }
        ZosSession cfr_ignored_0 = CorePlugin.getDefault().session;
        this.bbRespBuffer.getShort(ZosSession.tcpipHeaderOffset + 10);
        this.bbRespBuffer.clear();
        ZosSession cfr_ignored_1 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_2 = CorePlugin.getDefault().session;
        int iNumber = this.bbRespBuffer.getInt(ZosSession.bnetHeaderOffset + ZosSession.tcpipHeaderOffset + 2);
        ZosSession cfr_ignored_3 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_4 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_5 = CorePlugin.getDefault().session;
        this.bbRespBuffer.getInt(ZosSession.bnetHeaderOffset + ZosSession.tcpipHeaderOffset + ZosSession.lseHeaderOffset_len);
        System.out.println("Number of datasets : " + iNumber);
        ZosSession cfr_ignored_6 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_7 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_8 = CorePlugin.getDefault().session;
        int offset = ZosSession.bnetHeaderOffset + ZosSession.lseHeaderOffset + ZosSession.tcpipHeaderOffset;
        int i = 0;
        while (i < iNumber) {
            short SLDSE_ELen = this.bbRespBuffer.getShort(offset + Integer.parseInt("0", 16));
            String SLDSE_DSNType = this.byteBufToString(offset + Integer.parseInt("2", 16), 1, 'E');
            byte SLDSE_DSNL = this.bbRespBuffer.get(offset + Integer.parseInt("3", 16));
            String SLDSE_DSN = this.byteBufToString(offset + Integer.parseInt("4", 16), SLDSE_DSNL, 'E');
            if (SLDSE_DSNType.equalsIgnoreCase(DSNTYPE_NONVSAM)) {
                this.dsnList.add(SLDSE_DSN);
            }
            offset += SLDSE_ELen;
            ++i;
        }
    }

    public String byteBufToString(int offset, int length, char codepage) {
        byte[] ba = new byte[length];
        String sValue = null;
        int j = 0;
        while (j < length) {
            ba[j] = this.bbRespBuffer.get(offset + j);
            ++j;
        }
        try {
            sValue = codepage == 'E' ? new String(ba, CorePlugin.getDefault().getPreferenceStore().getString("codePage")) : new String(ba);
        }
        catch (Exception e) {
            String logstr = "byteBufToString: offset: " + offset + ", length: " + length + ", codepage: " + codepage + " : Exception " + e;
            System.out.println("byteBufToString - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
        return sValue;
    }
}

