/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.data;

import com.banknet.core.CorePlugin;
import com.banknet.core.internal.Constants;
import com.banknet.core.internal.ZosSession;
import com.banknet.core.models.ActiveJobsItem;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class ActiveJobsList {
    byte[] bRespBuffer;
    ActiveJobsItem activeJobsItem;
    private List jobresults;
    private int jobcounter;
    public List selectedjobs;
    String jobname;
    String spxSystem;
    Constants constants = new Constants();
    String SLAJE_Jobname = "";
    String SLAJE_JobType = "";
    String SLAJE_JobID = "";
    String SLAJE_JobStep = "";
    String SLAJE_JobPStep = "";
    String SLAJE_ASID = "";
    String SLAJE_ASIDX = "";
    String SLAJE_CPU = "";
    String s_percent_cpu = "";
    String SLAJE_SIO = "";
    String s_percent_sio = "";
    String SLAJE_SysName = "";

    public void getActiveJobsList(String jobName, String spxSystem, IProgressMonitor monitor) throws Exception {
        this.jobname = jobName;
        this.spxSystem = spxSystem;
        this.jobresults = new ArrayList();
        this.jobcounter = 0;
        this.getRemoteActiveJobsList(monitor);
        if (this.selectedjobs.size() > 0) {
            this.updateActiveJobsItems();
        }
    }

    public void getLocalActiveJobsList(IProgressMonitor monitor) throws Exception {
        int loopIndex = 0;
        while (loopIndex < 10) {
            this.activeJobsItem = new ActiveJobsItem();
            ++this.jobcounter;
            this.activeJobsItem.setCheckitem("");
            this.activeJobsItem.setJobname("ACS01X" + Integer.toString(loopIndex));
            this.activeJobsItem.setJobtype("TSO");
            this.activeJobsItem.setJobid("TSU03003");
            this.activeJobsItem.setStepname("BNETPROC");
            this.activeJobsItem.setProcstep("PRGPROC");
            this.activeJobsItem.setAsid("0071");
            this.activeJobsItem.setAsidx("0071");
            this.activeJobsItem.setSystem("X235");
            this.activeJobsItem.setCpu("87.91" + Integer.toString(loopIndex));
            this.activeJobsItem.setSio("23.97" + Integer.toString(loopIndex));
            this.activeJobsItem.setJobSelected(false);
            this.activeJobsItem.setCounter(this.jobcounter);
            this.jobresults.add(this.activeJobsItem);
            ++loopIndex;
        }
    }

    public void getRemoteActiveJobsList(IProgressMonitor monitor) throws Exception {
        String[] commandarr = new String[]{String.valueOf(this.constants.ZOSMESSAGE_GETACTIVEJOBLIST) + " " + this.jobname + ",," + this.spxSystem};
        String logstr = "ActiveJobsList: Running " + commandarr[0];
        System.out.println(logstr);
        CorePlugin.getDefault().log.debug("ActiveJobsList:  getRemoteActiveJobsList,  " + logstr);
        this.bRespBuffer = CorePlugin.getDefault().session.doCmdResp(commandarr[0], CorePlugin.getDefault().getPreferenceStore().getString("dataSource"));
        ByteBuffer bbRespBuffer = ByteBuffer.wrap(this.bRespBuffer);
        this.parseActiveJobsList(bbRespBuffer);
    }

    public void parseActiveJobsList(ByteBuffer bbRespBuffer) throws Exception {
        ZosSession cfr_ignored_0 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_1 = CorePlugin.getDefault().session;
        int iNumber = bbRespBuffer.getInt(ZosSession.bnetHeaderOffset + ZosSession.tcpipHeaderOffset + 2);
        ZosSession cfr_ignored_2 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_3 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_4 = CorePlugin.getDefault().session;
        int iLen = bbRespBuffer.getInt(ZosSession.bnetHeaderOffset + ZosSession.tcpipHeaderOffset + ZosSession.lseHeaderOffset_len);
        bbRespBuffer.clear();
        ZosSession cfr_ignored_5 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_6 = CorePlugin.getDefault().session;
        ZosSession cfr_ignored_7 = CorePlugin.getDefault().session;
        int offset = ZosSession.bnetHeaderOffset + ZosSession.lseHeaderOffset + ZosSession.tcpipHeaderOffset;
        int i = 0;
        while (i < iNumber) {
            this.SLAJE_Jobname = this.byteBufToString(offset + Integer.parseInt("0", 16), 8);
            this.SLAJE_JobType = this.byteBufToString(offset + Integer.parseInt("8", 16), 1);
            if (this.SLAJE_JobType.equalsIgnoreCase("J")) {
                this.SLAJE_JobType = "JOB";
            } else if (this.SLAJE_JobType.equalsIgnoreCase("S")) {
                this.SLAJE_JobType = "STC";
            } else if (this.SLAJE_JobType.equalsIgnoreCase("T")) {
                this.SLAJE_JobType = "TSU";
            }
            this.SLAJE_JobID = this.byteBufToString(offset + Integer.parseInt("9", 16), 8);
            this.SLAJE_JobStep = this.byteBufToString(offset + Integer.parseInt("11", 16), 8);
            this.SLAJE_JobPStep = this.byteBufToString(offset + Integer.parseInt("19", 16), 8);
            this.SLAJE_ASID = this.byteBufToString(offset + Integer.parseInt("21", 16), 5);
            this.SLAJE_ASIDX = this.byteBufToString(offset + Integer.parseInt("26", 16), 4);
            this.SLAJE_CPU = this.byteBufToString(offset + Integer.parseInt("2A", 16), 5);
            float f_percent_cpu = Float.valueOf(this.SLAJE_CPU).floatValue() / 100.0f;
            this.s_percent_cpu = this.constants.decfmt3.format(f_percent_cpu);
            this.SLAJE_SIO = this.byteBufToString(offset + Integer.parseInt("2F", 16), 7);
            float f_percent_sio = Float.valueOf(this.SLAJE_SIO).floatValue() / 100.0f;
            this.s_percent_sio = this.constants.decfmt3.format(f_percent_sio);
            this.SLAJE_SysName = this.byteBufToString(offset + Integer.parseInt("36", 16), 8);
            this.addActiveJob();
            offset += iLen;
            ++i;
        }
    }

    private void addActiveJob() {
        this.activeJobsItem = new ActiveJobsItem();
        ++this.jobcounter;
        this.activeJobsItem.setCheckitem("");
        this.activeJobsItem.setJobname(this.SLAJE_Jobname);
        this.activeJobsItem.setJobtype(this.SLAJE_JobType);
        this.activeJobsItem.setJobid(this.SLAJE_JobID);
        this.activeJobsItem.setStepname(this.SLAJE_JobStep);
        this.activeJobsItem.setProcstep(this.SLAJE_JobPStep);
        this.activeJobsItem.setAsid(this.SLAJE_ASID);
        this.activeJobsItem.setAsidx(this.SLAJE_ASIDX);
        this.activeJobsItem.setSystem(this.SLAJE_SysName);
        this.activeJobsItem.setCpu(this.s_percent_cpu);
        this.activeJobsItem.setSio(this.s_percent_sio);
        this.activeJobsItem.setJobSelected(false);
        this.activeJobsItem.setCounter(this.jobcounter);
        this.jobresults.add(this.activeJobsItem);
    }

    public List getJobResults() {
        ArrayList<ActiveJobsItem> results = new ArrayList<ActiveJobsItem>();
        int i = 0;
        while (i < this.jobresults.size()) {
            if (!((ActiveJobsItem)this.jobresults.get((int)i)).jobselected) {
                results.add((ActiveJobsItem)this.jobresults.get(i));
            }
            ++i;
        }
        return results;
    }

    public List getSelectedJobResults() {
        return this.selectedjobs;
    }

    private void updateActiveJobsItems() {
        int i = 0;
        while (i < this.selectedjobs.size()) {
            int j = 0;
            while (j < this.jobresults.size()) {
                if (((ActiveJobsItem)this.jobresults.get((int)j)).jobname.equals(((ActiveJobsItem)this.selectedjobs.get((int)i)).jobname) && ((ActiveJobsItem)this.jobresults.get((int)j)).system.equals(((ActiveJobsItem)this.selectedjobs.get((int)i)).system)) {
                    ((ActiveJobsItem)this.jobresults.get((int)j)).jobselected = ((ActiveJobsItem)this.selectedjobs.get((int)i)).jobselected;
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    private void updateActiveJobsItem(ActiveJobsItem selecteditem, String checked) {
        int j = 0;
        while (j < this.jobresults.size()) {
            if (((ActiveJobsItem)this.jobresults.get((int)j)).jobname.equals(selecteditem.jobname) && ((ActiveJobsItem)this.jobresults.get((int)j)).system.equals(selecteditem.system)) {
                ((ActiveJobsItem)this.jobresults.get((int)j)).jobselected = false;
                break;
            }
            ++j;
        }
    }

    public void addSelectedJob(ActiveJobsItem item) {
        boolean itemfound = false;
        int i = 0;
        while (i < this.selectedjobs.size()) {
            ActiveJobsItem selecteditem = (ActiveJobsItem)this.selectedjobs.get(i);
            if (item.jobname.equals(selecteditem.jobname) && item.system.equals(selecteditem.system)) {
                selecteditem.jobselected = true;
            }
            ++i;
        }
        if (!itemfound) {
            this.selectedjobs.add(item);
        }
    }

    public void removeSelectedJob(ActiveJobsItem item) {
        this.updateActiveJobsItem(item, "");
        int i = 0;
        while (i < this.selectedjobs.size()) {
            ActiveJobsItem selecteditem = (ActiveJobsItem)this.selectedjobs.get(i);
            if (item.jobname.equals(selecteditem.jobname) && item.system.equals(selecteditem.system)) {
                this.selectedjobs.remove(i);
                break;
            }
            ++i;
        }
    }

    public void setCheckedItem(String jobname, String spxSystem) {
        int i = 0;
        while (i < this.jobresults.size()) {
            if (this.selectedjobs.size() <= 0 && ((ActiveJobsItem)this.jobresults.get((int)i)).jobname.equals(jobname) && (spxSystem.length() <= 0 || spxSystem.equalsIgnoreCase("ALL") || ((ActiveJobsItem)this.jobresults.get((int)i)).system.equals(spxSystem))) {
                if (((ActiveJobsItem)this.jobresults.get((int)i)).jobselected) break;
                ((ActiveJobsItem)this.jobresults.get((int)i)).jobselected = true;
                this.addSelectedJob((ActiveJobsItem)this.jobresults.get(i));
                break;
            }
            ++i;
        }
    }

    public String getJobName() {
        String jobname = "";
        if (this.selectedjobs.size() > 0) {
            jobname = ((ActiveJobsItem)this.selectedjobs.get((int)0)).jobname;
        }
        return jobname;
    }

    private String byteBufToString(int offset, int length) {
        ByteBuffer bbRespBuffer = ByteBuffer.wrap(this.bRespBuffer);
        byte[] ba = new byte[length];
        int j = 0;
        while (j < length) {
            ba[j] = bbRespBuffer.get(offset + j);
            ++j;
        }
        String sValue = new String(ba).trim();
        return sValue;
    }
}

