/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.connection;

import com.banknet.core.CorePlugin;
import com.banknet.core.connection.Messages;
import com.banknet.core.internal.ZosSession;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.text.DecimalFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class ZosConnectionUtilities {
    public String[] blankarr = new String[]{" "};
    public String[] supportedProtocols = null;
    public String[] supportedCiphers = null;

    public int zosRead(String command, IProgressMonitor monitor) {
        ByteBuffer tempBuffer;
        int numBytesRead = 0;
        int totalBytesRead = 0;
        int byteCounter = 0;
        float fbyteCounter = 0.0f;
        int headerLength = ZosSession.tcpipHeaderOffset;
        int maxDumpLength = 1000;
        int saveHeaderLength = 1000;
        int blockSize = 0;
        try {
            blockSize = CorePlugin.getDefault().session.socketBufferSize;
        }
        catch (Exception exception) {}
        byte[] tempArray = new byte[blockSize];
        DecimalFormat decfmt = new DecimalFormat("###,###,###,##0");
        if (monitor == null) {
            monitor = CorePlugin.getDefault().monitor;
        }
        try {
            numBytesRead = CorePlugin.getDefault().session.inputstream.read(tempArray, 0, headerLength);
            tempBuffer = ByteBuffer.wrap(tempArray, 0, numBytesRead);
            totalBytesRead = numBytesRead;
        }
        catch (Exception exception) {
            CorePlugin.getDefault().session.doCmdResp_rc = -99;
            this.logMessage('I', "Command : " + command + " exception while reading z/OS Response Header.  Numbytes read : " + totalBytesRead);
            if (totalBytesRead > 0) {
                this.dumpMessage("zosREAD", tempArray, Integer.toString(totalBytesRead));
            }
            return -1;
        }
        if (numBytesRead < headerLength) {
            this.logMessage('I', "Command : " + command + " Unable to receive complete z/OS Response Header.  Bytes read: " + numBytesRead);
            if (totalBytesRead > 0) {
                this.dumpMessage("zosREAD", tempArray, Integer.toString(totalBytesRead));
            }
            return -1;
        }
        String sValue = new String(tempArray, 0, 10).trim();
        int firstDigitComplete = 0;
        int messageLength = Integer.parseInt(sValue);
        int respHeaderLen = Integer.parseInt(sValue) - headerLength;
        byte[] messageArray = new byte[messageLength];
        String qualifiedFName = CorePlugin.getDefault().session.queueFile(command);
        FileOutputStream foutWorkspace = null;
        FileChannel fcoutWorkspace = null;
        try {
            foutWorkspace = new FileOutputStream(qualifiedFName);
            fcoutWorkspace = foutWorkspace.getChannel();
        }
        catch (Exception exception) {
            this.logMessage('I', "Command : " + command + ".  Unable to allocate file " + qualifiedFName);
            return -1;
        }
        try {
            fcoutWorkspace.write(tempBuffer);
            System.arraycopy(tempArray, 0, messageArray, 0, headerLength);
        }
        catch (Exception exception) {
            this.logMessage('I', "Command : " + command + " Unable to persist z/OS Response Header ");
            try {
                foutWorkspace.close();
            }
            catch (Exception exception2) {
                this.logMessage('I', "Command : " + command + ".  Unable to close file " + qualifiedFName);
            }
            return -1;
        }
        int bytesToRead = 0;
        bytesToRead = respHeaderLen > blockSize ? blockSize : respHeaderLen;
        while (totalBytesRead < messageLength) {
            tempBuffer.clear();
            try {
                numBytesRead = CorePlugin.getDefault().session.inputstream.read(tempArray, 0, bytesToRead);
                if (numBytesRead < 0) break;
                tempBuffer = ByteBuffer.wrap(tempArray, 0, numBytesRead);
                fcoutWorkspace.write(tempBuffer);
                System.arraycopy(tempArray, 0, messageArray, totalBytesRead, numBytesRead);
                totalBytesRead += numBytesRead;
            }
            catch (Exception exception) {
                this.logMessage('I', "Command : " + command + " Error Reading z/OS Response  ");
                try {
                    foutWorkspace.close();
                    return -1;
                }
                catch (Exception exception3) {
                    this.logMessage('I', "Command : " + command + ".  Unable to close file " + qualifiedFName);
                }
            }
            bytesToRead = messageLength - totalBytesRead > blockSize ? blockSize : messageLength - totalBytesRead;
            fbyteCounter = new Float(byteCounter += numBytesRead).floatValue();
            float frespHeaderLen = new Float(respHeaderLen).floatValue();
            int percentComplete = (int)(fbyteCounter / frespHeaderLen * 100.0f);
            int saveFirstDigit = firstDigitComplete;
            firstDigitComplete = percentComplete / 10;
            if (firstDigitComplete == saveFirstDigit || !(monitor != null & command.equalsIgnoreCase("GETOBSREPORTS") & respHeaderLen > 60)) continue;
            String cfr_ignored_0 = "\n" + decfmt.format(fbyteCounter) + Messages.getString("ZosConnectionUtilities.Job.SubTask.Of") + decfmt.format(frespHeaderLen) + Messages.getString("ZosConnectionUtilities.Job.SubTask.BytesDownloaded");
            monitor.subTask(String.valueOf(Messages.getString("ZosConnectionUtilities.Job.SubTask.Step2of3")) + percentComplete + Messages.getString("ZosConnectionUtilities.Job.SubTask.PctComplete") + "\n" + decfmt.format(fbyteCounter) + Messages.getString("ZosConnectionUtilities.Job.SubTask.Of") + decfmt.format(frespHeaderLen) + Messages.getString("ZosConnectionUtilities.Job.SubTask.BytesDownloaded"));
            monitor.worked(5);
        }
        try {
            fcoutWorkspace.close();
            fcoutWorkspace = null;
            foutWorkspace.close();
            foutWorkspace = null;
        }
        catch (Exception exception) {
            this.logMessage('I', "Command : " + command + ".  Unable to close files.");
        }
        ZosSession.headerBuffer.clear();
        if (messageArray.length >= saveHeaderLength) {
            this.dumpMessage("zosREAD", messageArray, Integer.toString(maxDumpLength));
            ZosSession.headerBuffer.put(messageArray, 0, saveHeaderLength);
        } else {
            this.dumpMessage("zosREAD", messageArray, Integer.toString(messageArray.length - 1));
            ZosSession.headerBuffer.put(messageArray, 0, messageArray.length - 1);
        }
        return totalBytesRead;
    }

    public int zosWrite(byte[] bnetMessage, IProgressMonitor monitor) {
        if (CorePlugin.getDefault().log.isDebugEnabled()) {
            this.dumpMessage("zosWrite", bnetMessage, Integer.toString(bnetMessage.length));
        }
        int writeRC = 0;
        try {
            CorePlugin.getDefault().session.outputstream.write(bnetMessage);
            CorePlugin.getDefault().session.outputstream.flush();
        }
        catch (Exception exception) {
            writeRC = -1;
            return writeRC;
        }
        return 0;
    }

    public void disconnectZos() {
        if (CorePlugin.getDefault().getPreferenceStore().getString("dataSource").compareToIgnoreCase("remote") >= 0) {
            CorePlugin.getDefault().session.doCmdResp("SHUTDOWN", CorePlugin.getDefault().getPreferenceStore().getString("dataSource"));
        }
        try {
            CorePlugin.getDefault().session.endSession();
        }
        catch (Exception exception) {}
        CorePlugin.getDefault().connectedHosts.remove(CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId"));
        CorePlugin.getDefault().getPreferenceStore().setValue("coreConnected", false);
    }

    public void forceCancelZos() {
        Job jobA = new Job(Messages.getString("ZosConnect.Job.Title.Force")){

            public IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.getString("ZosConnect.Job.Task.CancelReq"), 100);
                String logstr = "forceCancelZos:  Cancelling Session";
                System.out.println("ZosConnect - " + logstr);
                CorePlugin.getDefault().log.debug(logstr);
                try {
                    CorePlugin.getDefault().session.endSession();
                }
                catch (Exception exception) {}
                monitor.done();
                CorePlugin.getDefault().connectedHosts.remove(CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId"));
                CorePlugin.getDefault().getPreferenceStore().setValue("coreConnected", false);
                return Status.OK_STATUS;
            }
        };
        jobA.schedule();
    }

    public void logMessage(char loglevel, String logstr) {
        System.out.println("ZosSession - " + logstr);
        switch (loglevel) {
            case 'E': {
                CorePlugin.getDefault().log.error(logstr);
                break;
            }
            case 'I': {
                CorePlugin.getDefault().log.info(logstr);
                break;
            }
            case 'W': {
                CorePlugin.getDefault().log.warn(logstr);
                break;
            }
            default: {
                CorePlugin.getDefault().log.debug(logstr);
            }
        }
    }

    public void dumpMessage(String function, byte[] message, String dumpLength) {
        int byteCount = 0;
        int formatCount = 0;
        int messageOffset = 0;
        int messageLength = 0;
        if (dumpLength.equalsIgnoreCase("ALL")) {
            messageLength = message.length;
        } else {
            messageLength = Integer.parseInt(dumpLength);
            if (messageLength > message.length) {
                messageLength = message.length;
            }
        }
        if (message.length == 0) {
            System.out.println("No message to print");
            return;
        }
        System.out.println(String.valueOf(function) + " Message:");
        CorePlugin.getDefault().log.debug(String.valueOf(function) + " Message:");
        StringBuilder messageBuffer = new StringBuilder();
        String hexMessage = "";
        String asciiMessage = "";
        byteCount = 0;
        messageOffset = 0;
        while (byteCount < messageLength) {
            if (byteCount % 16 == 0) {
                if (byteCount != 0) {
                    messageBuffer.append(hexMessage);
                    messageBuffer.append("\t");
                    messageBuffer.append(asciiMessage);
                    CorePlugin.getDefault().log.debug(messageBuffer.toString());
                    System.out.println(messageBuffer.toString());
                    messageBuffer.setLength(0);
                }
                asciiMessage = "";
                hexMessage = String.format("%#06x ", messageOffset);
            }
            hexMessage = hexMessage.concat(String.format("%#04x ", message[byteCount]));
            asciiMessage = message[byteCount] > 31 && message[byteCount] < 127 ? asciiMessage.concat(String.valueOf((char)message[byteCount])) : asciiMessage.concat(".");
            ++byteCount;
            ++messageOffset;
        }
        if (byteCount % 16 > 0) {
            formatCount = 0;
            while (formatCount < 16 - byteCount % 16) {
                hexMessage = hexMessage.concat("     ");
                ++formatCount;
            }
        }
        messageBuffer.append(hexMessage);
        messageBuffer.append("\t");
        messageBuffer.append(asciiMessage);
        CorePlugin.getDefault().log.debug(messageBuffer.toString());
        System.out.println(messageBuffer.toString());
    }
}

