/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.connection;

import com.banknet.core.CorePlugin;
import com.banknet.core.connection.Messages;
import com.banknet.core.dialogs.UpdatesAvailableDialog;
import com.banknet.core.dialogs.connection.ConnectionDialog;
import com.banknet.core.dialogs.connection.LogonDialog;
import com.banknet.core.internal.Constants;
import com.banknet.core.internal.Utilities;
import com.banknet.core.internal.ZosSession;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.StringTokenizer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ZosConnect {
    Constants constants = new Constants();
    Utilities utilities = new Utilities();
    public Integer connectrc = 0;
    public String localReason = "";
    public String shostAddress = "";
    public String scpuPort = "";
    public String decodedPsw = "";
    public boolean sslConnect = false;
    public String sslTrustStore = "";
    public String sslTrustStorePsw = "";
    public String sslProtocol = "";
    public String sslCipher = "";
    public String compatgui_version = "";
    public String compatgui_build = "";
    String dlgui_version = "";
    String dlgui_fixpack = "";
    String zOS_dlgui = "";
    String zOS_compatgui = "";
    String dlgui = "";
    public int connrc = 0;
    public String connrsn = "";
    public String errmsg = "";
    Shell shell = null;

    public void pingZos(IProgressMonitor monitor) {
        this.connectrc = 0;
        monitor.subTask(Messages.getString("ZosConnect.Job.SubTask.Ping"));
        CorePlugin.getDefault().session.doCmdResp("PING", CorePlugin.getDefault().getPreferenceStore().getString("dataSource"));
        this.connectrc = CorePlugin.getDefault().session.getDoCmdRespRc();
        if (this.connectrc > 0) {
            CorePlugin.getDefault().connectionextension.forceCancelZos();
            monitor.worked(20);
        }
    }

    public void connectZos() {
        if (CorePlugin.getDefault().session == null) {
            CorePlugin.getDefault().session = new ZosSession();
        }
        if (CorePlugin.getDefault().getPreferenceStore().getString("dataSource").compareToIgnoreCase("remote") >= 0) {
            this.connectZos(CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId"));
        } else {
            this.loadModelsJob();
        }
    }

    public void connectZos(String connectionid) {
        int logonrc = 0;
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        if (connectionid.length() <= 0) {
            ConnectionDialog ncd = new ConnectionDialog(shell.getShell(), connectionid);
            logonrc = ncd.open();
            if (logonrc == 0) {
                connectionid = ncd.connectionid;
            }
            ncd = null;
        }
        if (logonrc == 0) {
            LogonDialog dialog = new LogonDialog(shell.getShell(), connectionid);
            logonrc = dialog.open();
            if (logonrc == 0) {
                this.loadModelsJob();
            } else if (logonrc == 1 && CorePlugin.getDefault().getPreferenceStore().getString("dataSource").compareToIgnoreCase("remote") >= 0) {
                CorePlugin.getDefault().connectionextension.forceCancelZos();
                this.setConnectLocal();
                this.loadModelsJob();
            }
            dialog = null;
        }
    }

    public void banknetConnect() {
        this.connrc = 0;
        this.connrsn = "";
        this.errmsg = "";
        CorePlugin.getDefault().getPreferenceStore().setValue("dataSource", "remote");
        this.logMessage('D', "**********");
        this.logMessage('D', "logonZos:  Logging on to z/os started " + this.constants.yyyymmddhhmmss.format(new Date()));
        if (CorePlugin.getDefault().session == null) {
            CorePlugin.getDefault().session = new ZosSession();
        }
        int iPortNum = new Integer(this.scpuPort);
        this.sslTrustStore = "";
        this.sslTrustStorePsw = "";
        this.sslProtocol = "";
        this.sslCipher = "";
        this.logMessage('D', "logonZos:  SSL Connection: " + this.sslConnect);
        CorePlugin.getDefault().session.sslOn = this.sslConnect;
        this.logMessage('D', "logonZos:  Start  Session, " + this.shostAddress + ", " + iPortNum);
        int rc = CorePlugin.getDefault().session.startSession(this.shostAddress, iPortNum);
        CorePlugin.getDefault().session.checkResponse();
        rc = CorePlugin.getDefault().session.getReturnCode();
        if (rc != 0) {
            this.setConnectError();
            return;
        }
    }

    public void logonZos() {
        this.connrc = 0;
        this.connrsn = "";
        this.errmsg = "";
        int rc = 0;
        CorePlugin.getDefault().getPreferenceStore().setValue("dataSource", "remote");
        CorePlugin.getDefault().firstTake = 1;
        CorePlugin.getDefault().connaddr = this.shostAddress;
        CorePlugin.getDefault().connport = this.scpuPort;
        this.logMessage('I', "logonZos:  Sending z/OS Listener version: " + CorePlugin.getDefault().formatted_GUI_version + "," + CorePlugin.getDefault().formatted_GUI_fixpack);
        String command = String.valueOf(this.constants.ZOSMESSAGE_SENDHANDSHAKE) + " " + CorePlugin.getDefault().formatted_GUI_version + "," + CorePlugin.getDefault().formatted_GUI_fixpack;
        this.logMessage('D', "logonZos:  Running SENDHANDSHAKE: " + command);
        rc = CorePlugin.getDefault().session.sendSystemMessage(command, 'A');
        CorePlugin.getDefault().session.checkResponse();
        if (rc > 1000) {
            this.setConnectError();
            return;
        }
        this.chkCOMPATGUI();
        CorePlugin.getDefault().session.checkResponse();
        rc = CorePlugin.getDefault().session.getReturnCode();
        if (rc != 0) {
            this.setConnectError();
            return;
        }
        command = String.valueOf(this.constants.ZOSMESSAGE_SENDAPPLID) + "," + CorePlugin.getDefault().tsoid + "," + this.decodedPsw;
        System.out.println("Running " + command);
        this.logMessage('D', "logonZos:  Running START: " + command.substring(0, command.lastIndexOf(",")));
        rc = CorePlugin.getDefault().session.sendSystemMessage(command, 'E');
        if (rc == 1006) {
            this.setConnectError();
            return;
        }
        CorePlugin.getDefault().session.checkResponse();
        rc = CorePlugin.getDefault().session.getReturnCode();
        if (rc != 0) {
            this.setConnectError();
            return;
        }
        command = String.valueOf(this.constants.ZOSMESSAGE_SIGNON) + " " + CorePlugin.getDefault().tsoid;
        this.logMessage('D', "logonZos:  Running SIGNON: " + command);
        CorePlugin.getDefault().session.doCmdResp(command, CorePlugin.getDefault().getPreferenceStore().getString("dataSource"));
        if (rc > 0) {
            this.setConnectError();
            return;
        }
        System.out.println("logging on to z/os completed");
        CorePlugin.getDefault().getPreferenceStore().setValue("hostAddress", this.shostAddress);
        CorePlugin.getDefault().getPreferenceStore().setValue("cpuPortPreference", this.scpuPort);
        CorePlugin.getDefault().getPreferenceStore().setValue("credentialUid", CorePlugin.getDefault().tsoid);
        CorePlugin.getDefault().activeStc = "";
    }

    private void setConnectError() {
        this.connrc = CorePlugin.getDefault().session.getReturnCode();
        this.connrsn = CorePlugin.getDefault().session.getReason();
        String message = CorePlugin.getDefault().session.getReason();
        if (CorePlugin.getDefault().session.doCmdResp_rc == 1008) {
            String version = this.stripChar(this.compatgui_version.substring(0, 3), '0');
            String release = this.stripChar(this.compatgui_version.substring(3, 6), '0');
            String modlevel = this.stripChar(this.compatgui_version.substring(6, 9), '0');
            String fixpack = this.stripChar(this.compatgui_build.substring(0, 5), '0');
            String formatted_version = String.format("%s.%s.%s.%s", version, release, modlevel, fixpack);
            message = message.replaceAll("#version", formatted_version);
            message = message.replaceAll("#productname", CorePlugin.getDefault().productextension.getProductName());
        }
        this.logMessage('E', "connect:  error RC " + this.connrc + " - " + message);
        this.errmsg = message;
    }

    public void chkCOMPATGUI() {
        try {
            this.setCompatGui();
            if (this.zOS_compatgui.compareToIgnoreCase(CorePlugin.getDefault().formatted_GUI_versionfixpack) == 0) {
                this.logMessage('D', "chkCOMPATGUI:  zOS COMPATGUI (" + this.zOS_compatgui + ") = PLUGIN_GUI (" + CorePlugin.getDefault().formatted_GUI_versionfixpack + ")  :  versions match");
            } else if (this.zOS_compatgui.compareToIgnoreCase(CorePlugin.getDefault().formatted_GUI_versionfixpack) < 0) {
                if (this.zOS_dlgui.compareToIgnoreCase(CorePlugin.getDefault().formatted_GUI_versionfixpack) < 0) {
                    this.logMessage('I', "chkCOMPATGUI:  zOS COMPATGUI (" + this.zOS_compatgui + ") AND DLGUI (" + this.zOS_dlgui + ") < PLUGIN_GUI (" + CorePlugin.getDefault().formatted_GUI_versionfixpack + ") :  PLUGIN_GUI is newer version than z/OS.");
                } else {
                    this.logMessage('D', "chkCOMPATGUI:  zOS COMPATGUI (" + this.zOS_compatgui + ") < PLUGIN_GUI (" + CorePlugin.getDefault().formatted_GUI_versionfixpack + ") :  COMPATGUI is older version ... compatible release, download is not required");
                }
            } else {
                CorePlugin.getDefault().session.doCmdResp_rc = 1008;
                this.logMessage('E', "chkCOMPATGUI:  zOS COMPATGUI (" + this.zOS_compatgui + ") > PLUGIN_GUI (" + CorePlugin.getDefault().formatted_GUI_versionfixpack + ") :  1008 - COMPATGUI is newer version ... ERROR, unsupported Release, download new product");
            }
        }
        catch (Exception exception) {}
        CorePlugin.getDefault().constants.reqdefault = CorePlugin.getDefault().versionextension.getReqDefaultSize();
        CorePlugin.getDefault().constants.reqdecfmt = new DecimalFormat(CorePlugin.getDefault().versionextension.getReqDecFmt());
        CorePlugin.getDefault().constants.reqbytebufsize = CorePlugin.getDefault().versionextension.getReqByteBufSize();
    }

    private void setCompatGui() {
        try {
            String compatgui = CorePlugin.getDefault().session.COMPATGUI.substring(1, CorePlugin.getDefault().session.COMPATGUI.length() - 1);
            StringTokenizer st = new StringTokenizer(compatgui, ",");
            this.compatgui_version = st.nextToken();
            this.compatgui_build = st.nextToken();
            this.zOS_compatgui = String.valueOf(this.compatgui_version) + "." + this.compatgui_build;
            this.dlgui = CorePlugin.getDefault().session.DLGUI.substring(1, CorePlugin.getDefault().session.DLGUI.length() - 1);
            st = new StringTokenizer(this.dlgui, ",");
            this.dlgui_version = st.nextToken();
            this.dlgui_fixpack = st.nextToken();
            this.zOS_dlgui = String.valueOf(this.dlgui_version) + "." + this.dlgui_fixpack;
        }
        catch (Exception exception) {}
    }

    public void chkUpdatesAvailable() {
        this.setCompatGui();
        if (!CorePlugin.getDefault().getPreferenceStore().getBoolean("autoUpdates")) {
            return;
        }
        if (this.zOS_dlgui.compareToIgnoreCase(CorePlugin.getDefault().formatted_GUI_versionfixpack) > 0) {
            this.logMessage('D', "checkUpdatesAvailable:  DLGUI (" + this.zOS_dlgui + ") > PLUGIN_GUI (" + CorePlugin.getDefault().formatted_GUI_versionfixpack + ") :  DLGUI is newer version ... INFO, updates available.");
            if (this.zOS_dlgui.compareToIgnoreCase(CorePlugin.getDefault().getPreferenceStore().getString("dlGui")) == 0) {
                return;
            }
            this.shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
            UpdatesAvailableDialog dialog = new UpdatesAvailableDialog(this.shell.getShell(), this.dlgui_version, this.dlgui_fixpack);
            dialog.open();
        }
    }

    public void runKeepAlive() {
        CorePlugin.getDefault().jobKeepAlive = null;
        CorePlugin.getDefault().jobKeepAlive = new Job(Messages.getString("ZosConnect.Job.Title.KeepAlivePing")){

            public IStatus run(IProgressMonitor monitor) {
                String logstr = "runKeepAlive:  " + ZosConnect.this.constants.yyyymmddhhmmss.format(new Date()) + " " + this.getName();
                System.out.println("ZosConnect - " + logstr);
                CorePlugin.getDefault().log.debug(logstr);
                if (CorePlugin.getDefault().getPreferenceStore().getString("dataSource").compareToIgnoreCase("remote") >= 0) {
                    monitor.beginTask(Messages.getString("ZosConnect.Job.Task.Ping"), 100);
                    ZosConnect.this.pingZos(monitor);
                    if (ZosConnect.this.getConnectRc() != 0) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ZosConnect.this.showMessage("info", String.valueOf(Messages.getString("ZosConnect.MessageDialog.infoTitle.Zos")) + CorePlugin.getDefault().productextension.getProductName() + Messages.getString("ZosConnect.MessageDialog.infoMessage.ConnectionLost"), String.valueOf(Messages.getString("ZosConnect.MessageDialog.infoMessage.RemoteConnectionLost")) + Messages.getString("ZosConnect.MessageDialog.infoMessage.ReConnect"));
                            }
                        });
                        return Status.CANCEL_STATUS;
                    }
                } else {
                    return Status.CANCEL_STATUS;
                }
                monitor.done();
                int keepAlive = CorePlugin.getDefault().session.keepAliveSecs * 1000;
                this.schedule(keepAlive);
                return Status.OK_STATUS;
            }
        };
        CorePlugin.getDefault().jobKeepAlive.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (!event.getResult().isOK()) {
                    String logstr = "runKeepAlive:  " + ZosConnect.this.constants.yyyymmddhhmmss.format(new Date()) + " Local Connection -  Keep Alive Ping Cancelled.";
                    System.out.println("ZosConnect - " + logstr);
                    CorePlugin.getDefault().log.debug(logstr);
                }
            }
        });
        CorePlugin.getDefault().jobKeepAlive.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        CorePlugin.getDefault().jobKeepAlive.schedule();
    }

    private void cancelKeepAlive() {
        if (CorePlugin.getDefault().jobKeepAlive != null) {
            CorePlugin.getDefault().jobKeepAlive.cancel();
            CorePlugin.getDefault().jobKeepAlive = null;
            String logstr = "cancelKeepAlive:  Cancelling KeepAlive Job";
            System.out.println("ZosConnect - " + logstr);
        }
    }

    public void setConnectLocal() {
        this.cancelKeepAlive();
        CorePlugin.getDefault().getPreferenceStore().setValue("dataSource", "local");
        CorePlugin.getDefault().getPreferenceStore().setValue("coreConnected", false);
    }

    private void showMessage(String title, String message, String msgtype) {
        if (msgtype.equalsIgnoreCase("error")) {
            PlatformUI.getWorkbench().getDisplay();
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)message);
        } else if (msgtype.equalsIgnoreCase("warning")) {
            PlatformUI.getWorkbench().getDisplay();
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)message);
        } else {
            PlatformUI.getWorkbench().getDisplay();
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)message);
        }
    }

    public Integer getConnectRc() {
        return this.connectrc;
    }

    private void logMessage(char loglevel, String logstr) {
        System.out.println("ZosConnect - " + logstr);
        switch (loglevel) {
            case 'E': {
                CorePlugin.getDefault().log.error(logstr);
                break;
            }
            case 'I': {
                CorePlugin.getDefault().log.info(logstr);
                break;
            }
            case 'W': {
                CorePlugin.getDefault().log.warn(logstr);
                break;
            }
            default: {
                CorePlugin.getDefault().log.debug(logstr);
            }
        }
    }

    public String stripChar(String val, char stripchar) {
        String strippedval = "";
        if (val.indexOf(stripchar) < 0) {
            return val;
        }
        int i = 0;
        while (i < val.length()) {
            if (val.charAt(i) != stripchar) {
                strippedval = val.substring(i, val.length());
                break;
            }
            ++i;
        }
        if (strippedval.length() <= 0) {
            strippedval = val.substring(val.length() - 1);
        }
        return strippedval;
    }

    public String getAHostById(String connectionid) {
        for (String hostID : CorePlugin.getDefault().connectedHosts) {
            if (!hostID.equals(connectionid)) continue;
            return hostID;
        }
        return null;
    }

    public int loadModelsJob() {
        int connectrc = 0;
        Job job = new Job("Loading Models"){

            public IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Begin Loading Models", 100);
                monitor.subTask("Load System Properties Model");
                System.out.println("Load System Properties Model");
                CorePlugin.getDefault().getHostProperties(monitor);
                if (CorePlugin.getDefault().session.getReturnCode() != 0) {
                    return Status.CANCEL_STATUS;
                }
                monitor.worked(10);
                monitor.subTask("Load STC Model");
                System.out.println("Load STC Model");
                CorePlugin.getDefault().getStcModel(monitor);
                if (CorePlugin.getDefault().session.getReturnCode() != 0) {
                    return Status.CANCEL_STATUS;
                }
                monitor.worked(10);
                monitor.subTask("Load STC Properties Model");
                System.out.println("Load STC Properties Model");
                CorePlugin.getDefault().getStcProperties(monitor);
                if (CorePlugin.getDefault().session.getReturnCode() != 0) {
                    return Status.CANCEL_STATUS;
                }
                monitor.worked(10);
                monitor.subTask("Load Observations List Model");
                System.out.println("Load ObservationsList Model");
                CorePlugin.getDefault().getObservationsModel(monitor);
                if (CorePlugin.getDefault().session.getReturnCode() != 0) {
                    return Status.CANCEL_STATUS;
                }
                System.out.println("Load ObservationsList Model Complete");
                monitor.worked(10);
                return Status.OK_STATUS;
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    System.out.println("Job completed successfully");
                } else {
                    System.out.println("Job cancelled");
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (CorePlugin.getDefault().session.getReturnCode() == 0 & CorePlugin.getDefault().getPreferenceStore().getString("dataSource").compareToIgnoreCase("remote") >= 0 & CorePlugin.getDefault().session.keepAliveSecs > 0 & CorePlugin.getDefault().jobKeepAlive == null) {
                            ZosConnect.this.runKeepAlive();
                        } else if (CorePlugin.getDefault().session.getReturnCode() != 0) {
                            String errmsg = CorePlugin.getDefault().session.reason;
                            if (CorePlugin.getDefault().session.getDoCmdRespErrmsg() != null) {
                                errmsg = CorePlugin.getDefault().session.getDoCmdRespErrmsg();
                            }
                            ZosConnect.this.showMessage(Messages.getString("ZosConnect.MessageDialog.errorTitle.ZosConnection"), String.valueOf(Messages.getString("ZosConnect.MessageDialog.infoMessage.ConnectionFailed")) + "  " + errmsg, "error");
                            if (CorePlugin.getDefault().getPreferenceStore().getString("dataSource").compareToIgnoreCase("remote") >= 0 & CorePlugin.getDefault().session.getReturnCode() >= 1000) {
                                CorePlugin.getDefault().connectionextension.disconnectZosJob();
                            }
                        }
                        CorePlugin.getDefault().getPreferenceStore().setValue("stcRefresh", true);
                    }
                });
            }
        });
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.schedule();
        return connectrc;
    }
}

