/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core;

import com.banknet.core.connection.ConnectionExtension;
import com.banknet.core.connection.IConnectionExtension;
import com.banknet.core.connection.ZosConnect;
import com.banknet.core.data.HostProperties;
import com.banknet.core.data.ObservationsList;
import com.banknet.core.data.StcList;
import com.banknet.core.data.StcProperties;
import com.banknet.core.dialogs.spm.ISpmConstantsExtension;
import com.banknet.core.dialogs.spm.SpmConstantsExtension;
import com.banknet.core.internal.Constants;
import com.banknet.core.internal.IProductResources;
import com.banknet.core.internal.IVersionCompatibilityExtension;
import com.banknet.core.internal.ProductResources;
import com.banknet.core.internal.Utilities;
import com.banknet.core.internal.VersionCompatibilityExtension;
import com.banknet.core.internal.ZosSession;
import com.banknet.core.models.ObservationsModel;
import com.banknet.core.models.ReportsModel;
import com.banknet.core.models.StcModel;
import com.banknet.core.preferences.PreferencesConstants;
import com.banknet.core.preferences.ReportDownloadPreferenceInitializer;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.w3c.dom.Document;

public class CorePlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.banknet.core";
    private static CorePlugin plugin;
    private static final String CONNECTION_EXTENSION_POINT = "com.banknet.core.connectionextension";
    private static final String PRODUCT_RESOURCES_EXTENSION_POINT = "com.banknet.core.productresources";
    public static final String SPMCONSTANTS_EXTENSION_POINT = "com.banknet.core.spmconstantsextension";
    public static final String VERSION_EXTENSION_POINT = "com.banknet.core.versioncompatibilityextension";
    public IConnectionExtension connectionextension = new ConnectionExtension();
    public IProductResources productextension = new ProductResources();
    ISpmConstantsExtension spmconstantsext = null;
    public IVersionCompatibilityExtension versionextension = null;
    public PreferencesConstants pconstants = new PreferencesConstants();
    public Logger log;
    private String thisClassName = ((Object)((Object)this)).getClass().getName();
    public static final String P_SHOWSTCLIST = "showStcList";
    public static final String P_DATASOURCE = "dataSource";
    public static final String P_CPUPORT = "cpuPortPreference";
    public static final String P_HOSTADDRESS = "hostAddress";
    public static final String P_CREDENTIALUID = "credentialUid";
    public static final String P_CONNECTSTC = "connectStc";
    public static final String P_SORTSEQ = "sortSeq";
    public static final String P_CONFIRMDELETE = "confirmDelete";
    public static final String P_CODEPAGE = "codePage";
    public static final String P_SAVEZOSDATASPACE = "saveZosDataspace";
    public static final String P_AUTOUPDATES = "autoUpdates";
    public static final String P_LOGLEVEL = "logLevel";
    public static final String P_COLORMONOCHROME = "colorMonochrome";
    public static final String P_CORECONNECTED = "coreConnected";
    public static final String P_CONNECTIONPSW = "connectionPsw";
    public static final String P_FILTERJOBNAME = "filterJobname";
    public static final String P_FILTEROWNEDBY = "filterOwnedby";
    public static final String P_ACTIVELINK = "activeLink";
    public static final String P_FOCUSREPORT = "focusReport";
    public static final String P_FINDTEXT = "findText";
    public static final String P_VIEWNAME = "viewName";
    public static final String P_OBSREPORTS = "obsReports";
    public static final String P_REPORTSVIEWSEL = "reportsViewSel";
    public static final String P_STCVIEWSEL = "stcViewSel";
    public static final String P_EXPANDREPORT = "expandReport";
    public static final String P_INITDETAIL = "initDetail";
    public static final String P_SAVEREPORTPATH = "saveReportPath";
    public static final String P_HIDECONNECT = "hideConnect";
    public static final String P_STCREFRESH = "stcRefresh";
    public static final String P_DLGUI = "dlGui";
    public static final String P_CHECKFORUPDATES = "checkForUpdates";
    public static final String P_OBSLOADED = "obsLoaded";
    public static final String P_REPORTDETAIL = "reportDetail";
    public static final String P_SPMDATASETS = "spmDatasets";
    public static final String P_SPMSETTINGS = "spmSettings";
    public static final String P_SPMP01ARGS = "spmP01Args";
    public static final String P_REPORTOBS = "reportObs";
    public static final String P_EXCLUDEDRPTS = "excludedRpts";
    public static final String P_NEWCONFIRM = "newConfirm";
    public static final String P_NEWCANCEL = "newCancel";
    public static final String P_NEWWARNSUPPRESS = "newWarnSuppress";
    public static final String P_CICSTRANUCASE = "cicsTranUcase";
    public static final String P_STATUSLINEOPTS = "statusLineOpts";
    public static final String P_LAUNCHXML = "launchXml";
    public static final String P_LAUNCHPDF = "launchPdf";
    public static final String P_SENDEREMAIL = "senderEmail";
    public static final String P_SMTPADDRESS = "smtpAddress";
    public static final String P_SMTPPORT = "smtpPort";
    public static final String P_SMTPAUTH = "smtpAuth";
    public static final String P_SMTPACCOUNT = "smtpAccount";
    public static final String P_MAILREPORTFORMAT = "mailReportFormat";
    public static final String P_ATTACHSTICKYNOTES = "attachStickyNotes";
    public static final String P_REPORTSREFRESH = "reportsRefresh";
    public static final String P_CONFIRMNOTESDELETE = "confirmNotesDelete";
    public static final String P_COREDATAPATH = "coreDataPath";
    public static final String P_SSLCONNECTION = "sslConnection";
    public static final String P_SSLKEYSTORE = "sslKeystore";
    public static final String P_SSLKEYSTOREPASS = "sslKeystorePass";
    public static final String P_SSLPROTOCOL = "sslProtocol";
    public static final String P_SSLCIPHER = "sslCipher";
    public static final String P_ACTIVECONNECTIONID = "activeConnectionId";
    public static final String P_ACTIVESTC = "activeStc";
    public static final String P_WORKSPACELOCATIONS = "workspaceLocations";
    public static final String P_SHOWINACTIVESTCS = "showInactiveStcs";
    public static final String P_UNTRUSTEDHOSTWARNING = "untrustedHostWarning";
    public static final String P_OBSLISTDOUBLECLICK = "obsListDoubleClick";
    public static final String P_GLOBALRECEIVEBUFSIZE = "globalReceiveBufSize";
    public static final String P_CONNECTSYSTEM = "connectSystem";
    public static final String P_OBSLISTCOLUMNS = "obsListColumns";
    public static final String P_SAVETEMPLATEPATH = "saveTemplatePath";
    public StcModel stcmodel = null;
    public ObservationsModel observationsmodel = null;
    public StcProperties stcproperties = null;
    public HostProperties hostproperties = null;
    public ReportsModel reportsmodel = null;
    public Constants constants = new Constants();
    private ZosConnect zosconnect = new ZosConnect();
    private static SimpleDateFormat yyyymmddhhmm;
    private static DecimalFormat df;
    public Document reportsdoc;
    private int totalObservations = 0;
    public Utilities util = new Utilities();
    public ZosSession session;
    public Job jobKeepAlive;
    public int socket;
    public int firstTake;
    public List<ObservationsModel> observations;
    public List observationId;
    public List<ReportsModel> reports;
    public List reportId;
    public HashMap wasitems;
    public HashMap wlpitems;
    public String activeStc = "";
    public String activeSpxgname = "";
    public String activeSystemname = "";
    public String activeConnectionId = "";
    public Collection<String> connectedHosts = Collections.synchronizedList(new ArrayList());
    public String rptid = "";
    public String rptname = "";
    public String pvmldir = "";
    public ObservationsModel selobs = null;
    public String tsoid = "";
    public String connaddr = "";
    public String connport = "";
    public String formatted_GUI_version = "";
    public String formatted_GUI_fixpack = "";
    public String formatted_GUI_versionfixpack = "";
    public boolean guiDataLoaded = false;
    public Document connectionsxml;
    public String connectionsxmlpath = "";
    public String proppath = "";
    public Integer expWarnDays = 255;
    public URL logurl;
    public File logfile;
    public ISchedulingRule schedrule = null;
    private Date obsTimestamp = null;
    private String obsActiveSystemname = "";
    private String obsActiveStc = "";
    private String obsDataSource = "";
    public IProgressMonitor monitor;
    public List<ObservationsModel> selobservations;
    public boolean testmode = false;

    static {
        yyyymmddhhmm = new SimpleDateFormat("yyyyMMdd HHmm");
        df = new DecimalFormat("##,##0");
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        TrayDialog.setDialogHelpAvailable((boolean)true);
        new ProductResources();
        this.getProductResourcesExtension();
        this.getZosConnectionExtension();
        this.getVersionExtension();
        if (this.log == null) {
            this.configureLog4j2();
        }
        this.createRuleLockFile();
        String logstr = "***** " + Platform.getResourceString((Bundle)this.getBundle(), (String)"%Plugin.name") + " Started *****";
        System.out.println(logstr);
        this.log.info(logstr);
        this.loadReportOptionsXml();
        String[] args = Platform.getCommandLineArgs();
        int i = 0;
        while (i < args.length) {
            if (args[i].equalsIgnoreCase("-apaDoUpdates")) {
                this.getPreferenceStore().setValue(P_CHECKFORUPDATES, this.getPreferenceStore().getDefaultString(P_CHECKFORUPDATES));
            } else if (args[i].equalsIgnoreCase("-testmode")) {
                this.testmode = true;
            }
            ++i;
        }
        logstr = "Version : " + Platform.getResourceString((Bundle)this.getBundle(), (String)"%Plugin.version");
        System.out.println(logstr);
        this.log.info(logstr);
        logstr = "Locale :  " + Platform.getNL();
        System.out.println(logstr);
        this.log.info(logstr);
        this.formatVersion();
        this.setPluginPreferences();
        try {
            if (PlatformUI.isWorkbenchRunning()) {
                this.loadGuiData();
            }
        }
        catch (Exception exception) {}
    }

    public void configureLog4j2() {
        try {
            String logxml = "log4j2.xml";
            if (this.getPreferenceStore().getString(P_LOGLEVEL).equalsIgnoreCase("debug")) {
                logxml = "log4j2Debug.xml";
            }
            System.setProperty("apaworkspace_loc", Platform.getLocation().toPortableString());
            URL url = this.productextension.getLogUrl(logxml);
            URL fileUrl = FileLocator.toFileURL((URL)url);
            URI uri = new URI(fileUrl.getProtocol(), fileUrl.getUserInfo(), fileUrl.getHost(), fileUrl.getPort(), fileUrl.getPath(), fileUrl.getQuery(), fileUrl.getRef());
            LogManager.getContext(null, (boolean)false, (URI)uri);
            this.log = LogManager.getLogger(((Object)((Object)this)).getClass());
        }
        catch (Exception e) {
            this.logInfo(String.valueOf(this.thisClassName) + ":configureLogging " + " Exception");
            this.logException(e);
        }
    }

    private void formatVersion() {
        String[] temp_version = this.versionextension.getPluginVersion();
        if (this.testmode) {
            temp_version = Platform.getResourceString((Bundle)this.getBundle(), (String)"%Plugin.version").split("[.]");
        }
        String formatted_version = this.util.padString(temp_version[0], "0", 3);
        String formatted_release = this.util.padString(temp_version[1], "0", 3);
        String formatted_modlevel = this.util.padString(temp_version[2], "0", 3);
        this.formatted_GUI_version = String.valueOf(formatted_version) + formatted_release + formatted_modlevel;
        this.formatted_GUI_fixpack = temp_version.length > 3 ? "00" + this.util.padString(temp_version[3], "0", 3) : "00000";
        this.formatted_GUI_versionfixpack = String.valueOf(this.formatted_GUI_version) + "." + this.formatted_GUI_fixpack;
    }

    private void setPluginPreferences() {
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        preferenceStore.setDefault(P_CONFIRMDELETE, true);
        preferenceStore.setDefault(P_SORTSEQ, this.pconstants.SORTSEQ_DATETIME);
        if (preferenceStore.getString(P_SORTSEQ).length() <= 0) {
            preferenceStore.setValue(P_SORTSEQ, preferenceStore.getDefaultString(P_SORTSEQ));
        }
        preferenceStore.setDefault(P_EXPANDREPORT, "C");
        if (preferenceStore.getString(P_EXPANDREPORT).length() <= 0) {
            preferenceStore.setValue(P_EXPANDREPORT, preferenceStore.getDefaultString(P_EXPANDREPORT));
        }
        preferenceStore.setDefault(P_SHOWSTCLIST, false);
        preferenceStore.setDefault(P_HOSTADDRESS, "");
        preferenceStore.setDefault(P_CPUPORT, "");
        if (preferenceStore.getString(P_HOSTADDRESS).length() <= 0) {
            preferenceStore.setValue(P_HOSTADDRESS, preferenceStore.getDefaultString(P_HOSTADDRESS));
        }
        if (preferenceStore.getString(P_CPUPORT).length() <= 0) {
            preferenceStore.setValue(P_CPUPORT, preferenceStore.getDefaultString(P_CPUPORT));
        }
        preferenceStore.setDefault(P_CREDENTIALUID, "");
        preferenceStore.setDefault(P_CONNECTIONPSW, "");
        preferenceStore.setDefault(P_CONNECTSTC, "");
        preferenceStore.setDefault(P_HIDECONNECT, false);
        preferenceStore.setDefault(P_STCREFRESH, false);
        preferenceStore.setDefault(P_CODEPAGE, "IBM1047");
        if (preferenceStore.getString(P_CODEPAGE).length() <= 0) {
            preferenceStore.setValue(P_CODEPAGE, preferenceStore.getDefaultString(P_CODEPAGE));
        }
        preferenceStore.setDefault(P_SAVEZOSDATASPACE, false);
        preferenceStore.setDefault(P_AUTOUPDATES, true);
        preferenceStore.setDefault(P_COLORMONOCHROME, false);
        preferenceStore.setDefault(P_DLGUI, this.formatted_GUI_versionfixpack);
        if (preferenceStore.getString(P_DLGUI).length() <= 0) {
            preferenceStore.setValue(P_DLGUI, preferenceStore.getDefaultString(P_DLGUI));
        }
        preferenceStore.setValue(P_DATASOURCE, "remote");
        preferenceStore.setValue(P_CORECONNECTED, false);
        preferenceStore.setValue(P_FILTERJOBNAME, "*");
        preferenceStore.setValue(P_FILTEROWNEDBY, "*");
        preferenceStore.setValue(P_ACTIVELINK, "");
        preferenceStore.setValue(P_FOCUSREPORT, "");
        preferenceStore.setValue(P_FINDTEXT, "");
        preferenceStore.setValue(P_VIEWNAME, "");
        preferenceStore.setValue(P_OBSREPORTS, "");
        preferenceStore.setValue(P_REPORTSVIEWSEL, "");
        preferenceStore.setValue(P_STCVIEWSEL, "");
        preferenceStore.setValue(P_INITDETAIL, "");
        preferenceStore.setValue(P_SAVEREPORTPATH, "c:\\");
        preferenceStore.setValue(P_STCREFRESH, false);
        preferenceStore.setValue(P_REPORTDETAIL, "");
        preferenceStore.setValue(P_REPORTOBS, "");
        preferenceStore.setDefault(P_CHECKFORUPDATES, "");
        if (preferenceStore.getString(P_CHECKFORUPDATES).length() <= 0) {
            preferenceStore.setValue(P_CHECKFORUPDATES, preferenceStore.getDefaultString(P_CHECKFORUPDATES));
        }
        preferenceStore.setDefault(P_OBSLOADED, false);
        preferenceStore.setValue(P_OBSLOADED, false);
        preferenceStore.setDefault(P_LOGLEVEL, "info");
        if (preferenceStore.getString(P_LOGLEVEL).length() <= 0) {
            preferenceStore.setValue(P_LOGLEVEL, preferenceStore.getDefaultString(P_LOGLEVEL));
        }
        preferenceStore.setDefault(P_SPMSETTINGS, "P01NLIN1,P,F,4,2|P01SW01,P,C,1, |P01SW02,P,C,1, |P01SW03,P,C,1,/|P01SW04,P,C,1, |P01SW05,P,C,1, |P01SW06,P,C,1, ");
        if (preferenceStore.getString(P_SPMSETTINGS).length() <= 0) {
            preferenceStore.setValue(P_SPMSETTINGS, preferenceStore.getDefaultString(P_SPMSETTINGS));
        }
        preferenceStore.setDefault(P_SPMP01ARGS, "AdjLines=4,AllSource=N,AsmObj=Y,Header=Y,Percent=N,Pseudo=N");
        if (preferenceStore.getString(P_SPMP01ARGS).length() <= 0) {
            preferenceStore.setValue(P_SPMP01ARGS, preferenceStore.getDefaultString(P_SPMP01ARGS));
        }
        preferenceStore.setDefault(P_NEWCONFIRM, false);
        preferenceStore.setDefault(P_NEWCANCEL, true);
        preferenceStore.setDefault(P_NEWWARNSUPPRESS, false);
        preferenceStore.setDefault(P_CICSTRANUCASE, true);
        preferenceStore.setDefault(P_STATUSLINEOPTS, "credentialUid|true,hostAddress|false,cpuPort|false");
        if (preferenceStore.getString(P_STATUSLINEOPTS).length() <= 0) {
            preferenceStore.setValue(P_STATUSLINEOPTS, preferenceStore.getDefaultString(P_STATUSLINEOPTS));
        }
        preferenceStore.setDefault(P_LAUNCHXML, true);
        preferenceStore.setDefault(P_LAUNCHPDF, true);
        preferenceStore.setDefault(P_REPORTSREFRESH, false);
        preferenceStore.setDefault(P_CONFIRMNOTESDELETE, true);
        if (preferenceStore.getString(P_CONFIRMNOTESDELETE).length() <= 0) {
            preferenceStore.setValue(P_CONFIRMNOTESDELETE, preferenceStore.getDefaultBoolean(P_CONFIRMNOTESDELETE));
        }
        preferenceStore.setDefault(P_SSLCONNECTION, false);
        preferenceStore.setDefault(P_SSLKEYSTORE, "");
        preferenceStore.setDefault(P_SSLKEYSTOREPASS, "");
        preferenceStore.setDefault(P_SSLPROTOCOL, "");
        preferenceStore.setDefault(P_SSLCIPHER, "");
        preferenceStore.setDefault(P_ACTIVECONNECTIONID, "");
        preferenceStore.setDefault(P_ACTIVESTC, "");
        preferenceStore.setDefault(P_SHOWINACTIVESTCS, true);
        preferenceStore.setDefault(P_WORKSPACELOCATIONS, String.valueOf(new File(Platform.getLocation().toFile(), File.separator).getAbsolutePath()) + File.separator);
        preferenceStore.setDefault(P_COREDATAPATH, String.valueOf(new File(Platform.getLocation().toFile(), File.separator).getAbsolutePath()) + File.separator);
        preferenceStore.setDefault(P_UNTRUSTEDHOSTWARNING, true);
        preferenceStore.setDefault(P_OBSLISTDOUBLECLICK, false);
        preferenceStore.setDefault(P_GLOBALRECEIVEBUFSIZE, 75);
        preferenceStore.setDefault(P_CONNECTSYSTEM, "");
        preferenceStore.setDefault(P_SAVETEMPLATEPATH, System.getProperty("user.home"));
        if (preferenceStore.getString(P_SAVETEMPLATEPATH).length() <= 0) {
            preferenceStore.setValue(P_SAVETEMPLATEPATH, preferenceStore.getDefaultString(P_SAVETEMPLATEPATH));
        }
        preferenceStore.setDefault(P_OBSLISTCOLUMNS, this.constants.OBSLIST_COLUMNS);
        if (preferenceStore.getString(P_OBSLISTCOLUMNS).length() <= 0) {
            preferenceStore.setValue(P_OBSLISTCOLUMNS, preferenceStore.getDefaultString(P_OBSLISTCOLUMNS));
        }
    }

    private void loadReportOptionsXml() {
        this.reportsdoc = null;
        try {
            URL fileUrl = this.productextension.getReportXmlUrl();
            File in = new File(fileUrl.getFile());
            this.reportsdoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in);
        }
        catch (Exception ex) {
            System.out.println(String.valueOf(this.thisClassName) + ":loadReportOptionsXml " + " Exception: " + ex);
            this.logInfo(String.valueOf(this.thisClassName) + ":loadReportOptionsXml " + " Exception");
            this.logException(ex);
        }
    }

    public void stop(BundleContext context) throws Exception {
        String logstr;
        if (CorePlugin.getDefault().getPreferenceStore().getString(P_DATASOURCE).compareToIgnoreCase("remote") >= 0) {
            logstr = "stop:   Running SHUTDOWN";
            System.out.println(logstr);
            this.session.doCmdResp(this.constants.ZOSMESSAGE_SHUTDOWN, CorePlugin.getDefault().getPreferenceStore().getString(P_DATASOURCE));
        }
        try {
            this.session.endSession();
        }
        catch (Exception exception) {}
        logstr = "***** " + Platform.getResourceString((Bundle)this.getBundle(), (String)"%Plugin.name") + " Stopped *****";
        System.out.println(logstr);
        this.log.info(logstr);
        try {
            plugin = null;
            super.stop(context);
        }
        catch (Exception exception) {}
    }

    public static CorePlugin getDefault() {
        return plugin;
    }

    public static String getPluginId() {
        return CorePlugin.getDefault().getBundle().getSymbolicName();
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return CorePlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public StcModel getStcModel() {
        return this.stcmodel;
    }

    public StcModel getStcModel(IProgressMonitor monitor) {
        this.stcmodel = null;
        if (CorePlugin.getDefault().session != null) {
            this.stcmodel = this.createStcModel(monitor);
        }
        return this.stcmodel;
    }

    private StcModel createStcModel(IProgressMonitor monitor) {
        StcModel stcmodels = null;
        try {
            StcList stclist = new StcList();
            stcmodels = stclist.getStcList(monitor);
        }
        catch (Exception ex) {
            System.out.println("createStcModel, getStcList exception: " + ex);
        }
        return stcmodels;
    }

    public ObservationsModel getObservationsModel() {
        return this.observationsmodel;
    }

    public ObservationsModel getObservationsModel(IProgressMonitor monitor) {
        long secondsBetween = 10L;
        if (this.obsTimestamp != null) {
            Date obsCurrTimestamp = new Date();
            try {
                long dDiffe = obsCurrTimestamp.getTime();
                long dDiffs = this.obsTimestamp.getTime();
                secondsBetween = (dDiffe - dDiffs) / 1000L;
            }
            catch (Exception exception) {}
        }
        if (!(secondsBetween < 1L && this.obsActiveSystemname.equalsIgnoreCase(this.activeSystemname) && this.obsActiveStc.equalsIgnoreCase(this.activeStc) && this.obsDataSource.equalsIgnoreCase(this.getPreferenceStore().getString(P_DATASOURCE)))) {
            this.observationsmodel = null;
            this.selobservations = null;
            this.selobservations = new ArrayList<ObservationsModel>();
            this.totalObservations = 0;
            if (CorePlugin.getDefault().session != null && !(CorePlugin.getDefault().getPreferenceStore().getString(P_DATASOURCE).compareToIgnoreCase("local") == 0 & !CorePlugin.getDefault().session.chkFile("GETOBSLIST"))) {
                this.observationsmodel = this.createObservationsModel(monitor);
            }
        }
        return this.observationsmodel;
    }

    private ObservationsModel createObservationsModel(IProgressMonitor monitor) {
        this.wasitems = new HashMap();
        this.wlpitems = new HashMap();
        this.observations = Collections.synchronizedList(new ArrayList());
        this.observationId = new ArrayList();
        ObservationsModel obsmodels = null;
        try {
            ObservationsList obslist = new ObservationsList();
            obsmodels = obslist.getObservationsList(monitor);
            this.totalObservations = this.observationId.size() - 1;
        }
        catch (Exception ex) {
            System.out.println("createObservationsModel, getObservationsList exception: " + ex);
        }
        return obsmodels;
    }

    public HostProperties getHostProperties() {
        return this.hostproperties;
    }

    public HostProperties getHostProperties(IProgressMonitor monitor) {
        try {
            this.hostproperties = null;
            if (this.session != null) {
                this.hostproperties = new HostProperties();
                this.hostproperties.getHostProperties(monitor);
            }
        }
        catch (Exception ex) {
            System.out.println("CorePlugin - getHostProperties exception: " + ex);
            this.log.error("getHostProperties exception: " + ex);
        }
        return this.hostproperties;
    }

    public StcProperties getStcProperties() {
        return this.stcproperties;
    }

    public StcProperties getStcProperties(IProgressMonitor monitor) {
        try {
            this.stcproperties = null;
            if (CorePlugin.getDefault().session != null) {
                this.stcproperties = new StcProperties();
                this.stcproperties.getStcProperties(monitor);
            }
        }
        catch (Exception ex) {
            System.out.println("CorePlugin - getStcProperties exception: " + ex);
            this.log.error("getStcProperties exception: " + ex);
        }
        return this.stcproperties;
    }

    public ReportsModel getReportsModel() {
        return this.reportsmodel;
    }

    public void setReportsModel(ReportsModel reportsmodel) {
        this.reportsmodel = null;
        this.reportsmodel = reportsmodel;
    }

    public String getTotalObservations() {
        return df.format(this.totalObservations);
    }

    public void logException(Exception e) {
        String msg = e.getMessage() == null ? e.toString() : e.getMessage();
        this.getLog().log((IStatus)new Status(4, PLUGIN_ID, 0, msg, (Throwable)e));
    }

    public void logInfo(String msg) {
        this.getLog().log((IStatus)new Status(1, PLUGIN_ID, 0, msg, null));
    }

    public void loadGuiData() {
        System.gc();
        System.runFinalization();
        this.getPreferenceStore().setValue(P_DATASOURCE, "local");
        try {
            this.updatePrefs();
        }
        catch (Exception exception) {}
        this.doConnect();
        this.guiDataLoaded = true;
    }

    private void setPrefs() {
        ReportDownloadPreferenceInitializer downloadinit = new ReportDownloadPreferenceInitializer();
        String[] optionprefs = downloadinit.getPreferenceDefaults(this.reportsdoc);
        int i = 0;
        while (i < optionprefs.length) {
            String[] optionpref = optionprefs[i].split(":");
            this.getPreferenceStore().setValue(optionpref[0], optionpref[1]);
            ++i;
        }
        downloadinit = null;
    }

    private void updatePrefs() {
        String versionbuild = String.valueOf(this.formatted_GUI_version) + this.formatted_GUI_fixpack;
        String logstr = "preStartup:  Check for Updates";
        System.out.println("CorePlugin - " + logstr);
        this.log.info(logstr);
        ReportDownloadPreferenceInitializer rptinit = new ReportDownloadPreferenceInitializer();
        rptinit.checkNewReport(this.reportsdoc);
        this.getPreferenceStore().setValue(P_CHECKFORUPDATES, versionbuild);
    }

    private void doConnect() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                CorePlugin.this.zosconnect.connectZos();
            }
        });
    }

    private void getProductResourcesExtension() {
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(PRODUCT_RESOURCES_EXTENSION_POINT);
        try {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                System.out.println("Evaluating Product Resources extension");
                Object o = e.createExecutableExtension("class");
                if (o instanceof IProductResources) {
                    this.productextension = (IProductResources)o;
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            System.out.println(ex.getMessage());
        }
    }

    public void getZosConnectionExtension() {
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(CONNECTION_EXTENSION_POINT);
        try {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                Object o = e.createExecutableExtension("class");
                if (o instanceof IConnectionExtension) {
                    this.connectionextension = (IConnectionExtension)o;
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            System.out.println(ex.getMessage());
        }
    }

    public ISpmConstantsExtension getSpmConstantsExtension() {
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(SPMCONSTANTS_EXTENSION_POINT);
        if (this.spmconstantsext != null) {
            return this.spmconstantsext;
        }
        try {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                Object o = e.createExecutableExtension("class");
                if (o instanceof ISpmConstantsExtension) {
                    this.spmconstantsext = (ISpmConstantsExtension)o;
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            System.out.println(ex.getMessage());
        }
        if (this.spmconstantsext == null) {
            this.spmconstantsext = new SpmConstantsExtension();
        }
        return this.spmconstantsext;
    }

    public IVersionCompatibilityExtension getVersionExtension() {
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(VERSION_EXTENSION_POINT);
        if (this.versionextension != null) {
            return this.versionextension;
        }
        try {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                Object o = e.createExecutableExtension("class");
                if (o instanceof IVersionCompatibilityExtension) {
                    this.versionextension = (IVersionCompatibilityExtension)o;
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            System.out.println(ex.getMessage());
        }
        if (this.versionextension == null) {
            this.versionextension = new VersionCompatibilityExtension();
        }
        return this.versionextension;
    }

    private ISchedulingRule createRuleLockFile() {
        try {
            Path path = new Path(String.valueOf(CorePlugin.getDefault().getBundle().getLocation()) + File.separator + "banknetcoreplugin.lock");
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
            if (this.schedrule == null) {
                this.schedrule = ruleFactory.createRule((IResource)file);
            }
        }
        catch (Exception ex) {
            System.out.println("CorePlugin - createRuleLockFile exception: " + ex);
            this.log.error("createRuleLockFile exception: " + ex);
        }
        return this.schedrule;
    }
}

