/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java.model;

import com.ibm.rsaz.analysis.core.element.AbstractAnalysisElement;
import com.ibm.rsaz.analysis.core.history.AnalysisHistory;
import com.ibm.rsaz.analysis.core.history.AnalysisHistoryFactory;
import com.ibm.rsaz.analysis.core.result.AbstractAnalysisResult;
import com.ibm.xtools.analysis.metrics.java.ClassMetricsResult;
import com.ibm.xtools.analysis.metrics.java.MethodMetricsResult;
import com.ibm.xtools.analysis.metrics.java.MetricsResult;
import com.ibm.xtools.analysis.metrics.java.MetricsRule;
import com.ibm.xtools.analysis.metrics.java.PackageMetricsResult;
import com.ibm.xtools.analysis.metrics.java.data.ContainerData;
import com.ibm.xtools.analysis.metrics.java.model.BaseElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public abstract class AbstractContainerElement
extends BaseElement {
    private List<BaseElement> ownedElements = null;
    static Map<AnalysisHistory, Map<MetricsRule, ResultsByType>> cache = new WeakHashMap<AnalysisHistory, Map<MetricsRule, ResultsByType>>(0);

    public AbstractContainerElement(MetricsResult result) {
        super(result);
    }

    @Override
    public List<BaseElement> getOwnedElements() {
        this.internalPopulateChildren();
        if (this.ownedElements == null) {
            return Collections.emptyList();
        }
        return this.ownedElements;
    }

    private void internalPopulateChildren() {
        if (this.ownedElements == null) {
            this.populateChildren();
        }
    }

    protected void setOwnedElements(List<BaseElement> ownedElementsValue) {
        this.ownedElements = ownedElementsValue;
    }

    protected Collection<PackageMetricsResult> getPackageMetricsResults() {
        ResultsByType resultsByType = this.getResultsByType();
        if (resultsByType == null) {
            return Collections.emptyList();
        }
        return resultsByType.getPackageResults();
    }

    protected Collection<ClassMetricsResult> getClassMetricsResults(PackageMetricsResult packageResult) {
        ResultsByType resultsByType = this.getResultsByType();
        if (resultsByType == null) {
            return Collections.emptyList();
        }
        return resultsByType.getClassResults(packageResult);
    }

    protected Collection<MethodMetricsResult> getMethodMetricsResults(PackageMetricsResult packageResult, ClassMetricsResult classresult) {
        ResultsByType resultsByType = this.getResultsByType();
        if (resultsByType == null) {
            return Collections.emptyList();
        }
        return resultsByType.getMethodResults(packageResult, classresult);
    }

    private ResultsByType getResultsByType() {
        MetricsResult result = this.getResult();
        MetricsRule rule = (MetricsRule)result.getOwner();
        AnalysisHistory history = AnalysisHistoryFactory.instance().getHistory(result.getHistoryId());
        Map<MetricsRule, ResultsByType> ruleResults = cache.get(history);
        ruleResults = this.getRersultsByType(rule, history, ruleResults);
        return ruleResults.get((Object)rule);
    }

    private Map<MetricsRule, ResultsByType> getRersultsByType(MetricsRule rule, AnalysisHistory history, Map<MetricsRule, ResultsByType> ruleResults) {
        ResultsByType resultsByType;
        if (ruleResults == null) {
            ruleResults = new IdentityHashMap<MetricsRule, ResultsByType>(1);
            cache.put(history, ruleResults);
        }
        if ((resultsByType = ruleResults.get((Object)rule)) == null) {
            ArrayList results = new ArrayList(history.getResults((AbstractAnalysisElement)rule));
            Collections.sort(results, new ResultComparator());
            resultsByType = new ResultsByType();
            WeakHashMap<ContainerData, AbstractAnalysisResult> dataToResultMap = new WeakHashMap<ContainerData, AbstractAnalysisResult>(1);
            for (AbstractAnalysisResult abstractAnalysisResult : results) {
                int type = abstractAnalysisResult.getElementType();
                PackageMetricsResult packageResult = null;
                ClassMetricsResult classResult = null;
                switch (type) {
                    case 1001: {
                        packageResult = (PackageMetricsResult)abstractAnalysisResult;
                        dataToResultMap.put(packageResult.getPackageData(), abstractAnalysisResult);
                        resultsByType.addPackageResult((PackageMetricsResult)abstractAnalysisResult);
                        break;
                    }
                    case 1002: {
                        classResult = (ClassMetricsResult)abstractAnalysisResult;
                        packageResult = (PackageMetricsResult)((Object)dataToResultMap.get(classResult.getPackageData()));
                        dataToResultMap.put(classResult.getClassData(), abstractAnalysisResult);
                        resultsByType.addClassResult(packageResult, classResult);
                        break;
                    }
                    case 1003: {
                        MethodMetricsResult methodResult = (MethodMetricsResult)abstractAnalysisResult;
                        classResult = (ClassMetricsResult)((Object)dataToResultMap.get(methodResult.getClassData()));
                        packageResult = (PackageMetricsResult)((Object)dataToResultMap.get(classResult.getPackageData()));
                        resultsByType.addMethodResult(packageResult, classResult, methodResult);
                    }
                }
            }
            ruleResults.put(rule, resultsByType);
        }
        return ruleResults;
    }

    protected abstract void populateChildren();

    private class ResultComparator
    implements Comparator<AbstractAnalysisResult> {
        private ResultComparator() {
        }

        @Override
        public int compare(AbstractAnalysisResult o1, AbstractAnalysisResult o2) {
            int type1 = o1.getElementType();
            int type2 = o2.getElementType();
            if (type1 == 1003) {
                if (type2 == 1003) {
                    return 0;
                }
                return 1;
            }
            if (type1 == 1002) {
                if (type2 == 1003) {
                    return -1;
                }
                if (type2 == 1002) {
                    return 0;
                }
                return 1;
            }
            if (type1 == 1001) {
                if (type2 == 1000) {
                    return 1;
                }
                if (type2 == 1001) {
                    return 0;
                }
                return -1;
            }
            if (type1 == 1000) {
                if (type2 == 1000) {
                    return 0;
                }
                return -1;
            }
            return 0;
        }
    }

    private static final class ResultsByType {
        Map<PackageMetricsResult, Map<ClassMetricsResult, List<MethodMetricsResult>>> packageResults = null;

        private ResultsByType() {
        }

        private void addPackageResult(PackageMetricsResult result) {
            if (this.packageResults == null) {
                this.packageResults = new IdentityHashMap<PackageMetricsResult, Map<ClassMetricsResult, List<MethodMetricsResult>>>(1);
            }
            this.packageResults.put(result, Collections.emptyMap());
        }

        private void addClassResult(PackageMetricsResult packageResult, ClassMetricsResult result) {
            Map<ClassMetricsResult, List<MethodMetricsResult>> classResults = this.packageResults.get((Object)packageResult);
            if (classResults == Collections.EMPTY_MAP) {
                classResults = new IdentityHashMap<ClassMetricsResult, List<MethodMetricsResult>>(1);
                this.packageResults.put(packageResult, classResults);
            }
            classResults.put(result, Collections.emptyList());
        }

        private void addMethodResult(PackageMetricsResult packageResult, ClassMetricsResult classresult, MethodMetricsResult result) {
            Map<ClassMetricsResult, List<MethodMetricsResult>> classResults = this.packageResults.get((Object)packageResult);
            List<MethodMetricsResult> methodResults = classResults.get((Object)classresult);
            if (methodResults == Collections.EMPTY_LIST) {
                methodResults = new ArrayList<MethodMetricsResult>(1);
                classResults.put(classresult, methodResults);
            }
            methodResults.add(result);
        }

        public Collection<PackageMetricsResult> getPackageResults() {
            if (this.packageResults == null) {
                return Collections.emptyList();
            }
            return this.packageResults.keySet();
        }

        public Collection<ClassMetricsResult> getClassResults(PackageMetricsResult packageResult) {
            Map<ClassMetricsResult, List<MethodMetricsResult>> classResults = this.packageResults.get((Object)packageResult);
            if (classResults == null) {
                return Collections.emptyList();
            }
            return classResults.keySet();
        }

        public Collection<MethodMetricsResult> getMethodResults(PackageMetricsResult packageResult, ClassMetricsResult classresult) {
            List<MethodMetricsResult> methodResults = null;
            Map<ClassMetricsResult, List<MethodMetricsResult>> classResults = this.packageResults.get((Object)packageResult);
            if (classResults != null) {
                methodResults = classResults.get((Object)classresult);
            }
            if (methodResults == null) {
                return Collections.emptyList();
            }
            return methodResults;
        }
    }
}

