/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java.internal.util;

import com.ibm.rsaz.analysis.core.logging.Log;
import com.ibm.xtools.analysis.metrics.java.MetricsResource;
import com.ibm.xtools.analysis.metrics.java.data.util.LineInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import org.eclipse.jdt.core.dom.ASTNode;

public final class MetricUtils {
    private static final String COMMENT_INLINE = "//";
    private static final String COMMENT_BLOCK_START = "/*";
    private static final String COMMENT_BLOCK_END = "*/";

    private MetricUtils() {
    }

    public static String getASTNodeAsString(MetricsResource resource, ASTNode node) {
        String source = resource.getSourceCode();
        if (node == null || source == null) {
            return source;
        }
        int start = node.getStartPosition();
        int end = start + node.getLength();
        return source.substring(start, end);
    }

    public static LineInfo getLineInfo(MetricsResource resource, ASTNode node) {
        LineInfo info = new LineInfo();
        String value = MetricUtils.getASTNodeAsString(resource, node);
        if (value != null) {
            boolean inBlockComment = false;
            boolean inMultiComment = false;
            StringReader stringReader = null;
            BufferedReader sr = null;
            try {
                try {
                    stringReader = new StringReader(value);
                    sr = new BufferedReader(stringReader);
                    String token = sr.readLine();
                    while (token != null) {
                        token = token.trim();
                        boolean commentBlockStart = token.startsWith(COMMENT_BLOCK_START);
                        boolean commentInline = token.startsWith(COMMENT_INLINE);
                        if (token.length() > 0) {
                            if (!inBlockComment) {
                                if (commentInline) {
                                    if (!inMultiComment) {
                                        info.addLineComments(1);
                                        info.addTotalComments(1);
                                        inMultiComment = true;
                                    }
                                } else if (inMultiComment) {
                                    inMultiComment = false;
                                }
                                if (token.indexOf(COMMENT_INLINE) > 0) {
                                    info.addEndOfLineComments(1);
                                    info.addTotalComments(1);
                                }
                            }
                            if (!inBlockComment && commentBlockStart) {
                                inBlockComment = true;
                            }
                            if (!(inBlockComment || commentBlockStart || commentInline)) {
                                info.addLinesWithCode(1);
                            }
                            if (inBlockComment && token.endsWith(COMMENT_BLOCK_END)) {
                                inBlockComment = false;
                                info.addTotalComments(1);
                            }
                        } else {
                            info.addEmptyLines(1);
                        }
                        info.addTotalLines(1);
                        token = sr.readLine();
                    }
                    sr.close();
                    stringReader.close();
                }
                catch (IOException e) {
                    Log.severe((String)"Error reading source", (Throwable)e);
                    try {
                        if (sr != null) {
                            sr.close();
                        }
                    }
                    catch (Exception e2) {
                        Log.severe((String)"Unable to close a buffered reader", (Throwable)e2);
                    }
                    try {
                        if (stringReader != null) {
                            stringReader.close();
                        }
                    }
                    catch (Exception e3) {
                        Log.severe((String)"Unable to close a stringReader", (Throwable)e3);
                    }
                }
            }
            finally {
                try {
                    if (sr != null) {
                        sr.close();
                    }
                }
                catch (Exception e) {
                    Log.severe((String)"Unable to close a buffered reader", (Throwable)e);
                }
                try {
                    if (stringReader != null) {
                        stringReader.close();
                    }
                }
                catch (Exception e) {
                    Log.severe((String)"Unable to close a stringReader", (Throwable)e);
                }
            }
        }
        return info;
    }
}

