/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java.internal.util;

import com.ibm.rsaz.analysis.core.logging.Log;
import com.ibm.rsaz.analysis.core.result.ResourceAnalysisResult;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class MarkerPool {
    static Map<MarkerWrapper, MarkerWrapper> newMarkersMap = new HashMap<MarkerWrapper, MarkerWrapper>();
    private static final String INVALID_MARKER = "Invalid marker";
    static Map<MarkerInfoLocation, MarkerInfoLocation> markerInfo = new HashMap<MarkerInfoLocation, MarkerInfoLocation>(10);

    public static IMarker createMarker(IResource resource, String type, int start, int length) {
        MarkerWrapper tempWrapper = new MarkerWrapper(null, resource, type, start, length);
        MarkerWrapper markerWrapper = newMarkersMap.get(tempWrapper);
        IMarker marker = null;
        if (markerWrapper == null) {
            try {
                markerWrapper = new MarkerWrapper(resource.createMarker(type), resource, type, start, length);
                MarkerPool.updateMarkerAttributes(start, length, markerWrapper.getMarker());
                newMarkersMap.put(markerWrapper, markerWrapper);
            }
            catch (CoreException e) {
                Log.severe((String)INVALID_MARKER, (Throwable)e);
            }
        } else {
            markerWrapper.increaseRefCount();
        }
        if (markerWrapper != null) {
            marker = markerWrapper.getMarker();
        }
        return marker;
    }

    public static ResourceAnalysisResult.MarkerInfo createMarkerInfo(int nodeStart, int nodeLength) {
        MarkerInfoLocation location = new MarkerInfoLocation(nodeStart, nodeLength);
        MarkerInfoLocation info = markerInfo.get(location);
        if (info == null) {
            info = new MarkerInfoLocation(nodeStart, nodeLength);
            info.setMarkerInfo(new ResourceAnalysisResult.MarkerInfo(nodeStart, nodeLength));
            markerInfo.put(info, info);
        }
        info.increaseRefCOunt();
        return info.getMarkerInfo();
    }

    public static void releaseMarkerInfo(int nodeStart, int nodeLength) {
        MarkerInfoLocation location = new MarkerInfoLocation(nodeStart, nodeLength);
        MarkerInfoLocation info = markerInfo.get(location);
        if (info != null) {
            info.decreaseRefCOunt();
            if (info.getRefCOunt() == 0) {
                markerInfo.remove(location);
            }
        }
    }

    private static void updateMarkerAttributes(int start, int length, IMarker marker) {
        HashMap<String, Integer> attributes = new HashMap<String, Integer>(2);
        attributes.put("charStart", start);
        attributes.put("charEnd", start + length);
        try {
            marker.setAttributes(attributes);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static void releaseMarker(IMarker marker) {
        String type;
        int start = 0;
        int end = 0;
        try {
            start = (Integer)marker.getAttribute("charStart");
            end = (Integer)marker.getAttribute("charEnd");
            type = marker.getType();
        }
        catch (CoreException coreException) {
            return;
        }
        int length = end - start;
        MarkerWrapper tempWrapper = new MarkerWrapper(marker, marker.getResource(), type, start, length);
        MarkerWrapper markerWrapper = newMarkersMap.get(tempWrapper);
        if (markerWrapper != null) {
            markerWrapper.release();
        }
    }

    private static final class MarkerInfoLocation {
        private int start;
        private int length;
        private int refCount = 0;
        private ResourceAnalysisResult.MarkerInfo markerInfo1 = null;

        public MarkerInfoLocation(int startValue, int lengthValue) {
            this.start = startValue;
            this.length = lengthValue;
        }

        public void setMarkerInfo(ResourceAnalysisResult.MarkerInfo info) {
            this.markerInfo1 = info;
        }

        public ResourceAnalysisResult.MarkerInfo getMarkerInfo() {
            return this.markerInfo1;
        }

        public void increaseRefCOunt() {
            ++this.refCount;
        }

        public void decreaseRefCOunt() {
            --this.refCount;
        }

        public int getRefCOunt() {
            return this.refCount;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof MarkerInfoLocation) {
                MarkerInfoLocation info = (MarkerInfoLocation)obj;
                return info.getStart() == this.start && info.getLength() == this.length;
            }
            return false;
        }

        public int hashCode() {
            return this.start + this.length * 17;
        }

        public int getStart() {
            return this.start;
        }

        public int getLength() {
            return this.length;
        }
    }

    private static class MarkerWrapper {
        IMarker marker = null;
        Integer start = null;
        Integer length = null;
        String type = null;
        IResource resource = null;
        int refCount = 0;

        public int getStart() {
            return this.start;
        }

        public int getLength() {
            return this.length;
        }

        public void increaseRefCount() {
            ++this.refCount;
        }

        public void release() {
            --this.refCount;
            if (this.refCount == 0) {
                newMarkersMap.remove(this);
                try {
                    this.marker.delete();
                }
                catch (CoreException coreException) {}
            }
        }

        public MarkerWrapper(IMarker markerValue, IResource resourceValue, String typeValue, int startValue, int lengthValue) {
            this.marker = markerValue;
            this.start = startValue;
            this.length = lengthValue;
            this.resource = resourceValue;
            this.type = typeValue;
            this.increaseRefCount();
        }

        public IMarker getMarker() {
            return this.marker;
        }

        public boolean equals(Object obj) {
            boolean bRetVal = false;
            if (this == obj) {
                bRetVal = true;
            } else if (obj instanceof MarkerWrapper) {
                MarkerWrapper wraper = (MarkerWrapper)obj;
                bRetVal = wraper.getResource().equals((Object)this.getResource()) && wraper.getType().equals(this.getType()) && wraper.getStart() == this.getStart() && wraper.getLength() == this.getLength();
            }
            return bRetVal;
        }

        private String getType() {
            return this.type;
        }

        private IResource getResource() {
            return this.resource;
        }

        public int hashCode() {
            int markerResourceHashCode = this.getResource().hashCode();
            int startHashCode = this.start.hashCode();
            int lengthHashCode = this.start.hashCode();
            int typeHashCode = this.getType().hashCode();
            return markerResourceHashCode + 17 * typeHashCode + 289 * startHashCode + 4913 * lengthHashCode;
        }
    }
}

