/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java.internal.rules.inheritance;

import com.ibm.xtools.analysis.metrics.java.MetricsRule;
import com.ibm.xtools.analysis.metrics.java.data.ClassData;
import com.ibm.xtools.analysis.metrics.java.data.ElementData;
import com.ibm.xtools.analysis.metrics.java.data.PackageData;
import com.ibm.xtools.analysis.metrics.java.data.ProjectData;
import com.ibm.xtools.analysis.metrics.java.data.util.ClassInfo;
import com.ibm.xtools.analysis.metrics.java.internal.util.NumberUtilities;

public class DepthOfInheritance
extends MetricsRule {
    private static final String PARAM1 = "PACKAGE_MAXIMUM";
    private static final String PARAM2 = "CLASS_MAXIMUM";

    @Override
    public void analyzeProject() {
        super.analyzeProject();
        ProjectData projectData = this.getManager().getProjectData();
        ClassInfo ci = projectData.getClassInfo();
        double depth = ci.getInheritanceDepth();
        this.generateResultsForASTNode(null, "0", projectData, depth /= (double)(ci.getTotalClassCount() + ci.getTotalInterfaceCount()));
    }

    @Override
    protected void analyzePackage(ProjectData projectData, PackageData packageData) {
        super.analyzePackage(projectData, packageData);
        int packageMaximum = NumberUtilities.convertStringToInt(this, PARAM1);
        ClassInfo ci = packageData.getClassInfo();
        double depth = ci.getInheritanceDepth();
        this.generateResultsForASTNode(null, this.getMaximumSeverity(Math.round(depth /= (double)(ci.getTotalClassCount() + ci.getTotalInterfaceCount())), (double)packageMaximum), projectData, packageData, depth);
    }

    @Override
    protected void analyzeClass(ProjectData projectData, PackageData packageData, ClassData classData) {
        super.analyzeClass(projectData, packageData, classData);
        int classMaximum = NumberUtilities.convertStringToInt(this, PARAM2);
        int depth = classData.getClassInfo().getInheritanceDepth();
        this.generateResultsForASTNode(classData.getResource(), this.getMaximumSeverity(depth, classMaximum), projectData, packageData, classData, depth);
    }

    @Override
    public void setElementDataValue(ElementData data, double value) {
    }
}

