/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java.internal.rules.halstead;

import com.ibm.xtools.analysis.metrics.java.MetricsRule;
import com.ibm.xtools.analysis.metrics.java.data.ClassData;
import com.ibm.xtools.analysis.metrics.java.data.ElementData;
import com.ibm.xtools.analysis.metrics.java.data.MethodData;
import com.ibm.xtools.analysis.metrics.java.data.PackageData;
import com.ibm.xtools.analysis.metrics.java.data.ProjectData;
import com.ibm.xtools.analysis.metrics.java.data.util.HalsteadInfo;
import com.ibm.xtools.analysis.metrics.java.internal.util.NumberUtilities;
import org.eclipse.core.resources.IResource;

public class UniqueNumberOfOperators
extends MetricsRule {
    private static final String PARAM1 = "METHOD_MAXIMUM";
    private static final String PARAM2 = "CLASS_MAXIMUM";
    private static final String PARAM3 = "PACKAGE_MAXIMUM";

    @Override
    public void analyzeProject() {
        super.analyzeProject();
        ProjectData projectData = this.getManager().getProjectData();
        HalsteadInfo li = projectData.getHalsteadInfo();
        this.generateResultsForASTNode((IResource)null, "0", projectData, li.getUniqueOperatorCount());
    }

    @Override
    protected void analyzePackage(ProjectData projectData, PackageData packageData) {
        super.analyzePackage(projectData, packageData);
        int packageMaximum = NumberUtilities.convertStringToInt(this, PARAM3);
        HalsteadInfo pli = packageData.getHalsteadInfo();
        int count = pli.getUniqueOperatorCount();
        this.generateResultsForASTNode((IResource)null, this.getMaximumSeverity(count, packageMaximum), projectData, packageData, count);
    }

    @Override
    protected void analyzeClass(ProjectData projectData, PackageData packageData, ClassData classData) {
        super.analyzeClass(projectData, packageData, classData);
        int classMaximum = NumberUtilities.convertStringToInt(this, PARAM2);
        HalsteadInfo cli = classData.getHalsteadInfo();
        int count = cli.getUniqueOperatorCount();
        this.generateResultsForASTNode(classData.getResource(), this.getMaximumSeverity(count, classMaximum), projectData, packageData, classData, count);
    }

    @Override
    protected void analyzeMethod(ProjectData projectData, PackageData packageData, ClassData classData, MethodData methodData) {
        int methodMaximum = NumberUtilities.convertStringToInt(this, PARAM1);
        HalsteadInfo mli = methodData.getHalsteadInfo();
        int count = mli.getUniqueOperatorCount();
        this.generateResultsForASTNode(classData.getResource(), this.getMaximumSeverity(count, methodMaximum), projectData, packageData, classData, methodData, count, methodData.getNodeStart(), methodData.getNodeLength());
    }

    @Override
    public void setElementDataValue(ElementData data, double value) {
        data.getHalsteadInfo().setUniqueOperatorCount((int)Math.round(value));
    }
}

