/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java.internal.rules.halstead;

import com.ibm.xtools.analysis.metrics.java.MetricsRule;
import com.ibm.xtools.analysis.metrics.java.data.ClassData;
import com.ibm.xtools.analysis.metrics.java.data.ElementData;
import com.ibm.xtools.analysis.metrics.java.data.MethodData;
import com.ibm.xtools.analysis.metrics.java.data.PackageData;
import com.ibm.xtools.analysis.metrics.java.data.ProjectData;
import com.ibm.xtools.analysis.metrics.java.data.util.HalsteadInfo;
import com.ibm.xtools.analysis.metrics.java.internal.util.NumberUtilities;

public class ProgramVolume
extends MetricsRule {
    private static final String PARAM1 = "METHOD_MAXIMUM";
    private static final String PARAM2 = "CLASS_MAXIMUM";
    private static final String PARAM3 = "PACKAGE_MAXIMUM";
    private static final String PARAM4 = "METHOD_MINIMUM";
    private static final String PARAM5 = "CLASS_MINIMUM";
    private static final String PARAM6 = "PACKAGE_MINIMUM";

    @Override
    public void analyzeProject() {
        super.analyzeProject();
        ProjectData projectData = this.getManager().getProjectData();
        HalsteadInfo li = projectData.getHalsteadInfo();
        this.generateResultsForASTNode(null, "0", projectData, li.getProgramVolume());
    }

    @Override
    protected void analyzePackage(ProjectData projectData, PackageData packageData) {
        super.analyzePackage(projectData, packageData);
        double packageMaximum = NumberUtilities.convertStringToDouble(this, PARAM3);
        double packageMinimum = NumberUtilities.convertStringToDouble(this, PARAM6);
        HalsteadInfo pli = packageData.getHalsteadInfo();
        this.generateResultsForASTNode(null, this.getMinMaxSeverity(pli.getProgramVolume(), packageMinimum, packageMaximum), projectData, packageData, pli.getProgramVolume());
    }

    @Override
    protected void analyzeClass(ProjectData projectData, PackageData packageData, ClassData classData) {
        super.analyzeClass(projectData, packageData, classData);
        double classMaximum = NumberUtilities.convertStringToDouble(this, PARAM2);
        double classMinimum = NumberUtilities.convertStringToDouble(this, PARAM5);
        HalsteadInfo cli = classData.getHalsteadInfo();
        double volume = cli.getProgramVolume();
        this.generateResultsForASTNode(classData.getResource(), this.getMinMaxSeverity(volume, classMinimum, classMaximum), projectData, packageData, classData, volume);
    }

    @Override
    protected void analyzeMethod(ProjectData projectData, PackageData packageData, ClassData classData, MethodData methodData) {
        double methodMaximum = NumberUtilities.convertStringToDouble(this, PARAM1);
        double methodMinimum = NumberUtilities.convertStringToDouble(this, PARAM4);
        HalsteadInfo mli = methodData.getHalsteadInfo();
        double volume = mli.getProgramVolume();
        this.generateResultsForASTNode(classData.getResource(), this.getMinMaxSeverity(volume, methodMinimum, methodMaximum), projectData, packageData, classData, methodData, volume, methodData.getNodeStart(), methodData.getNodeLength());
    }

    @Override
    public void setElementDataValue(ElementData data, double value) {
        data.getHalsteadInfo().setProgramVolume(value);
    }
}

