/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java.internal.rules.halstead;

import com.ibm.xtools.analysis.metrics.java.MetricsRule;
import com.ibm.xtools.analysis.metrics.java.data.ClassData;
import com.ibm.xtools.analysis.metrics.java.data.ElementData;
import com.ibm.xtools.analysis.metrics.java.data.MethodData;
import com.ibm.xtools.analysis.metrics.java.data.PackageData;
import com.ibm.xtools.analysis.metrics.java.data.ProjectData;
import com.ibm.xtools.analysis.metrics.java.data.util.HalsteadInfo;
import com.ibm.xtools.analysis.metrics.java.internal.util.NumberUtilities;
import org.eclipse.core.resources.IResource;

public class ProgramVocabulary
extends MetricsRule {
    private static final String PARAM1 = "METHOD_MAXIMUM";
    private static final String PARAM2 = "CLASS_MAXIMUM";
    private static final String PARAM3 = "PACKAGE_MAXIMUM";

    @Override
    public void analyzeProject() {
        super.analyzeProject();
        ProjectData projectData = this.getManager().getProjectData();
        HalsteadInfo li = projectData.getHalsteadInfo();
        this.generateResultsForASTNode((IResource)null, "0", projectData, li.getProgramVocabulary());
    }

    @Override
    protected void analyzePackage(ProjectData projectData, PackageData packageData) {
        super.analyzePackage(projectData, packageData);
        double packageMaximum = NumberUtilities.convertStringToDouble(this, PARAM3);
        HalsteadInfo pli = packageData.getHalsteadInfo();
        int vocabulary = pli.getProgramVocabulary();
        this.generateResultsForASTNode((IResource)null, this.getMaximumSeverity((double)vocabulary, packageMaximum), projectData, packageData, vocabulary);
    }

    @Override
    protected void analyzeClass(ProjectData projectData, PackageData packageData, ClassData classData) {
        super.analyzeClass(projectData, packageData, classData);
        double classMaximum = NumberUtilities.convertStringToDouble(this, PARAM2);
        HalsteadInfo cli = classData.getHalsteadInfo();
        int vocabulary = cli.getProgramVocabulary();
        this.generateResultsForASTNode(classData.getResource(), this.getMaximumSeverity((double)vocabulary, classMaximum), projectData, packageData, classData, vocabulary);
    }

    @Override
    protected void analyzeMethod(ProjectData projectData, PackageData packageData, ClassData classData, MethodData methodData) {
        double methodMaximum = NumberUtilities.convertStringToDouble(this, PARAM1);
        HalsteadInfo mli = methodData.getHalsteadInfo();
        int vocabulary = mli.getProgramVocabulary();
        this.generateResultsForASTNode(classData.getResource(), this.getMaximumSeverity((double)vocabulary, methodMaximum), projectData, packageData, classData, methodData, vocabulary, methodData.getNodeStart(), methodData.getNodeLength());
    }

    @Override
    public void setElementDataValue(ElementData data, double value) {
        data.getHalsteadInfo().setProgramVocabulary((int)Math.round(value));
    }
}

