/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java.internal.rules.halstead;

import com.ibm.xtools.analysis.metrics.java.MetricsRule;
import com.ibm.xtools.analysis.metrics.java.data.ClassData;
import com.ibm.xtools.analysis.metrics.java.data.ElementData;
import com.ibm.xtools.analysis.metrics.java.data.MethodData;
import com.ibm.xtools.analysis.metrics.java.data.PackageData;
import com.ibm.xtools.analysis.metrics.java.data.ProjectData;
import com.ibm.xtools.analysis.metrics.java.data.util.HalsteadInfo;
import com.ibm.xtools.analysis.metrics.java.internal.util.NumberUtilities;

public class ProgramLevel
extends MetricsRule {
    private static final String PARAM1 = "METHOD_MAXIMUM";
    private static final String PARAM2 = "CLASS_MAXIMUM";
    private static final String PARAM3 = "PACKAGE_MAXIMUM";

    @Override
    public void analyzeProject() {
        super.analyzeProject();
        ProjectData projectData = this.getManager().getProjectData();
        HalsteadInfo li = projectData.getHalsteadInfo();
        this.generateResultsForASTNode(null, "0", projectData, li.getProgramLevel());
    }

    @Override
    protected void analyzePackage(ProjectData projectData, PackageData packageData) {
        super.analyzePackage(projectData, packageData);
        double packageMaximum = NumberUtilities.convertStringToDouble(this, PARAM3);
        HalsteadInfo pli = packageData.getHalsteadInfo();
        double level = pli.getProgramLevel();
        this.generateResultsForASTNode(null, this.getMaximumSeverity(level, packageMaximum), projectData, packageData, level);
    }

    @Override
    protected void analyzeClass(ProjectData projectData, PackageData packageData, ClassData classData) {
        super.analyzeClass(projectData, packageData, classData);
        double classMaximum = NumberUtilities.convertStringToDouble(this, PARAM2);
        HalsteadInfo cli = classData.getHalsteadInfo();
        double level = cli.getProgramLevel();
        this.generateResultsForASTNode(classData.getResource(), this.getMaximumSeverity(level, classMaximum), projectData, packageData, classData, level);
    }

    @Override
    protected void analyzeMethod(ProjectData projectData, PackageData packageData, ClassData classData, MethodData methodData) {
        double methodMaximum = NumberUtilities.convertStringToDouble(this, PARAM1);
        HalsteadInfo mli = methodData.getHalsteadInfo();
        double level = mli.getProgramLevel();
        this.generateResultsForASTNode(classData.getResource(), this.getMaximumSeverity(level, methodMaximum), projectData, packageData, classData, methodData, level, methodData.getNodeStart(), methodData.getNodeLength());
    }

    @Override
    public void setElementDataValue(ElementData data, double value) {
        data.getHalsteadInfo().setProgramLevel(value);
    }
}

