/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java.internal.rules.dependency;

import com.ibm.xtools.analysis.metrics.java.MetricsRule;
import com.ibm.xtools.analysis.metrics.java.data.ClassData;
import com.ibm.xtools.analysis.metrics.java.data.ContainerData;
import com.ibm.xtools.analysis.metrics.java.data.ElementData;
import com.ibm.xtools.analysis.metrics.java.data.PackageData;
import com.ibm.xtools.analysis.metrics.java.data.ProjectData;
import com.ibm.xtools.analysis.metrics.java.data.util.DependencyInfo;
import com.ibm.xtools.analysis.metrics.java.internal.util.NumberUtilities;
import java.util.HashSet;
import java.util.Set;

public class Instability
extends MetricsRule {
    private static final String PARAM1 = "PACKAGE_MAXIMUM";
    private static final String PARAM2 = "CLASS_MAXIMUM";

    @Override
    public void analyzeProject() {
        super.analyzeProject();
        ProjectData projectData = this.getManager().getProjectData();
        DependencyInfo di = projectData.getDependencyInfo();
        this.generateResultsForASTNode(null, "0", projectData, di.getInstability());
    }

    @Override
    protected void analyzePackage(ProjectData projectData, PackageData packageData) {
        super.analyzePackage(projectData, packageData);
        double packageMaximum = NumberUtilities.convertStringToDouble(this, PARAM1);
        DependencyInfo pdi = packageData.getDependencyInfo();
        double instability = pdi.getInstability();
        this.generateResultsForASTNode(null, this.getMaximumSeverity(instability, packageMaximum), projectData, packageData, instability);
    }

    @Override
    protected void analyzeClass(ProjectData projectData, PackageData packageData, ClassData classData) {
        super.analyzeClass(projectData, packageData, classData);
        double classMaximum = NumberUtilities.convertStringToDouble(this, PARAM2);
        DependencyInfo cdi = classData.getDependencyInfo();
        double instability = cdi.getInstability();
        this.generateResultsForASTNode(classData.getResource(), this.getMaximumSeverity(instability, classMaximum), projectData, packageData, classData, instability);
    }

    @Override
    public boolean getRequireCouplingInformation() {
        return true;
    }

    public Set<String> getBasicRequiredDataCollectorsID() {
        HashSet<String> ids = new HashSet<String>(1);
        ids.add("com.ibm.rsaz.analysis.architecture.java.collector.DependencyDataCollector");
        return ids;
    }

    @Override
    public void setElementDataValue(ElementData data, double value) {
        if (data instanceof ContainerData) {
            ((ContainerData)data).getDependencyInfo().setInstability(value);
        }
    }
}

