/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java.internal.rules.dependency;

import com.ibm.xtools.analysis.metrics.java.MetricsRule;
import com.ibm.xtools.analysis.metrics.java.data.ClassData;
import com.ibm.xtools.analysis.metrics.java.data.ElementData;
import com.ibm.xtools.analysis.metrics.java.data.PackageData;
import com.ibm.xtools.analysis.metrics.java.data.ProjectData;
import com.ibm.xtools.analysis.metrics.java.data.util.DependencyInfo;
import com.ibm.xtools.analysis.metrics.java.internal.util.NumberUtilities;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IResource;

public class EfferentCoupling
extends MetricsRule {
    private static final String PARAM1 = "PACKAGE_MAXIMUM";
    private static final String PARAM2 = "CLASS_MAXIMUM";

    @Override
    public void analyzeProject() {
        super.analyzeProject();
        ProjectData projectData = this.getManager().getProjectData();
        DependencyInfo di = projectData.getDependencyInfo();
        this.generateResultsForASTNode((IResource)null, "0", projectData, di.getEfferentCoupling());
    }

    @Override
    protected void analyzePackage(ProjectData projectData, PackageData packageData) {
        super.analyzePackage(projectData, packageData);
        int packageMaximum = NumberUtilities.convertStringToInt(this, PARAM1);
        DependencyInfo pdi = packageData.getDependencyInfo();
        int efferent = pdi.getEfferentCoupling();
        this.generateResultsForASTNode((IResource)null, this.getMaximumSeverity(efferent, packageMaximum), projectData, packageData, efferent);
    }

    @Override
    protected void analyzeClass(ProjectData projectData, PackageData packageData, ClassData classData) {
        super.analyzeClass(projectData, packageData, classData);
        int classMaximum = NumberUtilities.convertStringToInt(this, PARAM2);
        DependencyInfo cdi = classData.getDependencyInfo();
        int efferent = cdi.getEfferentCoupling();
        this.generateResultsForASTNode(classData.getResource(), this.getMaximumSeverity(efferent, classMaximum), projectData, packageData, classData, efferent);
    }

    @Override
    public boolean getRequireCouplingInformation() {
        return true;
    }

    public Set<String> getBasicRequiredDataCollectorsID() {
        HashSet<String> ids = new HashSet<String>(1);
        ids.add("com.ibm.rsaz.analysis.architecture.java.collector.DependencyDataCollector");
        return ids;
    }

    @Override
    public void setElementDataValue(ElementData data, double value) {
        data.getDependencyInfo().setEfferentCoupling((int)Math.round(value));
    }
}

