/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java.internal.rules.dependency;

import com.ibm.xtools.analysis.metrics.java.MetricsRule;
import com.ibm.xtools.analysis.metrics.java.data.ClassData;
import com.ibm.xtools.analysis.metrics.java.data.ElementData;
import com.ibm.xtools.analysis.metrics.java.data.PackageData;
import com.ibm.xtools.analysis.metrics.java.data.ProjectData;
import com.ibm.xtools.analysis.metrics.java.data.util.ClassInfo;
import com.ibm.xtools.analysis.metrics.java.data.util.DependencyInfo;
import com.ibm.xtools.analysis.metrics.java.internal.util.NumberUtilities;
import java.util.HashSet;
import java.util.Set;

public class Distance
extends MetricsRule {
    private static final String PARAM0 = "MINIMUM";
    private static final String PARAM1 = "MAXIMUM";
    private static final String PARAM2 = "INCLUDE_ABSTRACT_CLASSES";
    private static final String PARAM3 = "INCLUDE_ABSTRACT_INTERFACES";
    private boolean includeAbstractClasses;
    private boolean includeInterfaces;
    private double minimumValue;
    private double maximumValue;

    @Override
    public void analyzeProject() {
        super.analyzeProject();
        ProjectData projectData = this.getManager().getProjectData();
        this.includeAbstractClasses = Boolean.parseBoolean(this.getParameter(PARAM2).getValue());
        this.includeInterfaces = Boolean.parseBoolean(this.getParameter(PARAM3).getValue());
        this.minimumValue = NumberUtilities.convertStringToDouble(this, PARAM0);
        this.maximumValue = NumberUtilities.convertStringToDouble(this, PARAM1);
        ClassInfo ci = projectData.getClassInfo();
        DependencyInfo di = projectData.getDependencyInfo();
        double abstractCount = 0.0;
        if (this.includeAbstractClasses) {
            abstractCount += (double)ci.getAbstractClassCount();
        }
        int totalClasses = ci.getTotalClassCount();
        int totalInterfaces = ci.getTotalInterfaceCount();
        if (this.includeInterfaces) {
            abstractCount += (double)totalInterfaces;
        }
        double abstractness = 0.0;
        if (totalClasses + totalInterfaces > 0) {
            abstractness = abstractCount / (double)(totalClasses + totalInterfaces);
        }
        double distance = this.calculateDistance(di, abstractness);
        this.generateResultsForASTNode(null, "0", projectData, distance);
    }

    private double calculateDistance(DependencyInfo di, double abstractness) {
        double distance = Math.abs(abstractness + di.getInstability() - 1.0);
        return distance;
    }

    @Override
    protected void analyzePackage(ProjectData projectData, PackageData packageData) {
        super.analyzePackage(projectData, packageData);
        ClassInfo pci = packageData.getClassInfo();
        DependencyInfo pdi = packageData.getDependencyInfo();
        double abstractCount = 0.0;
        if (this.includeAbstractClasses) {
            abstractCount += (double)pci.getAbstractClassCount();
        }
        int totalClasses = pci.getTotalClassCount();
        int totalInterfaces = pci.getTotalInterfaceCount();
        if (this.includeInterfaces) {
            abstractCount += (double)totalInterfaces;
        }
        double abstractness = 0.0;
        if (totalClasses + totalInterfaces > 0) {
            abstractness = abstractCount / (double)(totalClasses + totalInterfaces);
        }
        double distance = this.calculateDistance(pdi, abstractness);
        this.generateResultsForASTNode(null, this.getMinMaxSeverity(distance, this.minimumValue, this.maximumValue), projectData, packageData, distance);
    }

    @Override
    protected void analyzeClass(ProjectData projectData, PackageData packageData, ClassData classData) {
        super.analyzeClass(projectData, packageData, classData);
        ClassInfo cci = packageData.getClassInfo();
        DependencyInfo cdi = classData.getDependencyInfo();
        double cAbstractCount = 0.0;
        if (this.includeAbstractClasses) {
            cAbstractCount += (double)cci.getAbstractClassCount();
        }
        int totalClasses = cci.getTotalClassCount();
        int totalinterfaces = cci.getTotalInterfaceCount();
        if (this.includeInterfaces) {
            cAbstractCount += (double)totalinterfaces;
        }
        double cAbstractness = 0.0;
        if (totalClasses + totalinterfaces > 0) {
            cAbstractness = cAbstractCount / (double)(totalClasses + totalinterfaces);
        }
        double cDistance = this.calculateDistance(cdi, cAbstractness);
        this.generateResultsForASTNode(classData.getResource(), this.getMinMaxSeverity(cDistance, this.minimumValue, this.maximumValue), projectData, packageData, classData, cDistance);
    }

    @Override
    public boolean getRequireCouplingInformation() {
        return true;
    }

    public Set<String> getBasicRequiredDataCollectorsID() {
        HashSet<String> ids = new HashSet<String>(1);
        ids.add("com.ibm.rsaz.analysis.architecture.java.collector.DependencyDataCollector");
        return ids;
    }

    @Override
    public void setElementDataValue(ElementData data, double value) {
    }
}

