/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java.internal.rules.dependency;

import com.ibm.xtools.analysis.metrics.java.MetricsRule;
import com.ibm.xtools.analysis.metrics.java.data.ClassData;
import com.ibm.xtools.analysis.metrics.java.data.ContainerData;
import com.ibm.xtools.analysis.metrics.java.data.ElementData;
import com.ibm.xtools.analysis.metrics.java.data.PackageData;
import com.ibm.xtools.analysis.metrics.java.data.ProjectData;
import com.ibm.xtools.analysis.metrics.java.data.util.DependencyInfo;
import com.ibm.xtools.analysis.metrics.java.internal.util.NumberUtilities;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IResource;

public class AfferentCoupling
extends MetricsRule {
    private static final String PARAM1 = "PACKAGE_MAXIMUM";
    private static final String PARAM2 = "CLASS_MAXIMUM";

    @Override
    public void analyzeProject() {
        super.analyzeProject();
        ProjectData projectData = this.getManager().getProjectData();
        DependencyInfo pdi = projectData.getDependencyInfo();
        this.generateResultsForASTNode((IResource)null, "0", projectData, pdi.getAfferentCoupling());
    }

    @Override
    protected void analyzePackage(ProjectData projectData, PackageData packageData) {
        super.analyzePackage(projectData, packageData);
        int packageMaximum = NumberUtilities.convertStringToInt(this, PARAM1);
        DependencyInfo pdi = packageData.getDependencyInfo();
        int coupling = pdi.getAfferentCoupling();
        this.generateResultsForASTNode((IResource)null, this.getMaximumSeverity(coupling, packageMaximum), projectData, packageData, coupling);
    }

    @Override
    protected void analyzeClass(ProjectData projectData, PackageData packageData, ClassData classData) {
        super.analyzeClass(projectData, packageData, classData);
        int classMaximum = NumberUtilities.convertStringToInt(this, PARAM2);
        DependencyInfo cdi = classData.getDependencyInfo();
        int coupling = cdi.getAfferentCoupling();
        this.generateResultsForASTNode(classData.getResource(), this.getMaximumSeverity(coupling, classMaximum), projectData, packageData, classData, coupling);
    }

    @Override
    public boolean getRequireCouplingInformation() {
        return true;
    }

    public Set<String> getBasicRequiredDataCollectorsID() {
        HashSet<String> ids = new HashSet<String>(1);
        ids.add("com.ibm.rsaz.analysis.architecture.java.collector.DependencyDataCollector");
        return ids;
    }

    @Override
    public void setElementDataValue(ElementData data, double value) {
        if (data instanceof ContainerData) {
            ((ContainerData)data).getDependencyInfo().setAfferentCoupling((int)Math.round(value));
        }
    }
}

