/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java.internal.rules.dependency;

import com.ibm.xtools.analysis.metrics.java.MetricsRule;
import com.ibm.xtools.analysis.metrics.java.data.ElementData;
import com.ibm.xtools.analysis.metrics.java.data.PackageData;
import com.ibm.xtools.analysis.metrics.java.data.ProjectData;
import com.ibm.xtools.analysis.metrics.java.data.util.ClassInfo;
import com.ibm.xtools.analysis.metrics.java.internal.util.NumberUtilities;

public class Abstractness
extends MetricsRule {
    private static final String PARAM1 = "PACKAGE_MINIMUM";
    private static final String PARAM2 = "INCLUDE_ABSTRACT_CLASSES";
    private static final String PARAM3 = "INCLUDE_ABSTRACT_INTERFACES";

    @Override
    public void analyzeProject() {
        super.analyzeProject();
        ProjectData projectData = this.getManager().getProjectData();
        boolean includeAbstractClasses = Boolean.parseBoolean(this.getParameter(PARAM2).getValue());
        boolean includeInterfaces = Boolean.parseBoolean(this.getParameter(PARAM3).getValue());
        ClassInfo projectClassInfo = projectData.getClassInfo();
        double abstractCount = 0.0;
        if (includeAbstractClasses) {
            abstractCount += (double)projectClassInfo.getAbstractClassCount();
        }
        int totalClasses = projectClassInfo.getTotalClassCount();
        int totalinterfaces = projectClassInfo.getTotalInterfaceCount();
        if (includeInterfaces) {
            abstractCount += (double)totalinterfaces;
        }
        double ratio = 0.0;
        if (totalClasses + totalinterfaces > 0) {
            ratio = abstractCount / (double)(totalClasses + totalinterfaces);
        }
        this.generateResultsForASTNode(null, "0", projectData, ratio);
    }

    @Override
    protected void analyzePackage(ProjectData projectData, PackageData packageData) {
        super.analyzePackage(projectData, packageData);
        double packageMinimum = NumberUtilities.convertStringToDouble(this, PARAM1);
        boolean includeAbstractClasses = Boolean.parseBoolean(this.getParameter(PARAM2).getValue());
        boolean includeInterfaces = Boolean.parseBoolean(this.getParameter(PARAM3).getValue());
        ClassInfo pci = packageData.getClassInfo();
        double abstractCount = 0.0;
        if (includeAbstractClasses) {
            abstractCount += (double)pci.getAbstractClassCount();
        }
        int totalClasses = pci.getTotalClassCount();
        int totalinterfaces = pci.getTotalInterfaceCount();
        if (includeInterfaces) {
            abstractCount += (double)totalinterfaces;
        }
        double ratio = 0.0;
        if (totalClasses + totalinterfaces > 0) {
            ratio = abstractCount / (double)(totalClasses + totalinterfaces);
        }
        this.generateResultsForASTNode(null, this.getMinimumSeverity(ratio, packageMinimum), projectData, packageData, ratio);
    }

    @Override
    public void setElementDataValue(ElementData data, double value) {
        if (data instanceof PackageData) {
            ((PackageData)data).getClassInfo().setAbstractClassCount((int)Math.round(value));
        } else if (data instanceof ProjectData) {
            ((ProjectData)data).getClassInfo().setAbstractClassCount((int)Math.round(value));
        }
    }
}

