/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java.internal.rules.complexity;

import com.ibm.xtools.analysis.metrics.java.MetricsRule;
import com.ibm.xtools.analysis.metrics.java.data.ClassData;
import com.ibm.xtools.analysis.metrics.java.data.ElementData;
import com.ibm.xtools.analysis.metrics.java.data.PackageData;
import com.ibm.xtools.analysis.metrics.java.data.ProjectData;
import com.ibm.xtools.analysis.metrics.java.data.util.CyclomaticComplexityInfo;
import com.ibm.xtools.analysis.metrics.java.internal.util.NumberUtilities;

public class WeightedMethods
extends MetricsRule {
    private static final String PARAM2 = "CLASS_MAXIMUM";
    private static final String PARAM3 = "PACKAGE_MAXIMUM";
    private static final String PARAM4 = "INCLUDE_CASES";
    private static final String PARAM5 = "INCLUDE_CATCHES";
    private static final String PARAM6 = "INCLUDE_CONDITIONAL";
    private static final String PARAM7 = "INCLUDE_OPERATOR";

    @Override
    public void analyzeProject() {
        super.analyzeProject();
        boolean includeCases = Boolean.parseBoolean(this.getParameter(PARAM4).getValue());
        boolean includeCatches = Boolean.parseBoolean(this.getParameter(PARAM5).getValue());
        boolean includeConditional = Boolean.parseBoolean(this.getParameter(PARAM6).getValue());
        boolean includeOperator = Boolean.parseBoolean(this.getParameter(PARAM7).getValue());
        ProjectData projectData = this.getManager().getProjectData();
        CyclomaticComplexityInfo ci = projectData.getCyclomaticComplexityInfo();
        double weightedMethods = 0.0;
        weightedMethods += (double)ci.getBaseComplexity();
        if (includeCases) {
            weightedMethods += (double)ci.getCaseComplexity();
        }
        if (includeCatches) {
            weightedMethods += (double)ci.getCatchComplexity();
        }
        if (includeConditional) {
            weightedMethods += (double)ci.getConditionalComplexity();
        }
        if (includeOperator) {
            weightedMethods += (double)ci.getOperatorComplexity();
        }
        this.generateResultsForASTNode(null, "0", projectData, weightedMethods);
    }

    @Override
    protected void analyzePackage(ProjectData projectData, PackageData packageData) {
        super.analyzePackage(projectData, packageData);
        double packageMaximum = NumberUtilities.convertStringToDouble(this, PARAM3);
        boolean includeCases = Boolean.parseBoolean(this.getParameter(PARAM4).getValue());
        boolean includeCatches = Boolean.parseBoolean(this.getParameter(PARAM5).getValue());
        boolean includeConditional = Boolean.parseBoolean(this.getParameter(PARAM6).getValue());
        boolean includeOperator = Boolean.parseBoolean(this.getParameter(PARAM7).getValue());
        CyclomaticComplexityInfo pci = packageData.getCyclomaticComplexityInfo();
        double pweightedMethods = 0.0;
        pweightedMethods += (double)pci.getBaseComplexity();
        if (includeCases) {
            pweightedMethods += (double)pci.getCaseComplexity();
        }
        if (includeCatches) {
            pweightedMethods += (double)pci.getCatchComplexity();
        }
        if (includeConditional) {
            pweightedMethods += (double)pci.getConditionalComplexity();
        }
        if (includeOperator) {
            pweightedMethods += (double)pci.getOperatorComplexity();
        }
        this.generateResultsForASTNode(null, this.getMaximumSeverity(pweightedMethods, packageMaximum), projectData, packageData, pweightedMethods);
    }

    @Override
    protected void analyzeClass(ProjectData projectData, PackageData packageData, ClassData classData) {
        super.analyzeClass(projectData, packageData, classData);
        double classMaximum = NumberUtilities.convertStringToDouble(this, PARAM2);
        boolean includeCases = Boolean.parseBoolean(this.getParameter(PARAM4).getValue());
        boolean includeCatches = Boolean.parseBoolean(this.getParameter(PARAM5).getValue());
        boolean includeConditional = Boolean.parseBoolean(this.getParameter(PARAM6).getValue());
        boolean includeOperator = Boolean.parseBoolean(this.getParameter(PARAM7).getValue());
        CyclomaticComplexityInfo ci = classData.getCyclomaticComplexityInfo();
        double weightedMethods = 0.0;
        weightedMethods += (double)ci.getBaseComplexity();
        if (includeCases) {
            weightedMethods += (double)ci.getCaseComplexity();
        }
        if (includeCatches) {
            weightedMethods += (double)ci.getCatchComplexity();
        }
        if (includeConditional) {
            weightedMethods += (double)ci.getConditionalComplexity();
        }
        if (includeOperator) {
            weightedMethods += (double)ci.getOperatorComplexity();
        }
        this.generateResultsForASTNode(classData.getResource(), this.getMaximumSeverity(weightedMethods, classMaximum), projectData, packageData, classData, weightedMethods);
    }

    @Override
    public void setElementDataValue(ElementData data, double value) {
    }
}

