/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java.internal.rules.complexity;

import com.ibm.xtools.analysis.metrics.java.MetricsRule;
import com.ibm.xtools.analysis.metrics.java.data.ClassData;
import com.ibm.xtools.analysis.metrics.java.data.ElementData;
import com.ibm.xtools.analysis.metrics.java.data.MethodData;
import com.ibm.xtools.analysis.metrics.java.data.PackageData;
import com.ibm.xtools.analysis.metrics.java.data.ProjectData;
import com.ibm.xtools.analysis.metrics.java.data.util.CyclomaticComplexityInfo;
import com.ibm.xtools.analysis.metrics.java.data.util.HalsteadInfo;
import com.ibm.xtools.analysis.metrics.java.data.util.LineInfo;
import com.ibm.xtools.analysis.metrics.java.data.util.MethodInfo;
import com.ibm.xtools.analysis.metrics.java.internal.util.NumberUtilities;
import java.util.Collection;
import java.util.List;

public class MaintainabilityIndex
extends MetricsRule {
    private static final String PARAM1 = "METHOD_MINIMUM";
    private static final String PARAM2 = "CLASS_MINIMUM";
    private static final String PARAM3 = "PACKAGE_MINIMUM";
    private static final String PARAM4 = "INCLUDE_CASES";
    private static final String PARAM5 = "INCLUDE_CATCHES";
    private static final String PARAM6 = "INCLUDE_CONDITIONAL";
    private static final String PARAM7 = "INCLUDE_OPERATOR";
    private static final double HORRIBLE_CODE = (double)1.0E-6f;

    @Override
    public void analyzeProject() {
        super.analyzeProject();
        ProjectData projectData = this.getManager().getProjectData();
        double maintainability = 0.0;
        Collection<PackageData> dataList = projectData.getPackageDataCollection();
        int size = 0;
        for (PackageData packageData : dataList) {
            double mvalue = packageData.getMaintainability();
            if (mvalue > 0.0) {
                ++size;
                maintainability += mvalue;
            }
            maintainability += mvalue;
        }
        if (size > 0) {
            this.generateResultsForASTNode(null, "0", projectData, maintainability /= (double)size);
        }
    }

    @Override
    protected void analyzePackage(ProjectData projectData, PackageData packageData) {
        super.analyzePackage(projectData, packageData);
        double packageMinimum = NumberUtilities.convertStringToDouble(this, PARAM3);
        double maintainability = 0.0;
        List<ClassData> dataList = packageData.getClassDataList();
        int size = 0;
        for (ClassData classData : dataList) {
            double mvalue = classData.getMaintainability();
            if (!(mvalue > 0.0)) continue;
            ++size;
            maintainability += mvalue;
        }
        if (size > 0) {
            this.generateResultsForASTNode(null, this.getMinimumSeverity(maintainability /= (double)size, packageMinimum), projectData, packageData, maintainability);
        } else {
            maintainability = 0.0;
        }
        packageData.setMaintainability(maintainability);
    }

    @Override
    protected void analyzeClass(ProjectData projectData, PackageData packageData, ClassData classData) {
        super.analyzeClass(projectData, packageData, classData);
        double classMinimum = NumberUtilities.convertStringToDouble(this, PARAM2);
        double maintainability = 0.0;
        List<MethodData> dataList = classData.getMethodDataList();
        int size = 0;
        for (MethodData methodData : dataList) {
            double mvalue = methodData.getMaintainability();
            if (!(mvalue > 0.0)) continue;
            ++size;
            maintainability += mvalue;
        }
        if (size > 0) {
            this.generateResultsForASTNode(classData.getResource(), this.getMinimumSeverity(maintainability /= (double)size, classMinimum), projectData, packageData, classData, maintainability);
        } else {
            maintainability = 0.0;
        }
        classData.setMaintainability(maintainability);
    }

    @Override
    protected void analyzeMethod(ProjectData projectData, PackageData packageData, ClassData classData, MethodData methodData) {
        double maintainability;
        double methodMinimum = NumberUtilities.convertStringToDouble(this, PARAM1);
        boolean includeCases = Boolean.parseBoolean(this.getParameter(PARAM4).getValue());
        boolean includeCatches = Boolean.parseBoolean(this.getParameter(PARAM5).getValue());
        boolean includeConditional = Boolean.parseBoolean(this.getParameter(PARAM6).getValue());
        boolean includeOperator = Boolean.parseBoolean(this.getParameter(PARAM7).getValue());
        HalsteadInfo hi = methodData.getHalsteadInfo();
        MethodInfo mi = methodData.getMethodInfo();
        LineInfo li = methodData.getLineInfo();
        CyclomaticComplexityInfo cci = methodData.getCyclomaticComplexityInfo();
        int cc = cci.getBaseComplexity();
        if (includeCases) {
            cc += cci.getCaseComplexity();
        }
        if (includeCatches) {
            cc += cci.getCatchComplexity();
        }
        if (includeConditional) {
            cc += cci.getConditionalComplexity();
        }
        if (includeOperator) {
            cc += cci.getOperatorComplexity();
        }
        int totalMethods = mi.getTotalMethodCount();
        int totalConstructors = mi.getTotalConstructorCount();
        int linesWithCode = li.getLinesWithCode();
        double avgLoc = 0.0;
        if (totalMethods + totalConstructors > 0) {
            avgLoc = (double)linesWithCode / (double)(totalMethods + totalConstructors);
        }
        double ccratio = 0.0;
        if (linesWithCode > 0) {
            ccratio = (double)li.getTotalComments() / (double)linesWithCode * 100.0;
        }
        if ((maintainability = 171.0 - (double)5.2f * Math.log1p(hi.getProgramVolume()) - (double)(0.23f * (float)cc) - (double)16.2f * Math.log1p(avgLoc) + 50.0 * Math.sin(Math.sqrt((double)2.4f * (ccratio / 100.0)))) < (double)1.0E-6f) {
            maintainability = 1.0E-6f;
        }
        methodData.setMaintainability(maintainability);
        this.generateResultsForASTNode(classData.getResource(), this.getMinimumSeverity(maintainability, methodMinimum), projectData, packageData, classData, methodData, maintainability, methodData.getNodeStart(), methodData.getNodeLength());
    }

    @Override
    public void setElementDataValue(ElementData data, double value) {
        if (data instanceof MethodData) {
            ((MethodData)data).setMaintainability(value);
        } else if (data instanceof ClassData) {
            ((ClassData)data).setMaintainability(value);
        } else if (data instanceof PackageData) {
            ((PackageData)data).setMaintainability(value);
        }
    }
}

