/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java.internal.rules.complexity;

import com.ibm.xtools.analysis.metrics.java.MetricsRule;
import com.ibm.xtools.analysis.metrics.java.data.ClassData;
import com.ibm.xtools.analysis.metrics.java.data.ElementData;
import com.ibm.xtools.analysis.metrics.java.data.MethodData;
import com.ibm.xtools.analysis.metrics.java.data.PackageData;
import com.ibm.xtools.analysis.metrics.java.data.ProjectData;
import com.ibm.xtools.analysis.metrics.java.data.util.CyclomaticComplexityInfo;
import com.ibm.xtools.analysis.metrics.java.data.util.MethodInfo;
import com.ibm.xtools.analysis.metrics.java.internal.util.NumberUtilities;

public class CC
extends MetricsRule {
    private static final String PARAM1 = "METHOD_MAXIMUM";
    private static final String PARAM2 = "CLASS_MAXIMUM";
    private static final String PARAM3 = "PACKAGE_MAXIMUM";
    private static final String PARAM4 = "INCLUDE_CASES";
    private static final String PARAM5 = "INCLUDE_CATCHES";
    private static final String PARAM6 = "INCLUDE_CONDITIONAL";
    private static final String PARAM7 = "INCLUDE_OPERATOR";

    @Override
    public void analyzeProject() {
        super.analyzeProject();
        boolean includeCases = Boolean.parseBoolean(this.getParameter(PARAM4).getValue());
        boolean includeCatches = Boolean.parseBoolean(this.getParameter(PARAM5).getValue());
        boolean includeConditional = Boolean.parseBoolean(this.getParameter(PARAM6).getValue());
        boolean includeOperator = Boolean.parseBoolean(this.getParameter(PARAM7).getValue());
        ProjectData projectData = this.getManager().getProjectData();
        CyclomaticComplexityInfo mci = projectData.getCyclomaticComplexityInfo();
        MethodInfo mi = projectData.getMethodInfo();
        int total = mci.getBaseComplexity();
        if (includeCases) {
            total += mci.getCaseComplexity();
        }
        if (includeCatches) {
            total += mci.getCatchComplexity();
        }
        if (includeConditional) {
            total += mci.getConditionalComplexity();
        }
        if (includeOperator) {
            total += mci.getOperatorComplexity();
        }
        int methods = mi.getTotalMethodCount() + mi.getTotalConstructorCount();
        double value = 0.0;
        if (methods > 0) {
            value = (double)total / (double)methods;
        }
        this.generateResultsForASTNode(null, "0", projectData, value);
    }

    @Override
    protected void analyzePackage(ProjectData projectData, PackageData packageData) {
        super.analyzePackage(projectData, packageData);
        double packageMaximum = NumberUtilities.convertStringToDouble(this, PARAM3);
        boolean includeCases = Boolean.parseBoolean(this.getParameter(PARAM4).getValue());
        boolean includeCatches = Boolean.parseBoolean(this.getParameter(PARAM5).getValue());
        boolean includeConditional = Boolean.parseBoolean(this.getParameter(PARAM6).getValue());
        boolean includeOperator = Boolean.parseBoolean(this.getParameter(PARAM7).getValue());
        CyclomaticComplexityInfo pci = packageData.getCyclomaticComplexityInfo();
        int ptotal = pci.getBaseComplexity();
        if (includeCases) {
            ptotal += pci.getCaseComplexity();
        }
        if (includeCatches) {
            ptotal += pci.getCatchComplexity();
        }
        if (includeConditional) {
            ptotal += pci.getConditionalComplexity();
        }
        if (includeOperator) {
            ptotal += pci.getOperatorComplexity();
        }
        double value = 0.0;
        int iCtr = packageData.getCyclomaticMethodsCount();
        if (iCtr > 0) {
            value = (double)ptotal / (double)iCtr;
        }
        this.generateResultsForASTNode(null, this.getMaximumSeverity(value, packageMaximum), projectData, packageData, value);
    }

    @Override
    protected void analyzeClass(ProjectData projectData, PackageData packageData, ClassData classData) {
        super.analyzeClass(projectData, packageData, classData);
        double classMaximum = NumberUtilities.convertStringToDouble(this, PARAM2);
        boolean includeCases = Boolean.parseBoolean(this.getParameter(PARAM4).getValue());
        boolean includeCatches = Boolean.parseBoolean(this.getParameter(PARAM5).getValue());
        boolean includeConditional = Boolean.parseBoolean(this.getParameter(PARAM6).getValue());
        boolean includeOperator = Boolean.parseBoolean(this.getParameter(PARAM7).getValue());
        CyclomaticComplexityInfo cci = classData.getCyclomaticComplexityInfo();
        MethodInfo cmi = classData.getMethodInfo();
        int ctotal = cci.getBaseComplexity();
        if (includeCases) {
            ctotal += cci.getCaseComplexity();
        }
        if (includeCatches) {
            ctotal += cci.getCatchComplexity();
        }
        if (includeConditional) {
            ctotal += cci.getConditionalComplexity();
        }
        if (includeOperator) {
            ctotal += cci.getOperatorComplexity();
        }
        int methods = cmi.getTotalMethodCount() + cmi.getTotalConstructorCount();
        double cvalue = 0.0;
        if (methods > 0) {
            cvalue = (double)ctotal / (double)methods;
        }
        this.generateResultsForASTNode(classData.getResource(), this.getMaximumSeverity(cvalue, classMaximum), projectData, packageData, classData, cvalue);
    }

    @Override
    protected void analyzeMethod(ProjectData projectData, PackageData packageData, ClassData classData, MethodData methodData) {
        double methodMaximum = NumberUtilities.convertStringToDouble(this, PARAM1);
        boolean includeCases = Boolean.parseBoolean(this.getParameter(PARAM4).getValue());
        boolean includeCatches = Boolean.parseBoolean(this.getParameter(PARAM5).getValue());
        boolean includeConditional = Boolean.parseBoolean(this.getParameter(PARAM6).getValue());
        boolean includeOperator = Boolean.parseBoolean(this.getParameter(PARAM7).getValue());
        CyclomaticComplexityInfo cci = methodData.getCyclomaticComplexityInfo();
        int total = cci.getBaseComplexity();
        if (includeCases) {
            total += cci.getCaseComplexity();
        }
        if (includeCatches) {
            total += cci.getCatchComplexity();
        }
        if (includeConditional) {
            total += cci.getConditionalComplexity();
        }
        if (includeOperator) {
            total += cci.getOperatorComplexity();
        }
        this.generateResultsForASTNode(classData.getResource(), this.getMaximumSeverity((double)total, methodMaximum), projectData, packageData, classData, methodData, total, methodData.getNodeStart(), methodData.getNodeLength());
    }

    @Override
    public void setElementDataValue(ElementData data, double value) {
    }
}

