/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java.internal.rules.complexity;

import com.ibm.xtools.analysis.metrics.java.MetricsRule;
import com.ibm.xtools.analysis.metrics.java.data.ClassData;
import com.ibm.xtools.analysis.metrics.java.data.ElementData;
import com.ibm.xtools.analysis.metrics.java.data.MethodData;
import com.ibm.xtools.analysis.metrics.java.data.PackageData;
import com.ibm.xtools.analysis.metrics.java.data.ProjectData;
import com.ibm.xtools.analysis.metrics.java.internal.util.NumberUtilities;

public class BlockDepth
extends MetricsRule {
    private static final String PARAM1 = "METHOD_MAXIMUM";
    private static final String PARAM2 = "CLASS_MAXIMUM";
    private static final String PARAM3 = "PACKAGE_MAXIMUM";

    @Override
    public void analyzeProject() {
        super.analyzeProject();
        ProjectData projectData = this.getManager().getProjectData();
        int methodCount = projectData.getBlockDepthMethodCount();
        double average = 0.0;
        if (methodCount != 0) {
            average = projectData.getBlockDepthMetric() / (double)methodCount;
        }
        this.generateResultsForASTNode(null, "0", projectData, average);
    }

    @Override
    protected void analyzePackage(ProjectData projectData, PackageData packageData) {
        super.analyzePackage(projectData, packageData);
        double packageMaximum = NumberUtilities.convertStringToDouble(this, PARAM3);
        int methodCount = packageData.getBlockDepthMethodCount();
        double average = 0.0;
        if (methodCount != 0) {
            average = packageData.getBlockDepthMetric() / (double)methodCount;
        }
        this.generateResultsForASTNode(null, this.getMaximumSeverity(average, packageMaximum), projectData, packageData, average);
    }

    @Override
    protected void analyzeClass(ProjectData projectData, PackageData packageData, ClassData classData) {
        super.analyzeClass(projectData, packageData, classData);
        double classMaximum = NumberUtilities.convertStringToDouble(this, PARAM2);
        int methodCount = classData.getBlockDepthMethodCount();
        double average = 0.0;
        if (methodCount != 0) {
            average = classData.getBlockDepthMetric() / (double)methodCount;
        }
        this.generateResultsForASTNode(classData.getResource(), this.getMaximumSeverity(average, classMaximum), projectData, packageData, classData, average);
    }

    @Override
    protected void analyzeMethod(ProjectData projectData, PackageData packageData, ClassData classData, MethodData methodData) {
        double methodMaximum = NumberUtilities.convertStringToDouble(this, PARAM1);
        double value = methodData.getBlockDepthMetric();
        this.generateResultsForASTNode(classData.getResource(), this.getMaximumSeverity(value, methodMaximum), projectData, packageData, classData, methodData, value, methodData.getNodeStart(), methodData.getNodeLength());
    }

    @Override
    public void setElementDataValue(ElementData data, double value) {
    }
}

