/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java.internal.rules.cohesion;

import com.ibm.xtools.analysis.metrics.java.MetricsRule;
import com.ibm.xtools.analysis.metrics.java.data.ClassData;
import com.ibm.xtools.analysis.metrics.java.data.ContainerData;
import com.ibm.xtools.analysis.metrics.java.data.ElementData;
import com.ibm.xtools.analysis.metrics.java.data.PackageData;
import com.ibm.xtools.analysis.metrics.java.data.ProjectData;
import com.ibm.xtools.analysis.metrics.java.data.util.CohesionInfo;
import com.ibm.xtools.analysis.metrics.java.internal.util.NumberUtilities;

public class LackOfCohesion2
extends MetricsRule {
    private static final String PARAM2 = "CLASS_MAXIMUM";
    private static final String PARAM3 = "PACKAGE_MAXIMUM";

    @Override
    public void analyzeProject() {
        super.analyzeProject();
        ProjectData projectData = this.getManager().getProjectData();
        CohesionInfo info = projectData.getCohesionInfo();
        this.generateResultsForASTNode(null, "0", projectData, info.getLcom2());
    }

    @Override
    protected void analyzePackage(ProjectData projectData, PackageData packageData) {
        super.analyzePackage(projectData, packageData);
        double packageMaximum = NumberUtilities.convertStringToDouble(this, PARAM3);
        CohesionInfo info = packageData.getCohesionInfo();
        double lcom2 = info.getLcom2();
        this.generateResultsForASTNode(null, this.getMaximumSeverity(lcom2, packageMaximum), projectData, packageData, lcom2);
    }

    @Override
    protected void analyzeClass(ProjectData projectData, PackageData packageData, ClassData classData) {
        super.analyzeClass(projectData, packageData, classData);
        double classMaximum = NumberUtilities.convertStringToDouble(this, PARAM2);
        CohesionInfo info = classData.getCohesionInfo();
        double lcom2 = info.getLcom2();
        this.generateResultsForASTNode(classData.getResource(), this.getMaximumSeverity(lcom2, classMaximum), projectData, packageData, classData, lcom2);
    }

    @Override
    public void setElementDataValue(ElementData data, double value) {
        if (data instanceof ContainerData) {
            data.getCohesionInfo().setLcom2(value);
        }
    }
}

