/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java.internal.rules.cohesion;

import com.ibm.xtools.analysis.metrics.java.MetricsRule;
import com.ibm.xtools.analysis.metrics.java.data.ClassData;
import com.ibm.xtools.analysis.metrics.java.data.ContainerData;
import com.ibm.xtools.analysis.metrics.java.data.ElementData;
import com.ibm.xtools.analysis.metrics.java.data.PackageData;
import com.ibm.xtools.analysis.metrics.java.data.ProjectData;
import com.ibm.xtools.analysis.metrics.java.data.util.CohesionInfo;
import com.ibm.xtools.analysis.metrics.java.internal.util.NumberUtilities;

public class LackOfCohesion1
extends MetricsRule {
    private static final String PARAM2 = "CLASS_MAXIMUM";
    private static final String PARAM3 = "PACKAGE_MAXIMUM";

    @Override
    public void analyzeProject() {
        super.analyzeProject();
        ProjectData projectData = this.getManager().getProjectData();
        CohesionInfo info = projectData.getCohesionInfo();
        this.generateResultsForASTNode(null, "0", projectData, info.getLcom1DoubleValue());
    }

    @Override
    protected void analyzePackage(ProjectData projectData, PackageData packageData) {
        super.analyzePackage(projectData, packageData);
        int packageMaximum = NumberUtilities.convertStringToInt(this, PARAM3);
        CohesionInfo info = packageData.getCohesionInfo();
        double lcom1 = info.getLcom1DoubleValue();
        this.generateResultsForASTNode(null, this.getLcom1MaximumSeverity(lcom1, packageMaximum), projectData, packageData, lcom1);
    }

    @Override
    protected void analyzeClass(ProjectData projectData, PackageData packageData, ClassData classData) {
        super.analyzeClass(projectData, packageData, classData);
        int classMaximum = NumberUtilities.convertStringToInt(this, PARAM2);
        CohesionInfo info = classData.getCohesionInfo();
        double lcom1 = info.getLcom1DoubleValue();
        this.generateResultsForASTNode(classData.getResource(), this.getLcom1MaximumSeverity(lcom1, classMaximum), projectData, packageData, classData, lcom1);
    }

    private String getLcom1MaximumSeverity(double value, int maximum) {
        String severity = "0";
        if (value > (double)(5000 * maximum)) {
            severity = "4";
        } else if (value > (double)(500 * maximum)) {
            severity = "3";
        } else if (value > (double)(50 * maximum)) {
            severity = "2";
        } else if (value > (double)maximum) {
            severity = "1";
        }
        return severity;
    }

    @Override
    public void setElementDataValue(ElementData data, double value) {
        if (data instanceof ContainerData) {
            data.getCohesionInfo().setLcom1DoubleValue(value);
        }
    }
}

