/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java.internal.rules.basic;

import com.ibm.xtools.analysis.metrics.java.MetricsRule;
import com.ibm.xtools.analysis.metrics.java.data.ClassData;
import com.ibm.xtools.analysis.metrics.java.data.ElementData;
import com.ibm.xtools.analysis.metrics.java.data.MethodData;
import com.ibm.xtools.analysis.metrics.java.data.PackageData;
import com.ibm.xtools.analysis.metrics.java.data.ProjectData;
import com.ibm.xtools.analysis.metrics.java.data.util.MethodInfo;
import com.ibm.xtools.analysis.metrics.java.internal.util.NumberUtilities;
import org.eclipse.core.resources.IResource;

public class ParameterCount
extends MetricsRule {
    private static final String PARAM1 = "METHOD_MAXIMUM";

    @Override
    public void analyzeProject() {
        super.analyzeProject();
        ProjectData projectData = this.getManager().getProjectData();
        MethodInfo mi = projectData.getMethodInfo();
        this.generateResultsForASTNode((IResource)null, "0", projectData, mi.getTotalParameterCount());
    }

    @Override
    protected void analyzePackage(ProjectData projectData, PackageData packageData) {
        super.analyzePackage(projectData, packageData);
        MethodInfo pmi = packageData.getMethodInfo();
        this.generateResultsForASTNode((IResource)null, "0", projectData, packageData, pmi.getTotalParameterCount());
    }

    @Override
    protected void analyzeClass(ProjectData projectData, PackageData packageData, ClassData classData) {
        super.analyzeClass(projectData, packageData, classData);
        MethodInfo cmi = classData.getMethodInfo();
        this.generateResultsForASTNode(classData.getResource(), "0", projectData, packageData, classData, cmi.getTotalParameterCount());
    }

    @Override
    protected void analyzeMethod(ProjectData projectData, PackageData packageData, ClassData classData, MethodData methodData) {
        int methodMaximum = NumberUtilities.convertStringToInt(this, PARAM1);
        MethodInfo mi = methodData.getMethodInfo();
        int count = mi.getTotalParameterCount();
        this.generateResultsForASTNode(classData.getResource(), this.getMaximumSeverity(count, methodMaximum), projectData, packageData, classData, methodData, count, methodData.getNodeStart(), methodData.getNodeLength());
    }

    @Override
    public void setElementDataValue(ElementData data, double value) {
        data.getMethodInfo().setTotalParameterCount((int)Math.round(value));
    }
}

