/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java.internal.rules.basic;

import com.ibm.xtools.analysis.metrics.java.MetricsRule;
import com.ibm.xtools.analysis.metrics.java.data.ClassData;
import com.ibm.xtools.analysis.metrics.java.data.ContainerData;
import com.ibm.xtools.analysis.metrics.java.data.ElementData;
import com.ibm.xtools.analysis.metrics.java.data.PackageData;
import com.ibm.xtools.analysis.metrics.java.data.ProjectData;
import com.ibm.xtools.analysis.metrics.java.data.util.MethodInfo;
import com.ibm.xtools.analysis.metrics.java.internal.util.NumberUtilities;
import org.eclipse.core.resources.IResource;

public class MethodCount
extends MetricsRule {
    private static final String PARAM2 = "CLASS_MAXIMUM";
    private static final String PARAM3 = "PACKAGE_MAXIMUM";

    @Override
    public void analyzeProject() {
        super.analyzeProject();
        ProjectData projectData = this.getManager().getProjectData();
        MethodInfo mi = projectData.getMethodInfo();
        this.generateResultsForASTNode((IResource)null, "0", projectData, mi.getTotalMethodCount());
    }

    @Override
    protected void analyzePackage(ProjectData projectData, PackageData packageData) {
        super.analyzePackage(projectData, packageData);
        int packageMaximum = NumberUtilities.convertStringToInt(this, PARAM3);
        MethodInfo pmi = packageData.getMethodInfo();
        int methods = pmi.getTotalMethodCount();
        this.generateResultsForASTNode((IResource)null, this.getMaximumSeverity(methods, packageMaximum), projectData, packageData, methods);
    }

    @Override
    protected void analyzeClass(ProjectData projectData, PackageData packageData, ClassData classData) {
        super.analyzeClass(projectData, packageData, classData);
        int classMaximum = NumberUtilities.convertStringToInt(this, PARAM2);
        MethodInfo cmi = classData.getMethodInfo();
        int methods = cmi.getTotalMethodCount();
        this.generateResultsForASTNode(classData.getResource(), this.getMaximumSeverity(methods, classMaximum), projectData, packageData, classData, methods);
    }

    @Override
    public void setElementDataValue(ElementData data, double value) {
        if (data instanceof ContainerData) {
            ((ContainerData)data).getMethodInfo().setTotalMethodCount((int)Math.round(value));
        }
    }
}

