/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java.internal.rules.basic;

import com.ibm.xtools.analysis.metrics.java.MetricsRule;
import com.ibm.xtools.analysis.metrics.java.data.ClassData;
import com.ibm.xtools.analysis.metrics.java.data.ElementData;
import com.ibm.xtools.analysis.metrics.java.data.MethodData;
import com.ibm.xtools.analysis.metrics.java.data.PackageData;
import com.ibm.xtools.analysis.metrics.java.data.ProjectData;
import com.ibm.xtools.analysis.metrics.java.data.util.LineInfo;
import com.ibm.xtools.analysis.metrics.java.internal.util.NumberUtilities;
import org.eclipse.core.resources.IResource;

public class LOC
extends MetricsRule {
    private static final String PARAM1 = "METHOD_MAXIMUM";
    private static final String PARAM2 = "CLASS_MAXIMUM";
    private static final String PARAM3 = "PACKAGE_MAXIMUM";

    @Override
    public void analyzeProject() {
        super.analyzeProject();
        ProjectData projectData = this.getManager().getProjectData();
        LineInfo li = projectData.getLineInfo();
        this.generateResultsForASTNode((IResource)null, "0", projectData, li.getLinesWithCode());
    }

    @Override
    protected void analyzePackage(ProjectData projectData, PackageData packageData) {
        super.analyzePackage(projectData, packageData);
        int packageMaximum = NumberUtilities.convertStringToInt(this, PARAM3);
        LineInfo pli = packageData.getLineInfo();
        int lines = pli.getLinesWithCode();
        this.generateResultsForASTNode((IResource)null, this.getMaximumSeverity(lines, packageMaximum), projectData, packageData, lines);
    }

    @Override
    protected void analyzeClass(ProjectData projectData, PackageData packageData, ClassData classData) {
        super.analyzeClass(projectData, packageData, classData);
        int classMaximum = NumberUtilities.convertStringToInt(this, PARAM2);
        LineInfo cli = classData.getLineInfo();
        int lines = cli.getLinesWithCode();
        this.generateResultsForASTNode(classData.getResource(), this.getMaximumSeverity(lines, classMaximum), projectData, packageData, classData, lines);
    }

    @Override
    protected void analyzeMethod(ProjectData projectData, PackageData packageData, ClassData classData, MethodData methodData) {
        int methodMaximum = NumberUtilities.convertStringToInt(this, PARAM1);
        LineInfo mli = methodData.getLineInfo();
        int lines = mli.getLinesWithCode();
        this.generateResultsForASTNode(classData.getResource(), this.getMaximumSeverity(lines, methodMaximum), projectData, packageData, classData, methodData, lines, methodData.getNodeStart(), methodData.getNodeLength());
    }

    @Override
    public void setElementDataValue(ElementData data, double value) {
        data.getLineInfo().setLinesWithCode((int)Math.round(value));
    }
}

