/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java.internal.rules.basic;

import com.ibm.xtools.analysis.metrics.java.MetricsRule;
import com.ibm.xtools.analysis.metrics.java.data.ClassData;
import com.ibm.xtools.analysis.metrics.java.data.ElementData;
import com.ibm.xtools.analysis.metrics.java.data.MethodData;
import com.ibm.xtools.analysis.metrics.java.data.PackageData;
import com.ibm.xtools.analysis.metrics.java.data.ProjectData;
import com.ibm.xtools.analysis.metrics.java.data.util.LineInfo;
import com.ibm.xtools.analysis.metrics.java.data.util.MethodInfo;
import com.ibm.xtools.analysis.metrics.java.internal.util.NumberUtilities;
import org.eclipse.core.resources.IResource;

public class LCOM
extends MetricsRule {
    private static final String PARAM1 = "METHOD_MINIMUM";
    private static final String PARAM2 = "CLASS_MINIMUM";
    private static final String PARAM3 = "PACKAGE_MINIMUM";
    private static final String PARAM4 = "INCLUDE_INTERNAL";
    private static final String PARAM5 = "INCLUDE_PRIVATE";
    private static final String PARAM6 = "INCLUDE_PROTECTED";

    @Override
    public void analyzeProject() {
        super.analyzeProject();
        ProjectData projectData = this.getManager().getProjectData();
        LineInfo li = projectData.getLineInfo();
        this.generateResultsForASTNode((IResource)null, "0", projectData, li.getTotalComments());
    }

    @Override
    protected void analyzePackage(ProjectData projectData, PackageData packageData) {
        int packageMinimum = NumberUtilities.convertStringToInt(this, PARAM3);
        boolean includeInternal = Boolean.parseBoolean(this.getParameter(PARAM4).getValue());
        String name = packageData.getName();
        if (includeInternal || !includeInternal && name.indexOf(".internal") == -1) {
            super.analyzePackage(projectData, packageData);
            LineInfo pli = packageData.getLineInfo();
            int comments = pli.getTotalComments();
            this.generateResultsForASTNode((IResource)null, this.getMinimumSeverity(comments, packageMinimum), projectData, packageData, comments);
        }
    }

    @Override
    protected void analyzeClass(ProjectData projectData, PackageData packageData, ClassData classData) {
        super.analyzeClass(projectData, packageData, classData);
        int classMinimum = NumberUtilities.convertStringToInt(this, PARAM2);
        LineInfo cli = classData.getLineInfo();
        int comments = cli.getTotalComments();
        this.generateResultsForASTNode(classData.getResource(), this.getMinimumSeverity(comments, classMinimum), projectData, packageData, classData, comments);
    }

    @Override
    protected void analyzeMethod(ProjectData projectData, PackageData packageData, ClassData classData, MethodData methodData) {
        int methodMinimum = NumberUtilities.convertStringToInt(this, PARAM1);
        boolean includePrivate = Boolean.parseBoolean(this.getParameter(PARAM5).getValue());
        boolean includeProtected = Boolean.parseBoolean(this.getParameter(PARAM6).getValue());
        LineInfo mli = methodData.getLineInfo();
        MethodInfo mi = methodData.getMethodInfo();
        String mseverity = "0";
        int comments = mli.getTotalComments();
        if (comments < methodMinimum && (includePrivate || mi.getPrivateMethodCount() == 0 && mi.getPrivateConstructorCount() == 0) && (includeProtected || mi.getProtectedMethodCount() == 0 && mi.getProtectedConstructorCount() == 0)) {
            if (comments < methodMinimum / 4) {
                mseverity = "4";
            } else if (comments < methodMinimum / 2) {
                mseverity = "3";
            } else if (comments < methodMinimum) {
                mseverity = "2";
            } else if (comments < 5 * methodMinimum * 2) {
                mseverity = "1";
            }
        }
        this.generateResultsForASTNode(classData.getResource(), mseverity, projectData, packageData, classData, methodData, comments, methodData.getNodeStart(), methodData.getNodeLength());
    }

    @Override
    public void setElementDataValue(ElementData data, double value) {
        data.getLineInfo().setTotalComments((int)Math.round(value));
    }
}

