/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java.internal.rules.basic;

import com.ibm.xtools.analysis.metrics.java.MetricsRule;
import com.ibm.xtools.analysis.metrics.java.data.ElementData;
import com.ibm.xtools.analysis.metrics.java.data.PackageData;
import com.ibm.xtools.analysis.metrics.java.data.ProjectData;
import com.ibm.xtools.analysis.metrics.java.data.util.ClassInfo;
import com.ibm.xtools.analysis.metrics.java.internal.util.NumberUtilities;
import org.eclipse.core.resources.IResource;

public class InterfaceCount
extends MetricsRule {
    private static final String PARAM3 = "PACKAGE_MAXIMUM";

    @Override
    public void analyzeProject() {
        super.analyzeProject();
        ProjectData projectData = this.getManager().getProjectData();
        ClassInfo ci = projectData.getClassInfo();
        this.generateResultsForASTNode((IResource)null, "0", projectData, ci.getTotalInterfaceCount());
    }

    @Override
    protected void analyzePackage(ProjectData projectData, PackageData packageData) {
        super.analyzePackage(projectData, packageData);
        int packageMaximum = NumberUtilities.convertStringToInt(this, PARAM3);
        ClassInfo pci = packageData.getClassInfo();
        int totalInterfaces = pci.getTotalInterfaceCount();
        this.generateResultsForASTNode((IResource)null, this.getMaximumSeverity(totalInterfaces, packageMaximum), projectData, packageData, totalInterfaces);
    }

    @Override
    public void setElementDataValue(ElementData data, double value) {
        if (data instanceof ProjectData) {
            ((ProjectData)data).getClassInfo().setTotalInterfaceCount((int)Math.round(value));
        } else if (data instanceof PackageData) {
            ((PackageData)data).getClassInfo().setTotalInterfaceCount((int)Math.round(value));
        }
    }
}

