/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java.internal.rules.basic;

import com.ibm.xtools.analysis.metrics.java.MetricsRule;
import com.ibm.xtools.analysis.metrics.java.data.ClassData;
import com.ibm.xtools.analysis.metrics.java.data.ElementData;
import com.ibm.xtools.analysis.metrics.java.data.MethodData;
import com.ibm.xtools.analysis.metrics.java.data.PackageData;
import com.ibm.xtools.analysis.metrics.java.data.ProjectData;
import com.ibm.xtools.analysis.metrics.java.data.util.ClassInfo;
import com.ibm.xtools.analysis.metrics.java.data.util.LineInfo;
import com.ibm.xtools.analysis.metrics.java.data.util.MethodInfo;
import com.ibm.xtools.analysis.metrics.java.internal.util.NumberUtilities;

public class CommentCodeRatio
extends MetricsRule {
    private static final String PARAM1 = "METHOD_MINIMUM";
    private static final String PARAM2 = "CLASS_MINIMUM";
    private static final String PARAM3 = "PACKAGE_MINIMUM";
    private static final String PARAM4 = "INCLUDE_PROTECTED";
    private static final String PARAM5 = "INCLUDE_PRIVATE";
    private static final String PARAM6 = "INCLUDE_INTERNAL";

    @Override
    public void analyzeProject() {
        super.analyzeProject();
        ProjectData projectData = this.getManager().getProjectData();
        LineInfo li = projectData.getLineInfo();
        int lines = li.getLinesWithCode();
        double value = 0.0;
        if (lines > 0) {
            value = (double)li.getTotalComments() / (double)lines * 100.0;
        }
        this.generateResultsForASTNode(null, "0", projectData, value);
    }

    @Override
    protected void analyzePackage(ProjectData projectData, PackageData packageData) {
        double packageMinimum = NumberUtilities.convertStringToDouble(this, PARAM3);
        boolean includeInternal = Boolean.parseBoolean(this.getParameter(PARAM6).getValue());
        String name = packageData.getName();
        boolean isInternalPackage = name.indexOf(".internal") != -1;
        LineInfo pli = packageData.getLineInfo();
        int lines = pli.getLinesWithCode();
        double pvalue = 0.0;
        if (lines > 0) {
            pvalue = (double)pli.getTotalComments() / (double)lines * 100.0;
        }
        if (!isInternalPackage || isInternalPackage && includeInternal) {
            this.generateResultsForASTNode(null, this.getMinimumSeverity(pvalue, packageMinimum), projectData, packageData, pvalue);
            super.analyzePackage(projectData, packageData);
        }
    }

    @Override
    protected void analyzeClass(ProjectData projectData, PackageData packageData, ClassData classData) {
        boolean isProtectedClass;
        double classMinimum = NumberUtilities.convertStringToDouble(this, PARAM2);
        boolean includeProtected = Boolean.parseBoolean(this.getParameter(PARAM4).getValue());
        boolean includePrivate = Boolean.parseBoolean(this.getParameter(PARAM5).getValue());
        LineInfo cli = classData.getLineInfo();
        ClassInfo ci = classData.getClassInfo();
        int lines = cli.getLinesWithCode();
        double cvalue = 0.0;
        if (lines > 0) {
            cvalue = (double)cli.getTotalComments() / (double)lines * 100.0;
        }
        boolean isPrivateClass = ci.getPrivateClassCount() > 0;
        boolean bl = isProtectedClass = ci.getProtectedClassCount() > 0;
        if (isPrivateClass || !includePrivate || isProtectedClass || !includeProtected) {
            this.generateResultsForASTNode(classData.getResource(), this.getMinimumSeverity(cvalue, classMinimum), projectData, packageData, classData, cvalue);
            super.analyzeClass(projectData, packageData, classData);
        }
    }

    @Override
    protected void analyzeMethod(ProjectData projectData, PackageData packageData, ClassData classData, MethodData methodData) {
        boolean isProtectedMethod;
        double methodMinimum = NumberUtilities.convertStringToDouble(this, PARAM1);
        boolean includeProtected = Boolean.parseBoolean(this.getParameter(PARAM4).getValue());
        boolean includePrivate = Boolean.parseBoolean(this.getParameter(PARAM5).getValue());
        LineInfo mli = methodData.getLineInfo();
        MethodInfo mi = methodData.getMethodInfo();
        int lines = mli.getLinesWithCode();
        double value = 0.0;
        if (lines > 0) {
            value = (double)mli.getTotalComments() / (double)lines * 100.0;
        }
        boolean isPrivateMethod = mi.getPrivateMethodCount() > 0;
        boolean bl = isProtectedMethod = mi.getProtectedMethodCount() > 0;
        if (includePrivate && isPrivateMethod || !includePrivate || includeProtected && isProtectedMethod || !includeProtected) {
            this.generateResultsForASTNode(classData.getResource(), this.getMinimumSeverity(value, methodMinimum), projectData, packageData, classData, methodData, value, methodData.getNodeStart(), methodData.getNodeLength());
        }
    }

    @Override
    public void setElementDataValue(ElementData data, double value) {
    }
}

