/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java.internal.rules.basic;

import com.ibm.xtools.analysis.metrics.java.MetricsRule;
import com.ibm.xtools.analysis.metrics.java.data.ElementData;
import com.ibm.xtools.analysis.metrics.java.data.PackageData;
import com.ibm.xtools.analysis.metrics.java.data.ProjectData;
import com.ibm.xtools.analysis.metrics.java.data.util.MethodInfo;
import com.ibm.xtools.analysis.metrics.java.internal.util.NumberUtilities;

public class AvgParameterCount
extends MetricsRule {
    private static final String PARAM3 = "METHOD_MAXIMUM";

    @Override
    public void analyzeProject() {
        super.analyzeProject();
        ProjectData projectData = this.getManager().getProjectData();
        MethodInfo mi = projectData.getMethodInfo();
        int methods = mi.getTotalMethodCount();
        double average = 0.0;
        if (methods > 0) {
            average = (double)mi.getTotalParameterCount() / (double)methods;
        }
        this.generateResultsForASTNode(null, "0", projectData, average);
    }

    @Override
    protected void analyzePackage(ProjectData projectData, PackageData packageData) {
        super.analyzePackage(projectData, packageData);
        double packageMaximum = NumberUtilities.convertStringToDouble(this, PARAM3);
        MethodInfo pmi = packageData.getMethodInfo();
        int methods = pmi.getTotalMethodCount();
        double average = 0.0;
        if (methods > 0) {
            average = (double)pmi.getTotalParameterCount() / (double)methods;
        }
        this.generateResultsForASTNode(null, this.getMaximumSeverity(average, packageMaximum), projectData, packageData, average);
    }

    @Override
    public void setElementDataValue(ElementData data, double value) {
    }
}

