/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java.internal.rules.basic;

import com.ibm.xtools.analysis.metrics.java.MetricsRule;
import com.ibm.xtools.analysis.metrics.java.data.ClassData;
import com.ibm.xtools.analysis.metrics.java.data.ElementData;
import com.ibm.xtools.analysis.metrics.java.data.PackageData;
import com.ibm.xtools.analysis.metrics.java.data.ProjectData;
import com.ibm.xtools.analysis.metrics.java.data.util.LineInfo;
import com.ibm.xtools.analysis.metrics.java.data.util.MethodInfo;
import com.ibm.xtools.analysis.metrics.java.internal.util.NumberUtilities;

public class AvgLOC
extends MetricsRule {
    private static final String PARAM2 = "CLASS_MAXIMUM";
    private static final String PARAM3 = "PACKAGE_MAXIMUM";

    @Override
    public void analyzeProject() {
        super.analyzeProject();
        ProjectData projectData = this.getManager().getProjectData();
        LineInfo li = projectData.getLineInfo();
        MethodInfo mi = projectData.getMethodInfo();
        int constructorCount = mi.getTotalConstructorCount();
        int methodCount = mi.getTotalMethodCount();
        double average = 0.0;
        if (constructorCount + methodCount > 0) {
            average = (double)li.getMethodLinesWithCode() / (double)(constructorCount + methodCount);
        }
        this.generateResultsForASTNode(null, "0", projectData, average);
    }

    @Override
    protected void analyzePackage(ProjectData projectData, PackageData packageData) {
        super.analyzePackage(projectData, packageData);
        double packageMaximum = NumberUtilities.convertStringToDouble(this, PARAM3);
        LineInfo li = packageData.getLineInfo();
        MethodInfo pmi = packageData.getMethodInfo();
        int constructorCount = pmi.getTotalConstructorCount();
        int methodCount = pmi.getTotalMethodCount();
        double average = 0.0;
        if (constructorCount + methodCount > 0) {
            average = (double)li.getMethodLinesWithCode() / (double)(constructorCount + methodCount);
        }
        this.generateResultsForASTNode(null, this.getMaximumSeverity(average, packageMaximum), projectData, packageData, average);
    }

    @Override
    protected void analyzeClass(ProjectData projectData, PackageData packageData, ClassData classData) {
        super.analyzeClass(projectData, packageData, classData);
        double classMaximum = NumberUtilities.convertStringToDouble(this, PARAM2);
        LineInfo li = classData.getLineInfo();
        MethodInfo pmi = classData.getMethodInfo();
        int constructorCount = pmi.getTotalConstructorCount();
        int methodCount = pmi.getTotalMethodCount();
        double maverage = 0.0;
        if (constructorCount + methodCount > 0) {
            maverage = (double)li.getMethodLinesWithCode() / (double)(constructorCount + methodCount);
        }
        this.generateResultsForASTNode(classData.getResource(), this.getMaximumSeverity(maverage, classMaximum), projectData, packageData, classData, maverage);
    }

    @Override
    public void setElementDataValue(ElementData data, double value) {
    }
}

