/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java.internal.rules.basic;

import com.ibm.xtools.analysis.metrics.java.MetricsRule;
import com.ibm.xtools.analysis.metrics.java.data.ClassData;
import com.ibm.xtools.analysis.metrics.java.data.ElementData;
import com.ibm.xtools.analysis.metrics.java.data.PackageData;
import com.ibm.xtools.analysis.metrics.java.data.ProjectData;
import com.ibm.xtools.analysis.metrics.java.data.util.ClassInfo;
import com.ibm.xtools.analysis.metrics.java.data.util.LineInfo;
import com.ibm.xtools.analysis.metrics.java.internal.util.NumberUtilities;

public class AvgLCOM
extends MetricsRule {
    private static final String PARAM2 = "CLASS_MINIMUM";
    private static final String PARAM3 = "PACKAGE_MINIMUM";
    private static final String PARAM4 = "INCLUDE_INTERNAL";

    @Override
    public void analyzeProject() {
        super.analyzeProject();
        ProjectData projectData = this.getManager().getProjectData();
        LineInfo li = projectData.getLineInfo();
        int size = projectData.getPackageDataCollection().size();
        double maverage = 0.0;
        if (size > 0) {
            maverage = (double)li.getTotalComments() / (double)size;
        }
        this.generateResultsForASTNode(null, "0", projectData, maverage);
    }

    @Override
    protected void analyzePackage(ProjectData projectData, PackageData packageData) {
        double packageMinimum = NumberUtilities.convertStringToDouble(this, PARAM3);
        boolean includeInternal = Boolean.parseBoolean(this.getParameter(PARAM4).getValue());
        ClassInfo pci = packageData.getClassInfo();
        LineInfo pli = packageData.getLineInfo();
        String name = packageData.getName();
        boolean isInternalPackage = name.indexOf(".internal") != -1;
        int totalClasses = pci.getTotalClassCount();
        int totalinterfaces = pci.getTotalInterfaceCount();
        double average = 0.0;
        if (totalClasses + totalinterfaces > 0) {
            average = (double)pli.getTotalComments() / (double)(totalClasses + totalinterfaces);
        }
        if (!isInternalPackage || isInternalPackage && includeInternal) {
            this.generateResultsForASTNode(null, this.getMinimumSeverity(average, packageMinimum), projectData, packageData, average);
            super.analyzePackage(projectData, packageData);
        }
    }

    @Override
    protected void analyzeClass(ProjectData projectData, PackageData packageData, ClassData classData) {
        super.analyzeClass(projectData, packageData, classData);
        double classMinimum = NumberUtilities.convertStringToDouble(this, PARAM2);
        LineInfo cli = classData.getLineInfo();
        int comments = cli.getTotalComments();
        this.generateResultsForASTNode(classData.getResource(), this.getMinimumSeverity((double)comments, classMinimum), projectData, packageData, classData, comments);
    }

    @Override
    public void setElementDataValue(ElementData data, double value) {
    }
}

