/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java.internal.rules.basic;

import com.ibm.xtools.analysis.metrics.java.MetricsRule;
import com.ibm.xtools.analysis.metrics.java.data.ElementData;
import com.ibm.xtools.analysis.metrics.java.data.PackageData;
import com.ibm.xtools.analysis.metrics.java.data.ProjectData;
import com.ibm.xtools.analysis.metrics.java.data.util.ClassInfo;
import com.ibm.xtools.analysis.metrics.java.data.util.MethodInfo;
import com.ibm.xtools.analysis.metrics.java.internal.util.NumberUtilities;

public class AvgConstructorCount
extends MetricsRule {
    private static final String PARAM3 = "PACKAGE_MAXIMUM";

    @Override
    public void analyzeProject() {
        super.analyzeProject();
        ProjectData projectData = this.getManager().getProjectData();
        ClassInfo ci = projectData.getClassInfo();
        MethodInfo mi = projectData.getMethodInfo();
        int totalClasses = ci.getTotalClassCount();
        double average = 0.0;
        if (totalClasses > 0) {
            average = (double)mi.getTotalConstructorCount() / (double)totalClasses;
        }
        this.generateResultsForASTNode(null, "0", projectData, average);
    }

    @Override
    protected void analyzePackage(ProjectData projectData, PackageData packageData) {
        super.analyzePackage(projectData, packageData);
        double packageMaximum = NumberUtilities.convertStringToDouble(this, PARAM3);
        ClassInfo pci = packageData.getClassInfo();
        MethodInfo pmi = packageData.getMethodInfo();
        int totalClasses = pci.getTotalClassCount();
        double average = 0.0;
        if (totalClasses > 0) {
            average = (double)pmi.getTotalConstructorCount() / (double)totalClasses;
        }
        this.generateResultsForASTNode(null, this.getMaximumSeverity(average, packageMaximum), projectData, packageData, average);
    }

    @Override
    public void setElementDataValue(ElementData data, double value) {
    }
}

