/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java.internal.rules.basic;

import com.ibm.xtools.analysis.metrics.java.MetricsRule;
import com.ibm.xtools.analysis.metrics.java.data.ElementData;
import com.ibm.xtools.analysis.metrics.java.data.PackageData;
import com.ibm.xtools.analysis.metrics.java.data.ProjectData;
import com.ibm.xtools.analysis.metrics.java.data.util.AttributeInfo;
import com.ibm.xtools.analysis.metrics.java.data.util.ClassInfo;
import com.ibm.xtools.analysis.metrics.java.internal.util.NumberUtilities;

public class AvgAttributeCount
extends MetricsRule {
    private static final String PARAM3 = "PACKAGE_MAXIMUM";
    private static final String PARAM4 = "INCLUDE_CONSTANT";

    @Override
    public void analyzeProject() {
        super.analyzeProject();
        ProjectData projectData = this.getManager().getProjectData();
        boolean includeConstants = Boolean.parseBoolean(this.getParameter(PARAM4).getValue());
        ClassInfo ci = projectData.getClassInfo();
        AttributeInfo ai = projectData.getAttributeInfo();
        int count = ai.getTotalAttributeCount();
        if (!includeConstants) {
            count -= ai.getFinalAttributeCount();
        }
        int totalClasses = ci.getTotalClassCount();
        int totalinterfaces = ci.getTotalInterfaceCount();
        double average = 0.0;
        if (totalClasses + totalinterfaces > 0) {
            average = (double)count / (double)(totalClasses + totalinterfaces);
        }
        this.generateResultsForASTNode(null, "0", projectData, average);
    }

    @Override
    protected void analyzePackage(ProjectData projectData, PackageData packageData) {
        super.analyzePackage(projectData, packageData);
        double packageMaximum = NumberUtilities.convertStringToDouble(this, PARAM3);
        boolean includeConstants = Boolean.parseBoolean(this.getParameter(PARAM4).getValue());
        ClassInfo pci = packageData.getClassInfo();
        AttributeInfo pai = packageData.getAttributeInfo();
        int count = pai.getTotalAttributeCount();
        if (!includeConstants) {
            count -= pai.getFinalAttributeCount();
        }
        int totalClasses = pci.getTotalClassCount();
        int totalinterfaces = pci.getTotalInterfaceCount();
        double average = 0.0;
        if (totalClasses + totalinterfaces > 0) {
            average = (double)count / (double)(totalClasses + totalinterfaces);
        }
        this.generateResultsForASTNode(null, this.getMaximumSeverity(average, packageMaximum), projectData, packageData, average);
    }

    @Override
    public void setElementDataValue(ElementData data, double value) {
    }
}

