/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java.internal.rules.basic;

import com.ibm.xtools.analysis.metrics.java.MetricsRule;
import com.ibm.xtools.analysis.metrics.java.data.ClassData;
import com.ibm.xtools.analysis.metrics.java.data.ContainerData;
import com.ibm.xtools.analysis.metrics.java.data.ElementData;
import com.ibm.xtools.analysis.metrics.java.data.PackageData;
import com.ibm.xtools.analysis.metrics.java.data.ProjectData;
import com.ibm.xtools.analysis.metrics.java.data.util.AttributeInfo;
import com.ibm.xtools.analysis.metrics.java.internal.util.NumberUtilities;
import org.eclipse.core.resources.IResource;

public class AttributeCount
extends MetricsRule {
    private static final String PARAM2 = "CLASS_MAXIMUM";
    private static final String PARAM3 = "PACKAGE_MAXIMUM";
    private static final String PARAM4 = "INCLUDE_CONSTANT";

    @Override
    public void analyzeProject() {
        super.analyzeProject();
        ProjectData projectData = this.getManager().getProjectData();
        boolean includeConstants = Boolean.parseBoolean(this.getParameter(PARAM4).getValue());
        AttributeInfo ai = projectData.getAttributeInfo();
        int count = ai.getTotalAttributeCount();
        if (!includeConstants) {
            count -= ai.getFinalAttributeCount();
        }
        this.generateResultsForASTNode((IResource)null, "0", projectData, count);
    }

    @Override
    protected void analyzePackage(ProjectData projectData, PackageData packageData) {
        super.analyzePackage(projectData, packageData);
        int packageMaximum = NumberUtilities.convertStringToInt(this, PARAM3);
        boolean includeConstants = Boolean.parseBoolean(this.getParameter(PARAM4).getValue());
        AttributeInfo pai = packageData.getAttributeInfo();
        int count = pai.getTotalAttributeCount();
        if (!includeConstants) {
            count -= pai.getFinalAttributeCount();
        }
        this.generateResultsForASTNode((IResource)null, this.getMaximumSeverity(count, packageMaximum), projectData, packageData, count);
    }

    @Override
    protected void analyzeClass(ProjectData projectData, PackageData packageData, ClassData classData) {
        super.analyzeClass(projectData, packageData, classData);
        int classMaximum = NumberUtilities.convertStringToInt(this, PARAM2);
        boolean includeConstants = Boolean.parseBoolean(this.getParameter(PARAM4).getValue());
        AttributeInfo cai = classData.getAttributeInfo();
        int count = cai.getTotalAttributeCount();
        if (!includeConstants) {
            count -= cai.getFinalAttributeCount();
        }
        this.generateResultsForASTNode(classData.getResource(), this.getMaximumSeverity(count, classMaximum), projectData, packageData, classData, count);
    }

    @Override
    public void setElementDataValue(ElementData data, double value) {
        if (data instanceof ContainerData) {
            ((ContainerData)data).getAttributeInfo().setTotalAttributeCount((int)Math.round(value));
        }
    }
}

