/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java.internal.model;

import com.ibm.rsaz.analysis.core.element.AbstractAnalysisElement;
import com.ibm.rsaz.analysis.core.history.AnalysisHistory;
import com.ibm.rsaz.analysis.core.result.AbstractAnalysisResult;
import com.ibm.xtools.analysis.metrics.java.MetricsProvider;
import com.ibm.xtools.analysis.metrics.java.MetricsResult;
import com.ibm.xtools.analysis.metrics.java.MetricsRule;
import com.ibm.xtools.analysis.metrics.java.data.ClassData;
import com.ibm.xtools.analysis.metrics.java.data.MethodData;
import com.ibm.xtools.analysis.metrics.java.data.PackageData;
import com.ibm.xtools.analysis.metrics.java.data.ProjectData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class MetricsResultByResourceModel {
    private MetricsProvider provider;
    private AnalysisHistory history;
    private List<MetricsRule> ruleList = null;
    private ProjectData projectData = null;

    public MetricsResultByResourceModel(MetricsProvider providerValue, AnalysisHistory historyValue) {
        this.provider = providerValue;
        this.history = historyValue;
        this.update();
    }

    public void update() {
        this.ruleList = new ArrayList<MetricsRule>(0);
        Collection elements = this.history.getSelectAnalysisElements();
        for (AbstractAnalysisElement element : elements) {
            Collection results;
            Iterator it2;
            if (!(element instanceof MetricsRule)) continue;
            MetricsRule rule = (MetricsRule)element;
            this.ruleList.add(rule);
            if (this.projectData != null || !(it2 = (results = this.history.getResults((AbstractAnalysisElement)rule)).iterator()).hasNext() || this.projectData != null) continue;
            MetricsResult result = (MetricsResult)((Object)it2.next());
            this.projectData = result.getProjectData();
        }
    }

    public MetricsResult getResult(int ruleIndex, PackageData packageData) {
        MetricsRule rule = this.ruleList.get(ruleIndex);
        Collection ruleResults = this.history.getResults((AbstractAnalysisElement)rule);
        for (AbstractAnalysisResult element : ruleResults) {
            if (element == null) continue;
            MetricsResult result = (MetricsResult)element;
            MethodData mData = result.getMethodData();
            ClassData cData = result.getClassData();
            PackageData pData = result.getPackageData();
            if (mData != null || cData != null || pData == null || !pData.equals(packageData)) continue;
            return result;
        }
        return null;
    }

    public MetricsResult getResult(int ruleIndex, ClassData classData) {
        MetricsRule rule = this.ruleList.get(ruleIndex);
        Collection ruleResults = this.history.getResults((AbstractAnalysisElement)rule);
        for (AbstractAnalysisResult element : ruleResults) {
            if (element == null) continue;
            MetricsResult result = (MetricsResult)element;
            MethodData mData = result.getMethodData();
            ClassData cData = result.getClassData();
            if (mData != null || cData == null || !cData.equals(classData)) continue;
            return result;
        }
        return null;
    }

    public MetricsResult getResult(int ruleIndex, MethodData methodData) {
        MetricsRule rule = this.ruleList.get(ruleIndex);
        Collection ruleResults = this.history.getResults((AbstractAnalysisElement)rule);
        for (AbstractAnalysisResult element : ruleResults) {
            MetricsResult result;
            MethodData mData;
            if (element == null || (mData = (result = (MetricsResult)element).getMethodData()) == null || !mData.equals(methodData)) continue;
            return result;
        }
        return null;
    }

    public MetricsResult getResult(ClassData classData) {
        for (MetricsRule rule : this.ruleList) {
            Collection ruleResults = this.history.getResults((AbstractAnalysisElement)rule);
            for (AbstractAnalysisResult element : ruleResults) {
                MetricsResult result;
                ClassData cData;
                if (element == null || (cData = (result = (MetricsResult)element).getClassData()) == null || !cData.equals(classData)) continue;
                return result;
            }
        }
        return null;
    }

    public MetricsResult getResult(MethodData methodData) {
        for (MetricsRule rule : this.ruleList) {
            Collection ruleResults = this.history.getResults((AbstractAnalysisElement)rule);
            for (AbstractAnalysisResult element : ruleResults) {
                MetricsResult result;
                MethodData mData;
                if (element == null || (mData = (result = (MetricsResult)element).getMethodData()) == null || !mData.equals(methodData)) continue;
                return result;
            }
        }
        return null;
    }

    public AnalysisHistory getHistory() {
        return this.history;
    }

    public MetricsProvider getProvider() {
        return this.provider;
    }

    public List<MetricsRule> getRuleList() {
        return this.ruleList;
    }

    public Collection<PackageData> getPackageData() {
        if (this.projectData == null) {
            return Collections.emptySet();
        }
        return this.projectData.getPackageDataCollection();
    }
}

