/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java.internal.measure.inheritance;

import com.ibm.xtools.analysis.metrics.java.AbstractMeasurement;
import com.ibm.xtools.analysis.metrics.java.MetricsResource;
import com.ibm.xtools.analysis.metrics.java.data.ClassData;
import com.ibm.xtools.analysis.metrics.java.data.PackageData;
import com.ibm.xtools.analysis.metrics.java.data.ProjectData;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class InheritanceInformation
extends AbstractMeasurement {
    @Override
    public void projectMeasure(ProjectData projectData, PackageData packageData) {
        projectData.getClassInfo().addInheritanceDepth(packageData.getClassInfo().getInheritanceDepth());
    }

    @Override
    public void packageMeasure(MetricsResource resource, PackageData packageData, ClassData classData) {
        packageData.getClassInfo().addInheritanceDepth(classData.getClassInfo().getInheritanceDepth());
    }

    @Override
    public void classMeasure(MetricsResource resource, ClassData classData, TypeDeclaration td) {
        List<ITypeBinding> list;
        ITypeBinding binding = td.resolveBinding();
        if (binding != null && (list = InheritanceInformation.getSuperTypes(binding)) != null) {
            classData.getClassInfo().addInheritanceDepth(list.size());
        }
    }

    public static List<ITypeBinding> getSuperTypes(ITypeBinding type) {
        ArrayList<ITypeBinding> toReturn = new ArrayList<ITypeBinding>(10);
        if (!type.isClass()) {
            return toReturn;
        }
        ITypeBinding superType = type.getSuperclass();
        while (superType != null) {
            toReturn.add(superType);
            superType = superType.getSuperclass();
        }
        return toReturn;
    }
}

