/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java.internal.measure.halstead;

import com.ibm.xtools.analysis.metrics.java.AbstractMeasurement;
import com.ibm.xtools.analysis.metrics.java.MetricsResource;
import com.ibm.xtools.analysis.metrics.java.data.ClassData;
import com.ibm.xtools.analysis.metrics.java.data.MethodData;
import com.ibm.xtools.analysis.metrics.java.data.PackageData;
import com.ibm.xtools.analysis.metrics.java.data.ProjectData;
import com.ibm.xtools.analysis.metrics.java.data.util.HalsteadInfo;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class HalsteadInformation
extends AbstractMeasurement {
    private static final int OPERATORS_ARRAY_SIZE = 37;
    private static final Object[] REGULAR_OPERATORS;
    private static final Set<String> LITERAL_OPERATORS;
    private static final Character TILDE;
    private static final Character NEGATION;
    private static final Character MODULUS;
    private static final Character DIVIDE_OR_FORWARDSLASH;
    private static final Character MULTIPLY_OR_STAR;
    private static final Character SUBTRACTION;
    private static final Character ADDITION;
    private static final Character GREATER_THAN;
    private static final Character LESS_THAN;
    private static final Character BITWISE_AND;
    private static final Character BITWISE_OR;
    private static final Character BITWISE_XOR;
    private static final Character TERNARY;
    private static final Character TERNARY_COLON;
    private static final Character ASSIGNMENT;
    private static final String INSTANCEOF;
    private static final Character DOT;
    private static final Character SEMICOLON;
    private static final Character OPEN_SQUARE_BRACKET;
    private static final Character OPEN_PARENTHESIS;
    private static final Character OPEN_CURLY_BRACKET;
    private static final Character COMMA;
    private static final Character QUOTE_CHARACTER;
    private static final Character ESCAPE_CHARACTER;
    private static final String PACKAGE;
    private static final String IMPORT;
    private static final String CATCH;
    private static final String THROW;
    private static final String TRY;
    private static final String WHILE;
    private static final String SWITCH;
    private static final String RETURN;
    private static final String FOR;
    private static final String DO;
    private static final String CONTINUE = "continue.intern()";
    private static final String CASE;
    private static final String BREAK;
    private static final String ASSERT;
    private static final String IF_STMT;
    private static final String ELSE_STMT;
    private static final String DEFAULT;
    private static final String ENUM;
    private static final String FINALLY;
    private static final String NEW;
    private static final String SEMICOLON_STRING;
    private static final int[] LITERAL_TYPES;
    private static final int[] NON_RESERVED_NAMES;

    static {
        TILDE = Character.valueOf('~');
        NEGATION = Character.valueOf('!');
        MODULUS = Character.valueOf('%');
        DIVIDE_OR_FORWARDSLASH = Character.valueOf('/');
        MULTIPLY_OR_STAR = Character.valueOf('*');
        SUBTRACTION = Character.valueOf('-');
        ADDITION = Character.valueOf('+');
        GREATER_THAN = Character.valueOf('>');
        LESS_THAN = Character.valueOf('<');
        BITWISE_AND = Character.valueOf('&');
        BITWISE_OR = Character.valueOf('|');
        BITWISE_XOR = Character.valueOf('^');
        TERNARY = Character.valueOf('?');
        TERNARY_COLON = Character.valueOf(':');
        ASSIGNMENT = Character.valueOf('=');
        INSTANCEOF = "instanceof".intern();
        DOT = Character.valueOf('.');
        SEMICOLON = Character.valueOf(';');
        OPEN_SQUARE_BRACKET = Character.valueOf('[');
        OPEN_PARENTHESIS = Character.valueOf('(');
        OPEN_CURLY_BRACKET = Character.valueOf('{');
        COMMA = Character.valueOf(',');
        QUOTE_CHARACTER = Character.valueOf('\"');
        ESCAPE_CHARACTER = Character.valueOf('\\');
        PACKAGE = "package".intern();
        IMPORT = "import".intern();
        CATCH = "catch".intern();
        THROW = "throw".intern();
        TRY = "try".intern();
        WHILE = "while".intern();
        SWITCH = "switch".intern();
        RETURN = "return".intern();
        FOR = "for".intern();
        DO = "do".intern();
        CASE = "case".intern();
        BREAK = "break".intern();
        ASSERT = "assert".intern();
        IF_STMT = "if".intern();
        ELSE_STMT = "else".intern();
        DEFAULT = "default".intern();
        ENUM = "enum".intern();
        FINALLY = "finally".intern();
        NEW = "new".intern();
        SEMICOLON_STRING = ";".intern();
        LITERAL_TYPES = new int[]{42, 9, 13, 33, 34, 45, 57};
        NON_RESERVED_NAMES = new int[]{32, 48, 17};
        REGULAR_OPERATORS = new Object[37];
        LITERAL_OPERATORS = new HashSet<String>(32);
        LITERAL_OPERATORS.add(ASSERT);
        LITERAL_OPERATORS.add(BREAK);
        LITERAL_OPERATORS.add(CASE);
        LITERAL_OPERATORS.add(CATCH);
        LITERAL_OPERATORS.add(CONTINUE);
        LITERAL_OPERATORS.add(DEFAULT);
        LITERAL_OPERATORS.add(DO);
        LITERAL_OPERATORS.add(ELSE_STMT);
        LITERAL_OPERATORS.add(ENUM);
        LITERAL_OPERATORS.add(FINALLY);
        LITERAL_OPERATORS.add(FOR);
        LITERAL_OPERATORS.add(IF_STMT);
        LITERAL_OPERATORS.add(INSTANCEOF);
        LITERAL_OPERATORS.add(NEW);
        LITERAL_OPERATORS.add(RETURN);
        LITERAL_OPERATORS.add(SWITCH);
        LITERAL_OPERATORS.add(THROW);
        LITERAL_OPERATORS.add(TRY);
        LITERAL_OPERATORS.add(WHILE);
        HashMap<Character, Map> temporaryHash = null;
        HalsteadInformation.REGULAR_OPERATORS[HalsteadInformation.hashValue((Character)HalsteadInformation.OPEN_PARENTHESIS)] = Collections.EMPTY_MAP;
        HalsteadInformation.REGULAR_OPERATORS[HalsteadInformation.hashValue((Character)HalsteadInformation.OPEN_CURLY_BRACKET)] = Collections.EMPTY_MAP;
        HalsteadInformation.REGULAR_OPERATORS[HalsteadInformation.hashValue((Character)HalsteadInformation.SEMICOLON)] = Collections.EMPTY_MAP;
        HalsteadInformation.REGULAR_OPERATORS[HalsteadInformation.hashValue((Character)HalsteadInformation.OPEN_SQUARE_BRACKET)] = Collections.EMPTY_MAP;
        HalsteadInformation.REGULAR_OPERATORS[HalsteadInformation.hashValue((Character)HalsteadInformation.DOT)] = Collections.EMPTY_MAP;
        HalsteadInformation.REGULAR_OPERATORS[HalsteadInformation.hashValue((Character)HalsteadInformation.COMMA)] = Collections.EMPTY_MAP;
        temporaryHash = new HashMap<Character, Map>(1);
        temporaryHash.put(ASSIGNMENT, Collections.EMPTY_MAP);
        HalsteadInformation.REGULAR_OPERATORS[HalsteadInformation.hashValue((Character)HalsteadInformation.NEGATION)] = temporaryHash;
        temporaryHash = new HashMap(1);
        temporaryHash.put(ASSIGNMENT, Collections.EMPTY_MAP);
        HalsteadInformation.REGULAR_OPERATORS[HalsteadInformation.hashValue((Character)HalsteadInformation.MODULUS)] = temporaryHash;
        temporaryHash = new HashMap(1);
        temporaryHash.put(ASSIGNMENT, Collections.EMPTY_MAP);
        HalsteadInformation.REGULAR_OPERATORS[HalsteadInformation.hashValue((Character)HalsteadInformation.DIVIDE_OR_FORWARDSLASH)] = temporaryHash;
        temporaryHash = new HashMap(1);
        temporaryHash.put(ASSIGNMENT, Collections.EMPTY_MAP);
        HalsteadInformation.REGULAR_OPERATORS[HalsteadInformation.hashValue((Character)HalsteadInformation.MULTIPLY_OR_STAR)] = temporaryHash;
        temporaryHash = new HashMap(8);
        temporaryHash.put(ASSIGNMENT, Collections.EMPTY_MAP);
        temporaryHash.put(SUBTRACTION, Collections.EMPTY_MAP);
        temporaryHash.put(GREATER_THAN, Collections.EMPTY_MAP);
        HalsteadInformation.REGULAR_OPERATORS[HalsteadInformation.hashValue((Character)HalsteadInformation.SUBTRACTION)] = temporaryHash;
        temporaryHash = new HashMap(2);
        temporaryHash.put(ASSIGNMENT, Collections.EMPTY_MAP);
        temporaryHash.put(ADDITION, Collections.EMPTY_MAP);
        HalsteadInformation.REGULAR_OPERATORS[HalsteadInformation.hashValue((Character)HalsteadInformation.ADDITION)] = temporaryHash;
        HalsteadInformation.REGULAR_OPERATORS[HalsteadInformation.hashValue((Character)HalsteadInformation.TILDE)] = temporaryHash;
        temporaryHash = new HashMap(2);
        HashMap<Character, Map> thirdLevelHash = new HashMap<Character, Map>(1);
        thirdLevelHash.put(ASSIGNMENT, Collections.EMPTY_MAP);
        HashMap<Character, Map> secondLevelHash = new HashMap<Character, Map>(2);
        secondLevelHash.put(GREATER_THAN, thirdLevelHash);
        secondLevelHash.put(ASSIGNMENT, Collections.EMPTY_MAP);
        temporaryHash.put(GREATER_THAN, secondLevelHash);
        temporaryHash.put(ASSIGNMENT, Collections.EMPTY_MAP);
        HalsteadInformation.REGULAR_OPERATORS[HalsteadInformation.hashValue((Character)HalsteadInformation.GREATER_THAN)] = temporaryHash;
        temporaryHash = new HashMap(1);
        secondLevelHash = new HashMap(1);
        secondLevelHash.put(ASSIGNMENT, Collections.EMPTY_MAP);
        temporaryHash.put(LESS_THAN, secondLevelHash);
        temporaryHash.put(ASSIGNMENT, Collections.EMPTY_MAP);
        HalsteadInformation.REGULAR_OPERATORS[HalsteadInformation.hashValue((Character)HalsteadInformation.LESS_THAN)] = temporaryHash;
        temporaryHash = new HashMap(2);
        temporaryHash.put(BITWISE_AND, Collections.EMPTY_MAP);
        temporaryHash.put(ASSIGNMENT, Collections.EMPTY_MAP);
        HalsteadInformation.REGULAR_OPERATORS[HalsteadInformation.hashValue((Character)HalsteadInformation.BITWISE_AND)] = temporaryHash;
        temporaryHash = new HashMap(2);
        temporaryHash.put(BITWISE_OR, Collections.EMPTY_MAP);
        temporaryHash.put(ASSIGNMENT, Collections.EMPTY_MAP);
        HalsteadInformation.REGULAR_OPERATORS[HalsteadInformation.hashValue((Character)HalsteadInformation.BITWISE_OR)] = temporaryHash;
        temporaryHash = new HashMap(1);
        temporaryHash.put(ASSIGNMENT, Collections.EMPTY_MAP);
        HalsteadInformation.REGULAR_OPERATORS[HalsteadInformation.hashValue((Character)HalsteadInformation.BITWISE_XOR)] = temporaryHash;
        HalsteadInformation.REGULAR_OPERATORS[HalsteadInformation.hashValue((Character)HalsteadInformation.TERNARY)] = Collections.EMPTY_MAP;
        temporaryHash = new HashMap(1);
        temporaryHash.put(TERNARY_COLON, Collections.EMPTY_MAP);
        HalsteadInformation.REGULAR_OPERATORS[HalsteadInformation.hashValue((Character)HalsteadInformation.TERNARY_COLON)] = temporaryHash;
        temporaryHash = new HashMap(1);
        temporaryHash.put(ASSIGNMENT, Collections.EMPTY_MAP);
        HalsteadInformation.REGULAR_OPERATORS[HalsteadInformation.hashValue((Character)HalsteadInformation.ASSIGNMENT)] = temporaryHash;
    }

    private static int hashValue(Character aChar) {
        return aChar.charValue() % 37;
    }

    @Override
    public void projectMeasure(ProjectData projectData, PackageData packageData) {
        double difficulty;
        HalsteadInfo info = projectData.getHalsteadInfo();
        HalsteadInfo pinfo = packageData.getHalsteadInfo();
        int operatorCount = info.getOperatorCount();
        int uniqueOperatorCount = info.getUniqueOperatorCount();
        int operandCount = info.getOperandCount();
        int uniqueOperandCount = info.getUniqueOperandCount();
        int pUniqueOperatorCount = pinfo.getUniqueOperatorCount();
        int pUniqueOperandCount = pinfo.getUniqueOperandCount();
        info.setOperandCount(operandCount += pinfo.getOperandCount());
        info.setOperatorCount(operatorCount += pinfo.getOperatorCount());
        if (uniqueOperatorCount < pUniqueOperatorCount) {
            info.setUniqueOperatorCount(pUniqueOperatorCount);
            uniqueOperatorCount = pUniqueOperatorCount;
        }
        if (uniqueOperandCount < pUniqueOperandCount) {
            info.setUniqueOperandCount(pUniqueOperandCount);
            uniqueOperandCount = pUniqueOperandCount;
        }
        info.setProgramLength(info.getOperatorCount() + operandCount);
        info.setProgramVocabulary(uniqueOperatorCount + uniqueOperandCount);
        info.setProgramVolume((double)info.getProgramLength() * this.log2(info.getProgramVocabulary()));
        if (operandCount > 0) {
            info.setDifficulty((double)uniqueOperatorCount / 2.0 * (double)operandCount / (double)uniqueOperandCount);
        }
        if ((difficulty = info.getDifficulty()) != 0.0) {
            info.setProgramLevel(1.0 / difficulty);
        }
        info.setImplementationEffort(info.getProgramVolume() * difficulty);
        info.addImplementationTime(pinfo.getImplementationTime());
        info.setNumberOfDeliveredBugs(Math.pow(info.getImplementationEffort(), 0.6666666865348816) / 3000.0);
    }

    @Override
    public void packageMeasure(MetricsResource resource, PackageData packageData, ClassData classData) {
        double difficulty;
        HalsteadInfo info = packageData.getHalsteadInfo();
        HalsteadInfo cinfo = classData.getHalsteadInfo();
        int operatorCount = info.getOperatorCount();
        Set<String> uniqueOperatorSet = info.getUniqueOperatorSet();
        int operandCount = info.getOperandCount();
        Set<String> uniqueOperandSet = info.getUniqueOperandSet();
        uniqueOperatorSet.addAll(cinfo.getUniqueOperatorSet());
        operatorCount += cinfo.getOperatorCount();
        uniqueOperandSet.addAll(cinfo.getUniqueOperandSet());
        int uniqueOperatorCount = uniqueOperatorSet.size();
        int uniqueOperandCount = uniqueOperandSet.size();
        info.setOperandCount(operandCount += cinfo.getOperandCount());
        info.setUniqueOperandCount(uniqueOperandSet.size());
        info.setOperatorCount(operatorCount);
        info.setUniqueOperatorCount(uniqueOperatorCount);
        info.setProgramLength(info.getOperatorCount() + operandCount);
        info.setProgramVocabulary(uniqueOperatorCount + uniqueOperandCount);
        info.setProgramVolume((double)info.getProgramLength() * this.log2(info.getProgramVocabulary()));
        if (operandCount > 0) {
            info.setDifficulty((double)uniqueOperatorCount / 2.0 * (double)operandCount / (double)uniqueOperandCount);
        }
        if ((difficulty = info.getDifficulty()) != 0.0) {
            info.setProgramLevel(1.0 / difficulty);
        }
        double effort = info.getProgramVolume() * difficulty;
        info.setImplementationEffort(effort);
        info.addImplementationTime(cinfo.getImplementationTime());
        info.setNumberOfDeliveredBugs(Math.pow(effort, 0.6666666865348816) / 3000.0);
    }

    @Override
    public void classMeasure(MetricsResource resource, ClassData classData, TypeDeclaration td) {
        double difficulty;
        HalsteadInfo info = classData.getHalsteadInfo();
        HashSet<String> uniqueOperators = new HashSet<String>(4);
        HashSet<String> uniqueOperands = new HashSet<String>(4);
        int totalOperators = this.determineOperators((ASTNode)td, uniqueOperators);
        int totalOperands = this.determineOperands(resource, (ASTNode)td, uniqueOperands);
        int packages = resource.countTypedNodes(td.getParent(), 35, true);
        int imports = resource.countTypedNodes(td.getParent(), 26, true);
        if (packages > 0) {
            uniqueOperators.add(PACKAGE);
            uniqueOperators.add(SEMICOLON_STRING);
            totalOperators += packages * 2;
        }
        if (imports > 0) {
            uniqueOperators.add(IMPORT);
            uniqueOperators.add(SEMICOLON_STRING);
            totalOperators += imports * 2;
        }
        int uniqueOperatorCount = uniqueOperators.size();
        int uniqueOperandCount = uniqueOperands.size();
        info.setOperatorCount(totalOperators);
        info.setUniqueOperatorCount(uniqueOperatorCount);
        info.setUniqueOperatorSet(uniqueOperators);
        info.setOperandCount(totalOperands);
        info.setUniqueOperandCount(uniqueOperandCount);
        info.setUniqueOperandSet(uniqueOperands);
        info.setProgramLength(info.getOperatorCount() + totalOperands);
        info.setProgramVocabulary(uniqueOperatorCount + uniqueOperandCount);
        info.setProgramVolume((double)info.getProgramLength() * this.log2(info.getProgramVocabulary()));
        if (totalOperands > 0) {
            info.setDifficulty((double)uniqueOperatorCount / 2.0 * (double)totalOperands / (double)uniqueOperandCount);
        }
        if ((difficulty = info.getDifficulty()) != 0.0) {
            info.setProgramLevel(1.0 / difficulty);
        }
        double effort = info.getProgramVolume() * difficulty;
        info.setImplementationEffort(effort);
        info.setImplementationTime(effort / 64800.0);
        info.setNumberOfDeliveredBugs(Math.pow(effort, 0.6666666865348816) / 3000.0);
    }

    @Override
    public void methodMeasure(MetricsResource resource, MethodData methodData, MethodDeclaration md) {
        double difficulty;
        HalsteadInfo info = methodData.getHalsteadInfo();
        HashSet<String> uniqueOperands = new HashSet<String>(4);
        HashSet<String> uniqueOperators = new HashSet<String>(4);
        int totalOperators = this.determineOperators((ASTNode)md, uniqueOperators);
        info.addOperatorCount(totalOperators);
        info.addUniqueOperatorCount(uniqueOperators.size());
        int totalOperands = this.determineOperands(resource, (ASTNode)md, uniqueOperands);
        info.addOperandCount(totalOperands);
        info.addUniqueOperandCount(uniqueOperands.size());
        int uniqueOperandCount = uniqueOperands.size();
        int uniqueOperatorCount = uniqueOperators.size();
        info.setProgramLength(info.getOperatorCount() + totalOperands);
        info.setProgramVocabulary(uniqueOperatorCount + uniqueOperandCount);
        info.setProgramVolume((double)info.getProgramLength() * this.log2(info.getProgramVocabulary()));
        if (totalOperands > 0) {
            info.setDifficulty((double)uniqueOperatorCount / 2.0 * (double)totalOperands / (double)uniqueOperandCount);
        }
        if ((difficulty = info.getDifficulty()) != 0.0) {
            info.setProgramLevel(1.0 / difficulty);
        }
        double effort = info.getProgramVolume() * difficulty;
        info.setImplementationEffort(effort);
        info.setImplementationTime(effort / 64800.0);
        info.setNumberOfDeliveredBugs(Math.pow(effort, 0.6666666865348816) / 3000.0);
    }

    private double log2(double d) {
        return Math.log(d) / Math.log(2.0);
    }

    private int determineOperands(MetricsResource resource, ASTNode md, Set<String> uniqueOperands) {
        int totalOperands = 0;
        totalOperands += this.resolveLiteralOperands(resource, md, uniqueOperands);
        return totalOperands += this.resolveNonReservedWords(resource, md, uniqueOperands, NON_RESERVED_NAMES);
    }

    private int resolveNonReservedWords(MetricsResource resource, ASTNode md, Set<String> uniqueOperands, int[] types) {
        String nodeName = null;
        int nodeType = 0;
        ASTNode node = null;
        List<ASTNode> l = resource.getTypedNodeList(md, types);
        if (l.size() > 0) {
            Iterator<ASTNode> it = l.iterator();
            while (it.hasNext()) {
                nodeName = "";
                node = it.next();
                nodeType = node.getNodeType();
                if (nodeType == 32) {
                    nodeName = ((MethodInvocation)node).getName().getIdentifier();
                } else if (nodeType == 48) {
                    nodeName = ((SuperMethodInvocation)node).getName().getIdentifier();
                } else if (nodeType == 17) {
                    nodeName = md.getNodeType() == 55 ? ((TypeDeclaration)md).getName().getIdentifier() : ((MethodDeclaration)md).getName().getIdentifier();
                }
                uniqueOperands.add(nodeName);
            }
        }
        return l.size();
    }

    private int resolveLiteralOperands(MetricsResource resource, ASTNode md, Set<String> uniqueOperands) {
        List<ASTNode> l = resource.getTypedNodeList(md, LITERAL_TYPES);
        Object var5_5 = null;
        int totalOperands = 0;
        for (ASTNode aSTNode : l) {
            if (aSTNode instanceof SimpleName) {
                uniqueOperands.add(((SimpleName)aSTNode).getFullyQualifiedName());
                ++totalOperands;
                continue;
            }
            Object object = ((Expression)aSTNode).resolveConstantExpressionValue();
            if (object == null) continue;
            uniqueOperands.add(object.toString());
            ++totalOperands;
        }
        return totalOperands;
    }

    private int determineLiteralOperators(String strippedSource, Set<String> uniqueOperators) {
        int totalLiteralOperators = 0;
        StringTokenizer tokenizer = new StringTokenizer(strippedSource, " ");
        String tempString = null;
        block0: while (tokenizer.hasMoreTokens()) {
            tempString = tokenizer.nextToken();
            for (String literalOperator : LITERAL_OPERATORS) {
                if (!tempString.startsWith(literalOperator)) continue;
                ++totalLiteralOperators;
                uniqueOperators.add(literalOperator);
                continue block0;
            }
        }
        return totalLiteralOperators;
    }

    private int determineOperators(ASTNode node, Set<String> uniqueOperators) {
        int totalOperators = 0;
        if (node != null) {
            StringBuilder sourceBuffer = this.getStrippedSource(node);
            totalOperators += this.determineLiteralOperators(sourceBuffer.toString(), uniqueOperators);
            int bufferSize = sourceBuffer.length();
            Character currentChar = null;
            Map temporaryMap = null;
            StringBuilder operatorStringBuilder = new StringBuilder(2);
            boolean inOperator = false;
            int i = 0;
            while (i < bufferSize) {
                currentChar = Character.valueOf(sourceBuffer.charAt(i));
                if (!Character.isJavaIdentifierPart(currentChar.charValue()) && !Character.isWhitespace(currentChar.charValue())) {
                    if (currentChar == DOT) {
                        if (i + 1 >= bufferSize || !Character.isDigit(sourceBuffer.charAt(i + 1))) {
                            ++totalOperators;
                            uniqueOperators.add(".");
                        }
                    } else {
                        inOperator = temporaryMap != null;
                        Map map = temporaryMap = inOperator ? (Map)temporaryMap.get(currentChar) : (Map)REGULAR_OPERATORS[HalsteadInformation.hashValue(currentChar)];
                        if (temporaryMap != null) {
                            operatorStringBuilder.append(currentChar);
                        } else {
                            int n = totalOperators = this.addOperatorToSet(uniqueOperators, operatorStringBuilder) ? totalOperators + 1 : totalOperators;
                            if (inOperator) {
                                --i;
                                inOperator = false;
                            }
                        }
                    }
                } else {
                    totalOperators = this.addOperatorToSet(uniqueOperators, operatorStringBuilder) ? totalOperators + 1 : totalOperators;
                    temporaryMap = null;
                }
                ++i;
            }
        }
        return totalOperators;
    }

    private boolean addOperatorToSet(Set<String> uniqueOperators, StringBuilder operatorStringBuilder) {
        if (operatorStringBuilder.length() > 0) {
            uniqueOperators.add(operatorStringBuilder.toString());
            operatorStringBuilder.delete(0, operatorStringBuilder.length());
            return true;
        }
        return false;
    }

    private StringBuilder getStrippedSource(ASTNode md) {
        StringBuilder source = new StringBuilder(md.toString());
        int sourceLength = source.length();
        boolean inJavadoc = false;
        boolean inStringLiteral = false;
        int temporaryIndex = 0;
        int i = 0;
        while (i < sourceLength) {
            char temporaryChar = source.charAt(i);
            if (!inJavadoc && !inStringLiteral) {
                if (temporaryChar == DIVIDE_OR_FORWARDSLASH.charValue() && i + 2 < sourceLength && source.charAt(i + 1) == MULTIPLY_OR_STAR.charValue() && source.charAt(i + 2) == MULTIPLY_OR_STAR.charValue()) {
                    temporaryIndex = i;
                    inJavadoc = true;
                } else if (temporaryChar == QUOTE_CHARACTER.charValue() && source.charAt(i - 1) != ESCAPE_CHARACTER.charValue()) {
                    temporaryIndex = i;
                    inStringLiteral = true;
                }
            } else if (inJavadoc && temporaryChar == DIVIDE_OR_FORWARDSLASH.charValue() && source.charAt(i - 1) == MULTIPLY_OR_STAR.charValue()) {
                source.replace(temporaryIndex, i + 1, "");
                i = temporaryIndex - 1;
                sourceLength = source.length();
                inJavadoc = false;
            } else if (inStringLiteral && temporaryChar == QUOTE_CHARACTER.charValue() && source.charAt(i - 1) != ESCAPE_CHARACTER.charValue()) {
                source.replace(temporaryIndex, i + 1, "");
                i = temporaryIndex - 1;
                sourceLength = source.length();
                inStringLiteral = false;
            }
            ++i;
        }
        return source;
    }
}

