/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java.internal.measure.dependency;

import com.ibm.rsaz.analysis.architecture.core.data.TypeData;
import com.ibm.xtools.analysis.metrics.java.AbstractMeasurement;
import com.ibm.xtools.analysis.metrics.java.MetricsProvider;
import com.ibm.xtools.analysis.metrics.java.MetricsResource;
import com.ibm.xtools.analysis.metrics.java.data.ClassData;
import com.ibm.xtools.analysis.metrics.java.data.PackageData;
import com.ibm.xtools.analysis.metrics.java.data.ProjectData;
import com.ibm.xtools.analysis.metrics.java.data.util.DependencyInfo;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class CouplingInformation
extends AbstractMeasurement {
    @Override
    public void projectMeasure(ProjectData projectData, PackageData packageData) {
        DependencyInfo pdi = projectData.getDependencyInfo();
        DependencyInfo di = packageData.getDependencyInfo();
        pdi.addAfferentCoupling(di.getAfferentCoupling());
        pdi.addEfferentCoupling(di.getEfferentCoupling());
        int efferent = pdi.getEfferentCoupling();
        double efferentAndCoupling = (double)pdi.getAfferentCoupling() + (double)efferent;
        if (efferentAndCoupling != 0.0) {
            pdi.setInstability((double)efferent / efferentAndCoupling);
        }
    }

    @Override
    public void packageMeasure(MetricsResource resource, PackageData packageData, ClassData classData) {
        DependencyInfo pdi = packageData.getDependencyInfo();
        DependencyInfo di = classData.getDependencyInfo();
        pdi.addAfferentCoupling(di.getAfferentCoupling());
        pdi.addEfferentCoupling(di.getEfferentCoupling());
        int efferent = pdi.getEfferentCoupling();
        double efferentAndCoupling = (double)pdi.getAfferentCoupling() + (double)efferent;
        if (efferentAndCoupling != 0.0) {
            pdi.setInstability((double)efferent / efferentAndCoupling);
        }
    }

    @Override
    public void classMeasure(MetricsResource resource, ClassData classData, TypeDeclaration td) {
        DependencyInfo di = classData.getDependencyInfo();
        CompilationUnit cu = resource.getResourceCompUnit();
        MetricsProvider provider = resource.getProvider();
        IType itype = this.findTypeForTypeDeclaration(resource, cu, td);
        if (itype != null) {
            List imports = cu.imports();
            if (imports != null && imports.size() > 0) {
                di.setEfferentCoupling(1);
            } else {
                di.setEfferentCoupling(0);
            }
            Collection<TypeData> dependants = provider.getTypeDependants(itype);
            if (dependants != null) {
                di.setAfferentCoupling(dependants.size());
            } else {
                di.setAfferentCoupling(0);
            }
            int efferent = di.getEfferentCoupling();
            int afferent = di.getAfferentCoupling();
            if (afferent + efferent != 0) {
                di.setInstability((double)efferent / ((double)afferent + (double)efferent));
            } else {
                di.setInstability(0.0);
            }
        }
    }

    private IType findTypeForTypeDeclaration(MetricsResource metricsResource, CompilationUnit compilationUnit, TypeDeclaration td) {
        StringBuilder typeName = new StringBuilder();
        PackageDeclaration pkg = compilationUnit.getPackage();
        if (pkg != null) {
            String packageName = pkg.getName().getFullyQualifiedName();
            typeName.append(packageName);
            typeName.append(".");
        }
        typeName.append(td.getName().getFullyQualifiedName());
        IJavaElement element = JavaCore.create((IResource)metricsResource.getIResource());
        if (element.getElementType() == 5) {
            ICompilationUnit cu = (ICompilationUnit)element;
            try {
                IType[] types = cu.getAllTypes();
                int i = 0;
                while (i < types.length) {
                    String name2 = types[i].getFullyQualifiedName('.');
                    if (name2.equals(typeName.toString())) {
                        return types[i];
                    }
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return null;
    }

    @Override
    public boolean collectingCouplingInformation() {
        return true;
    }
}

