/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java.internal.measure.complexity;

import com.ibm.xtools.analysis.metrics.java.AbstractMeasurement;
import com.ibm.xtools.analysis.metrics.java.MetricsResource;
import com.ibm.xtools.analysis.metrics.java.data.ClassData;
import com.ibm.xtools.analysis.metrics.java.data.MethodData;
import com.ibm.xtools.analysis.metrics.java.data.PackageData;
import com.ibm.xtools.analysis.metrics.java.data.ProjectData;
import com.ibm.xtools.analysis.metrics.java.data.util.CyclomaticComplexityInfo;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class CyclomaticComplexityInformation
extends AbstractMeasurement {
    @Override
    public void projectMeasure(ProjectData projectData, PackageData packageData) {
        CyclomaticComplexityInfo projectComplexityInfo = projectData.getCyclomaticComplexityInfo();
        CyclomaticComplexityInfo packageComplexityInfo = packageData.getCyclomaticComplexityInfo();
        projectComplexityInfo.addBaseComplexity(packageComplexityInfo.getBaseComplexity());
        projectComplexityInfo.addCaseComplexity(packageComplexityInfo.getCaseComplexity());
        projectComplexityInfo.addCatchComplexity(packageComplexityInfo.getCatchComplexity());
        projectComplexityInfo.addConditionalComplexity(packageComplexityInfo.getConditionalComplexity());
        projectComplexityInfo.addOperatorComplexity(packageComplexityInfo.getOperatorComplexity());
    }

    @Override
    public void packageMeasure(MetricsResource resource, PackageData packageData, ClassData classData) {
        int operatorComplexity;
        int conditionalComplexity;
        int catchComplexity;
        int caseComplexity;
        CyclomaticComplexityInfo packageComplexityInfo = packageData.getCyclomaticComplexityInfo();
        CyclomaticComplexityInfo classComplexityInfo = classData.getCyclomaticComplexityInfo();
        int baseComplexity = classComplexityInfo.getBaseComplexity();
        if (baseComplexity + (caseComplexity = classComplexityInfo.getCaseComplexity()) + (catchComplexity = classComplexityInfo.getCatchComplexity()) + (conditionalComplexity = classComplexityInfo.getConditionalComplexity()) + (operatorComplexity = classComplexityInfo.getOperatorComplexity()) > 0) {
            packageComplexityInfo.addBaseComplexity(baseComplexity);
            packageComplexityInfo.addCaseComplexity(caseComplexity);
            packageComplexityInfo.addCatchComplexity(catchComplexity);
            packageComplexityInfo.addConditionalComplexity(conditionalComplexity);
            packageComplexityInfo.addOperatorComplexity(operatorComplexity);
            packageData.setCyclomaticMethodsCount(packageData.getCyclomaticMethodsCount() + classData.getCyclomaticMethodsCount());
        }
    }

    @Override
    public void classMeasure(MetricsResource resource, ClassData classData, TypeDeclaration td) {
        CyclomaticComplexityInfo classComplexityInfo = classData.getCyclomaticComplexityInfo();
        for (MethodData methodData : classData.getMethodDataList()) {
            CyclomaticComplexityInfo methodInfo = methodData.getCyclomaticComplexityInfo();
            int baseComplexity = methodInfo.getBaseComplexity();
            int caseComplexity = methodInfo.getCaseComplexity();
            int catchComplexity = methodInfo.getCatchComplexity();
            int conditionalComplexity = methodInfo.getConditionalComplexity();
            int operatorComplexity = methodInfo.getOperatorComplexity();
            classComplexityInfo.addBaseComplexity(baseComplexity);
            classComplexityInfo.addCaseComplexity(caseComplexity);
            classComplexityInfo.addCatchComplexity(catchComplexity);
            classComplexityInfo.addConditionalComplexity(conditionalComplexity);
            classComplexityInfo.addOperatorComplexity(operatorComplexity);
            if (baseComplexity + caseComplexity + catchComplexity + conditionalComplexity + operatorComplexity <= 0) continue;
            classData.setCyclomaticMethodsCount(classData.getCyclomaticMethodsCount() + 1);
        }
    }

    @Override
    public void methodMeasure(MetricsResource resource, MethodData methodData, MethodDeclaration md) {
        CyclomaticComplexityInfo info = methodData.getCyclomaticComplexityInfo();
        if (resource.countTypedNodes((ASTNode)md, 8) > 0) {
            info.setBaseComplexity(1);
            CyclomaticComplexityASTVisitor visitor = new CyclomaticComplexityASTVisitor(info);
            md.accept((ASTVisitor)visitor);
        }
    }

    private class CyclomaticComplexityASTVisitor
    extends ASTVisitor {
        private CyclomaticComplexityInfo info;

        public CyclomaticComplexityASTVisitor(CyclomaticComplexityInfo infoVal) {
            this.info = infoVal;
        }

        public void preVisit(ASTNode node) {
            int nodeType = node.getNodeType();
            switch (nodeType) {
                case 19: 
                case 24: 
                case 25: 
                case 61: 
                case 70: {
                    this.info.addBaseComplexity(1);
                }
            }
        }

        public boolean visit(SwitchCase node) {
            if (!node.isDefault()) {
                this.info.addCaseComplexity(1);
            }
            return true;
        }

        public boolean visit(CatchClause node) {
            this.info.addCatchComplexity(1);
            return true;
        }

        public boolean visit(ConditionalExpression node) {
            this.info.addConditionalComplexity(1);
            return true;
        }

        public boolean visit(InfixExpression node) {
            String op = node.getOperator().toString();
            if (InfixExpression.Operator.CONDITIONAL_OR.toString().equals(op) || InfixExpression.Operator.CONDITIONAL_AND.toString().equals(op)) {
                this.info.addOperatorComplexity(1);
            }
            return true;
        }
    }
}

