/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtools.analysis.metrics.java.internal.measure.complexity;

import com.ibm.xtools.analysis.metrics.java.AbstractMeasurement;
import com.ibm.xtools.analysis.metrics.java.MetricsResource;
import com.ibm.xtools.analysis.metrics.java.data.ClassData;
import com.ibm.xtools.analysis.metrics.java.data.MethodData;
import com.ibm.xtools.analysis.metrics.java.data.PackageData;
import com.ibm.xtools.analysis.metrics.java.data.ProjectData;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class BlockDepthInformation
extends AbstractMeasurement {
    @Override
    public void projectMeasure(ProjectData projectData, PackageData packageData) {
        double projectBlockDepth = projectData.getBlockDepthMetric();
        double packageBlockDepth = packageData.getBlockDepthMetric();
        int projectMethods = projectData.getBlockDepthMethodCount();
        int packageMethods = packageData.getBlockDepthMethodCount();
        projectData.setBlockDepthMetric(projectBlockDepth += packageBlockDepth);
        projectData.setMethodCount(packageMethods += projectMethods);
    }

    @Override
    public void packageMeasure(MetricsResource resource, PackageData packageData, ClassData classData) {
        double packageBlockDepth = packageData.getBlockDepthMetric();
        double classBlockDepth = classData.getBlockDepthMetric();
        int packageMethods = packageData.getBlockDepthMethodCount();
        int classMethods = classData.getBlockDepthMethodCount();
        packageData.setBlockDepthMetric(packageBlockDepth += classBlockDepth);
        packageData.setBlockDepthMethodCount(packageMethods += classMethods);
    }

    @Override
    public void classMeasure(MetricsResource resource, ClassData classData, TypeDeclaration td) {
        double classBlockDepth = 0.0;
        int iCtr = 0;
        for (MethodData methodData : classData.getMethodDataList()) {
            double depth = methodData.getBlockDepthMetric();
            if (!(depth > 0.0)) continue;
            classBlockDepth += depth;
            ++iCtr;
        }
        if (iCtr > 0) {
            classData.setBlockDepthMetric(classBlockDepth);
            classData.setBlockDepthMethodCount(iCtr);
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public void methodMeasure(MetricsResource resource, MethodData methodData, MethodDeclaration md) {
        maxDepth = 0;
        l = resource.getTypedNodeList((ASTNode)md, 8, true);
        it = l.iterator();
        while (it.hasNext()) {
            block = (Block)it.next();
            if (resource.countTypedNodes((ASTNode)block, 8, true) - 1 <= 0) continue;
            it.remove();
        }
        for (Block block : l) {
            depth = 1;
            parent = block.getParent();
            ** GOTO lbl19
            {
                parent = parent.getParent();
                do {
                    if (parent != null && !parent.equals((Object)md) && parent.getNodeType() != 8) continue block2;
                    if (parent == null) continue;
                    ++depth;
                    parent = parent.getParent();
lbl19:
                    // 3 sources

                } while (parent != null && !parent.equals((Object)md));
            }
            if (depth <= maxDepth) continue;
            maxDepth = depth;
        }
        methodData.setBlockDepthMetric(maxDepth);
    }
}

